-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Lights.Container;
with Jpats_Electrical;
with Jpats_Electrical_Types;
with Jpats_Landing_Gear;
with Jpats_Landing_Gear_Types;
with Log;

package body Jpats_Lights.Controller is

   procedure Initialize
   is
      package Ctnr              renames Container;
      package Ldg_Light         renames Ctnr.Landing_Light;
      package Taxi_Light        renames Ctnr.Taxi_Light;
      package Util_Light        renames Ctnr.Utility_Lighting;
      package Pwr_Supply        renames Ctnr.Wing_Light_Power_Supply;
      package Anti_Coll_Lights  renames Ctnr.Anti_Collision_Lights;
      package Nav_Lights        renames Ctnr.Navigation_Lights;
      package Position_Lights   renames Ctnr.Position_Lights;
      package Flood_Lights      renames Ctnr.Flood_Lighting;
      package Console_Lights    renames Ctnr.Console_Lighting;
      package Instrument_Lights renames Ctnr.Instrument_Lighting;

      The_Ldg_Light             : Ldg_Light.Instance         renames Ctnr.This_Subsystem.The_Landing_Light;
      The_Taxi_Light            : Taxi_Light.Instance        renames Ctnr.This_Subsystem.The_Taxi_Light;
      The_Util_Light            : Util_Light.Instance        renames Ctnr.This_Subsystem.The_Utility_Light;
      The_Left_Wing_Pwr_Supply  : Pwr_Supply.Instance        renames Ctnr.This_Subsystem.The_Left_Wing_Power_Supply;
      The_Right_Wing_Pwr_Supply : Pwr_Supply.Instance        renames Ctnr.This_Subsystem.The_Right_Wing_Power_Supply;
      The_Anti_Coll_Lights      : Anti_Coll_Lights.Instance  renames Ctnr.This_Subsystem.The_Anti_Collision_Lights;
      The_Nav_Lights            : Nav_Lights.Instance        renames Ctnr.This_Subsystem.The_Navigation_Lights;
      The_Position_Lights       : Position_Lights.Instance   renames Ctnr.This_Subsystem.The_Position_Lights;
      The_Flood_Lights          : Flood_Lights.Instance      renames Ctnr.This_Subsystem.The_Flood_Lights;
      The_Console_Lights        : Console_Lights.Instance    renames Ctnr.This_Subsystem.The_Console_Lights;
      The_Instrument_Lights     : Instrument_Lights.Instance renames Ctnr.This_Subsystem.The_Instrument_Lights;
   begin
      Ldg_Light.Initialize(The_Ldg_Light);
      Taxi_Light.Initialize(The_Taxi_Light);
      Util_Light.Initialize(The_Util_Light);
      Pwr_Supply.Initialize(The_Left_Wing_Pwr_Supply);
      Pwr_Supply.Initialize(The_Right_Wing_Pwr_Supply);
      Anti_Coll_Lights.Initialize(The_Anti_Coll_Lights);
      Nav_Lights.Initialize(The_Nav_Lights);
      Position_Lights.Initialize(The_Position_Lights);
      Flood_Lights.Initialize(The_Flood_Lights);
      Console_Lights.Initialize(The_Console_Lights);
      Instrument_Lights.Initialize(The_Instrument_Lights);
   exception
      when others =>
         Log.Report("Jpats_Lights.Controller.Initialize()");
         raise;
   end Initialize;

   procedure Update
     (Iconst : in Float)
   is
      package Ctnr              renames Container;
      package Ele               renames Jpats_Electrical;
      package Ele_T             renames Jpats_Electrical_Types;
      package Ldg_Light         renames Ctnr.Landing_Light;
      package Taxi_Light        renames Ctnr.Taxi_Light;
      package Util_Light        renames Ctnr.Utility_Lighting;
      package Gear              renames Jpats_Landing_Gear;
      package Gear_T            renames Jpats_Landing_Gear_Types;
      package Pwr_Supply        renames Ctnr.Wing_Light_Power_Supply;
      package Anti_Coll_Lights  renames Ctnr.Anti_Collision_Lights;
      package Nav_Lights        renames Ctnr.Navigation_Lights;
      package Position_Lights   renames Ctnr.Position_Lights;
      package Flood_Lights      renames Ctnr.Flood_Lighting;
      package Console_Lights    renames Ctnr.Console_Lighting;
      package Instrument_Lights renames Ctnr.Instrument_Lighting;

      The_Ldg_Light             : Ldg_Light.Instance         renames Ctnr.This_Subsystem.The_Landing_Light;
      The_Taxi_Light            : Taxi_Light.Instance        renames Ctnr.This_Subsystem.The_Taxi_Light;
      The_Util_Light            : Util_Light.Instance        renames Ctnr.This_Subsystem.The_Utility_Light;
      The_Left_Wing_Pwr_Supply  : Pwr_Supply.Instance        renames Ctnr.This_Subsystem.The_Left_Wing_Power_Supply;
      The_Right_Wing_Pwr_Supply : Pwr_Supply.Instance        renames Ctnr.This_Subsystem.The_Right_Wing_Power_Supply;
      The_Anti_Coll_Lights      : Anti_Coll_Lights.Instance  renames Ctnr.This_Subsystem.The_Anti_Collision_Lights;
      The_Nav_Lights            : Nav_Lights.Instance        renames Ctnr.This_Subsystem.The_Navigation_Lights;
      The_Position_Lights       : Position_Lights.Instance   renames Ctnr.This_Subsystem.The_Position_Lights;
      The_Flood_Lights          : Flood_Lights.Instance      renames Ctnr.This_Subsystem.The_Flood_Lights;
      The_Console_Lights        : Console_Lights.Instance    renames Ctnr.This_Subsystem.The_Console_Lights;
      The_Instrument_Lights     : Instrument_Lights.Instance renames Ctnr.This_Subsystem.The_Instrument_Lights;

      Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;

      K1 : Boolean;

   begin

      -------------------
      -- LANDING LIGHT --
      -------------------
      Ldg_Light.Update
        (An_Instance => The_Ldg_Light,
         Request     => (Ele.Is_Powered (Ele_T.Ldg_Lts_Cb) and
                         Io.Ldg_Lts_Sw and
                         Gear.Is_Closed(Gear_T.Landing_Gear_Down_And_Locked)));

      ----------------
      -- TAXI LIGHT --
      ----------------
      Taxi_Light.Update
           (An_Instance => The_Taxi_Light,
            Request     => (Ele.Is_Powered (Ele_T.Taxi_Lts_Cb) and
                            Io.Taxi_Lts_Sw and
                            Gear.Is_Closed(Gear_T.Landing_Gear_Down_And_Locked)));

      -------------------
      -- UTILITY LIGHT --
      -------------------
      Util_Light.Update
        (An_Instance => The_Util_Light,
         Request     => Ele.Is_Powered (Ele_T.Util_Lt_Cb));

      Io.Cockpit_Utility_Lt := Util_Light.Is_On (The_Util_Light);

      ----------------------------
      -- LEFT WING POWER SUPPLY --
      ----------------------------
      Pwr_Supply.Update
        (An_Instance        => The_Left_Wing_Pwr_Supply,
         Anti_Collision_In  => Ele.Is_Powered (Ele_T.Coll_Lts_Cb) and Io.Anti_Collision_Lts_Sw,
         Nav_In             => Ele.Is_Powered (Ele_T.Nav_Lts_Cb) and Io.Cont_Nav_Lts_Sw);

      -----------------------------
      -- RIGHT WING POWER SUPPLY --
      -----------------------------
      Pwr_Supply.Update
        (An_Instance        => The_Right_Wing_Pwr_Supply,
         Anti_Collision_In  => Ele.Is_Powered (Ele_T.Coll_Lts_Cb) and Io.Anti_Collision_Lts_Sw,
         Nav_In             => Ele.Is_Powered (Ele_T.Nav_Lts_Cb) and Io.Cont_Nav_Lts_Sw);


      ---------------------------
      -- ANTI COLLISION LIGHTS --
      ---------------------------
      Anti_Coll_Lights.Update
        (An_Instance   => The_Anti_Coll_Lights,
         Left_Request  => Pwr_Supply.Anti_Collision_Out (The_Left_Wing_Pwr_Supply),
         Right_Request => Pwr_Supply.Anti_Collision_Out (The_Right_Wing_Pwr_Supply));


      -----------------------
      -- NAVIGATION LIGHTS --
      -----------------------
      Nav_Lights.Update
        (An_Instance   => The_Nav_Lights,
         Left_Request  => Pwr_Supply.Nav_Out (The_Left_Wing_Pwr_Supply),
         Right_Request => Pwr_Supply.Nav_Out (The_Right_Wing_Pwr_Supply));


      ---------------------
      -- POSITION LIGHTS --
      ---------------------
      Position_Lights.Update
        (An_Instance   => The_Position_Lights,
         Left_Request  => Pwr_Supply.Nav_Out (The_Left_Wing_Pwr_Supply),
         Right_Request => Pwr_Supply.Nav_Out (The_Right_Wing_Pwr_Supply));


      --------------------
      -- CONSOLE LIGHTS --
      --------------------

      Console_Lights.Update
        (An_Instance   => The_Console_Lights,
         Powered       => Ele.Is_Powered (Ele_T.Side_Lts_Cb) and Io.Side_Pnl_On_Sw,
         Rheo_Position => Io.Side_Pnl_Ltg_Cont);

      Io.Side_Pnl_Dimmer_Pwr := Console_Lights.Is_Powered (The_Console_Lights);
      Io.Side_Pnl_Dimmer_Cont := Console_Lights.Voltage_Out (The_Console_Lights);

      ------------------
      -- FLOOD LIGHTS --
      ------------------

      Flood_Lights.Update
        (An_Instance   => The_Flood_Lights,
         Powered       => Ele.Is_Powered (Ele_T.Fld_Lts_Cb) and Io.Flood_Ltg_On_Sw,
         Rheo_Position => 0.0);

      Io.Flood_Lts_Dimmer_Pwr := Flood_Lights.Is_Powered (The_Flood_Lights);

      -----------------------
      -- INSTRUMENT LIGHTS --
      -----------------------

      K1 := Io.Instrument_Pnl_On_Sw and Ele.Is_Powered (Ele_T.Inst_Lts_Cb);
      Io.Fwd_Panel_Ltg_Relay_Cont := K1;

      Instrument_Lights.Update
        (An_Instance   => The_Instrument_Lights,
         Powered       => K1 or else Ele.Is_Powered (Ele_T.Inst_Lts_Cb),
         Rheo_Position => Io.Instrument_Pnl_Ltg_Cont);

      Io.Instrument_Pnl_Dimmer_Pwr  := Instrument_Lights.Is_Powered (The_Instrument_Lights);
      Io.Instrument_Pnl_Dimmer_Cont := Instrument_Lights.Voltage_Out (The_Instrument_Lights);


      ----------------------
      -- EMERGENCY LIGHTS --
      ----------------------

--       Io.Emergency_5v_Ltg_Relay := ((Ele.Aux_Batt_Mnt_Is_Powered           --  this whole could be fwd aux battery bus is powered
--                                     and Ele.Is_Powered (Ele_T.Aux_Batt_Cb)
--                                      and Ele.Is_Closed (Ele_T.Auxiliary_Battery_Relay))
--                                     or
--                                     (not Ele.Is_Closed (Ele_T.Auxiliary_Battery_Relay)
--                                      and Ele.Is_Powered(Ele_T.Forward_Battery_Bus)));  --<<<< should forward battery bus is powered


--       Io.Emergency_5v_Ltg_Relay := Ele.Is_Powered (Ele_T.Forward_Auxiliary_Battery_Bus);
--       Io.Emergency_Dimmer_Pwr := Ele.Is_Powered (Ele_T.Forward_Auxiliary_Battery_Bus);   --<<<< should forward aux battery bus is powered

      Io.Emergency_5v_Ltg_Relay := Ele.Is_Powered (Ele_T.Stby_Lts_Cb);
      Io.Emergency_Dimmer_Pwr := Ele.Is_Powered (Ele_T.Stby_Lts_Cb);   --<<<< should forward aux battery bus is powered

      if Instrument_Lights.Is_Powered (The_Instrument_Lights) then
         Io.Emergency_Dimmer_Cont := Io.Instrument_Pnl_Dimmer_Cont;
      else
         Io.Emergency_Dimmer_Cont := 9.99;
      end if;

      -----------------
      -- BATTERY BUS --
      -----------------

      Io.Battery_Bus_Dimmer_Pwr := true;
      Io.Battery_Bus_Dimmer_Control := 9.99;


   exception
      when others =>
         Log.Report("Jpats_Lights.Controller.Update()");
         raise;
   end Update;

end Jpats_Lights.Controller;
