-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Light_G;
with Wing_Lights_G;
with Rheostat_Controlled_Lighting_G;
with Wing_Lights_Power_Supply_G;

with Electrical_Units_Types;

private package Jpats_Lights.Container is

-- landing gear lights
   package Landing_Light is new Light_G
     (Current_Type  => Electrical_Units_Types.Amps,
      Light_On_Load => 7.5,
      Package_Name  => "Jpats_Lights.Container.Landing_Light");
   package Taxi_Light is new Light_G
     (Current_Type  => Electrical_Units_Types.Amps,
      Light_On_Load => 6.0,
      Package_Name  => "Jpats_Lights.Container.Taxi_Light");

-- wing lights
   package Wing_Light is new Light_G
     (Current_Type  => Electrical_Units_Types.Amps,
      Light_On_Load => 1.0,
      Package_Name  => "Jpats_Lights.Container.Wing_Light");
   package Navigation_Lights is new Wing_Lights_G
     (Current_Type       => Electrical_Units_Types.Amps,
      Light_Type         => Wing_Light.Instance,
      Turn_On_A_Light    => Wing_Light.Turn_On,
      Turn_Off_A_Light   => Wing_Light.Turn_Off,
      A_Lights_Load      => Wing_Light.Load,
      A_Light_Is_On      => Wing_Light.Is_On,
      Initialize_A_Light => Wing_Light.Initialize,
      Update_A_Light     => Wing_Light.Update,
      Package_Name       => "Jpats_Lights.Container.Navigation_Lights");
   package Anti_Collision_Lights is new Wing_Lights_G
     (Current_Type       => Electrical_Units_Types.Amps,
      Light_Type         => Wing_Light.Instance,
      Turn_On_A_Light    => Wing_Light.Turn_On,
      Turn_Off_A_Light   => Wing_Light.Turn_Off,
      A_Lights_Load      => Wing_Light.Load,
      A_Light_Is_On      => Wing_Light.Is_On,
      Initialize_A_Light => Wing_Light.Initialize,
      Update_A_Light     => Wing_Light.Update,
      Package_Name       => "Jpats_Lights.Container.Anti_Collision_Lights");
   package Position_Lights is new Wing_Lights_G
     (Current_Type       => Electrical_Units_Types.Amps,
      Light_Type         => Wing_Light.Instance,
      Turn_On_A_Light    => Wing_Light.Turn_On,
      Turn_Off_A_Light   => Wing_Light.Turn_Off,
      A_Lights_Load      => Wing_Light.Load,
      A_Light_Is_On      => Wing_Light.Is_On,
      Initialize_A_Light => Wing_Light.Initialize,
      Update_A_Light     => Wing_Light.Update,
      Package_Name       => "Jpats_Lights.Container.Position_Lights");

-- wing light's power supplys
   package Wing_Light_Power_Supply is new Wing_Lights_Power_Supply_G
     (Package_Name  => "Jpats_Lights.Container.Wing_Light_Power_Supply");

-- internal lighting
   package Console_Lighting is new Rheostat_Controlled_Lighting_G
     (Current_Type => Electrical_Units_Types.Amps,
      Package_Name => "Jpats_Lights.Container.Console_Lighting");
   package Flood_Lighting is new Rheostat_Controlled_Lighting_G
     (Current_Type => Electrical_Units_Types.Amps,
      Package_Name => "Jpats_Lights.Container.Flood_Lighting");
   package Instrument_Lighting is new Rheostat_Controlled_Lighting_G
     (Current_Type => Electrical_Units_Types.Amps,
      Package_Name => "Jpats_Lights.Container.Instrument_Lighting");

-- map light
   package Utility_Lighting is new Light_G
     (Current_Type  => Electrical_Units_Types.Amps,
      Light_On_Load => 3.0,
      Package_Name  => "Jpats_Lights.Container.Utility_Lighting");

   type Instance is
      record
         The_Landing_Light           : Landing_Light.Instance;
         The_Taxi_Light              : Taxi_Light.Instance;
         The_Navigation_Lights       : Navigation_Lights.Instance;
         The_Anti_Collision_Lights   : Anti_Collision_Lights.Instance;
         The_Position_Lights         : Position_Lights.Instance;
         The_Console_Lights          : Console_Lighting.Instance;
         The_Flood_Lights            : Flood_Lighting.Instance;
         The_Instrument_Lights       : Instrument_Lighting.Instance;
         The_Utility_Light           : Utility_Lighting.Instance;
         The_Left_Wing_Power_Supply  : Wing_Light_Power_Supply.Instance;
         The_Right_Wing_Power_Supply : Wing_Light_Power_Supply.Instance;
      end record;
   This_Subsystem : Instance;


   Io_Size : constant Integer := 4;

   type Io_Interface_Instance is
      record
         -- digital input
         Lamp_Test_Sw                : Boolean := False;
         Ldg_Lts_Sw                  : Boolean := False;
         Taxi_Lts_Sw                 : Boolean := False;
         Anti_Collision_Lts_Sw       : Boolean := False;
         Cont_Nav_Lts_Sw             : Boolean := False;
         Instrument_Pnl_On_Sw        : Boolean := False;
         Side_Pnl_On_Sw              : Boolean := False;
         Flood_Ltg_On_Sw             : Boolean := False;
         -- digital output
--         Ann_Pnl_Dimming_Input       : Boolean;
         Instrument_Pnl_Dimmer_Pwr   : Boolean := False;
         Side_Pnl_Dimmer_Pwr         : Boolean := False;
         Emergency_Dimmer_Pwr        : Boolean := False;
         Emergency_5v_Ltg_Relay      : Boolean := False;
         Fwd_Panel_Ltg_Relay_Cont    : Boolean := False;
         Flood_Lts_Dimmer_Pwr        : Boolean := False;
         Cockpit_Utility_Lt          : Boolean := False;
         Battery_Bus_Dimmer_Pwr      : Boolean := False;
         -- analog input
         Instrument_Pnl_Ltg_Cont     : Float := 0.0;
         Side_Pnl_Ltg_Cont           : Float := 0.0;
         -- analog output
         Instrument_Pnl_Dimmer_Cont  : Float := 0.0;
         Side_Pnl_Dimmer_Cont        : Float := 0.0;
         Emergency_Dimmer_Cont       : Float := 0.0;
         Battery_Bus_Dimmer_Control  : Float := 0.0;

         -- spare
         Spare_Io_1                  : Boolean := False;
      end record;

   for Io_Interface_Instance use
      record
         -- spare
         Spare_Io_1                  at  000*Io_Size range 0..31;
         -- digital input
         Lamp_Test_Sw                at  001*Io_Size range 0..31;
         Ldg_Lts_Sw                  at  002*Io_Size range 0..31;
         Taxi_Lts_Sw                 at  003*Io_Size range 0..31;
         Anti_Collision_Lts_Sw       at  004*Io_Size range 0..31;
         Cont_Nav_Lts_Sw             at  005*Io_Size range 0..31;
         Instrument_Pnl_On_Sw        at  006*Io_Size range 0..31;
         Side_Pnl_On_Sw              at  007*Io_Size range 0..31;
         Flood_Ltg_On_Sw             at  008*Io_Size range 0..31;
         -- digital output
--         Ann_Pnl_Dimming_Input       : Boolean;
         Instrument_Pnl_Dimmer_Pwr   at  009*Io_Size range 0..31;
         Side_Pnl_Dimmer_Pwr         at  010*Io_Size range 0..31;
         Emergency_Dimmer_Pwr        at  011*Io_Size range 0..31;
         Emergency_5v_Ltg_Relay      at  012*Io_Size range 0..31;
         Fwd_Panel_Ltg_Relay_Cont    at  013*Io_Size range 0..31;
         Flood_Lts_Dimmer_Pwr        at  014*Io_Size range 0..31;
         Cockpit_Utility_Lt          at  015*Io_Size range 0..31;
         Battery_Bus_Dimmer_Pwr      at  016*Io_Size range 0..31;
         -- analog input
         Instrument_Pnl_Ltg_Cont     at  017*Io_Size range 0..31;
         Side_Pnl_Ltg_Cont           at  018*Io_Size range 0..31;
         -- analog output
         Instrument_Pnl_Dimmer_Cont  at  019*Io_Size range 0..31;
         Side_Pnl_Dimmer_Cont        at  020*Io_Size range 0..31;
         Emergency_Dimmer_Cont       at  021*Io_Size range 0..31;
         Battery_Bus_Dimmer_Control  at  022*Io_Size range 0..31;

      end record;

   This_Io_Interface : Io_Interface_Instance;

   type Ios_Interface_Instance is
      record
         null;
      end record;
   This_Ios_Interface : Ios_Interface_Instance;

end Jpats_Lights.Container;
