-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Position_Indicator_G is

   procedure Turn_On
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Is_On := True;
   exception
      when others =>
         Log.Report(Package_Name & ".Turn_On()");
         raise;
   end Turn_On;

   procedure Turn_Off
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Is_On := False;
   exception
      when others =>
         Log.Report(Package_Name & ".Turn_Off()");
         raise;
   end Turn_Off;

   function Is_On
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.Is_On;
   exception
      when others =>
         Log.Report(Package_Name & ".Is_On()");
         raise;
   end Is_On;

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Is_On := False;
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;

   procedure Update
     (An_Instance : in out Instance;
      Illuminate  : in     Boolean)
   is
   begin
      if Illuminate and not Is_On (An_Instance) then
         Turn_On (An_Instance);
      elsif not Illuminate and Is_On (An_Instance) then
         Turn_Off (An_Instance);
      end if;
   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;

end Position_Indicator_G;
