-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

generic

   type Position_Indicator_Name_Type is (<>);
   type Position_Indicator_Type is private;
   type Array_Of_Position_Indicator_Type is array (Position_Indicator_Name_Type) of Position_Indicator_Type;
   type Position_Indicator_Array_Of_Boolean is array (Position_Indicator_Name_Type) of Boolean;

   with function A_Indicator_Is_On (A_Indicator : in Position_Indicator_Type) return Boolean;
   with procedure Initialize_A_Indicator (A_Indicator : in out Position_Indicator_Type);
   with procedure Update_A_Indicator (A_Indicator : in out Position_Indicator_Type;
                                      Illuminate  : in     Boolean);
   Package_Name : in String;

package Position_Indicator_Collection_G is

   type Instance is private;

   procedure Update
     (An_Instance : in out Instance;
      Request     : in     Position_Indicator_Array_Of_Boolean);

   procedure Initialize
     (An_Instance : in out Instance);

   function Is_On
     (An_Instance : in Instance;
      Name        : in Position_Indicator_Name_Type)
      return Boolean;

private

   type Instance is
      record
         Position_Indicators : Array_Of_Position_Indicator_Type;
      end record;

end Position_Indicator_Collection_G;
