-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Position_Indicator_Collection_G is

   procedure Update
     (An_Instance : in out Instance;
      Request     : in     Position_Indicator_Array_Of_Boolean)
   is
   begin
      for Name in Position_Indicator_Name_Type
      loop
         Update_A_Indicator (An_Instance.Position_Indicators (Name), Request (Name));
      end loop;
   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      for Name in Position_Indicator_Name_Type
      loop
         Initialize_A_Indicator (An_Instance.Position_Indicators (Name));
      end loop;
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;

   function Is_On
     (An_Instance : in Instance;
      Name        : in Position_Indicator_Name_Type)
     return Boolean
   is
   begin
      return A_Indicator_Is_On (An_Instance.Position_Indicators (Name));
   exception
      when others =>
         Log.Report(Package_Name & ".Is_on()");
         raise;
   end Is_on;

end Position_Indicator_Collection_G;
