-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


package Jpats_Landing_Gear_Types is

   subtype Gear_Position_Type is Float range 0.0..1.0;
   subtype Gear_Door_Position_Type is Float range 0.0..1.0;
   subtype Gear_Aero_Factor_Type is Float;

   Yaw_Moment_Coefficient_To_Gear_Extension : constant Float := 0.002;

   type Relay_Name_Type is (Left_Landing_Gear_A1_WOW_Relay,
                            Right_Landing_Gear_A1_WOW_Relay,
                            Left_Landing_Gear_A2_WOW_Relay,
                            Right_Landing_Gear_A2_WOW_Relay,
                            Q_Switch_Control_Relay,
                            Landing_Gear_Down_And_Locked);

   type Switch_Name_Type is (Left_Door_Lock_Switch,
                             Left_Main_Gear_Switch,
                             Left_Gear_Up_And_Locked_Switch,
                             Left_Gear_Down_And_Locked_Switch,
                             Left_Gear_WOW_Switch,
                             Nose_Gear_Down_And_Locked_Switch,
                             Nose_Gear_Up_And_Locked_Switch,
                             Right_Door_Lock_Switch,
                             Right_Main_Gear_Switch,
                             Right_Gear_Up_And_Locked_Switch,
                             Right_Gear_Down_And_Locked_Switch,
                             Right_Gear_WOW_Switch);

end Jpats_Landing_Gear_Types;
