-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Landing_Gear_Types;
with Length_Types;
with Electrical_Units_Types;
with Force_Types;

package Jpats_Landing_Gear is
-- relays
   function Is_Open
     (Name : in Jpats_Landing_Gear_Types.Relay_Name_Type)
      return Boolean;
   function Is_Closed
     (Name : in Jpats_Landing_Gear_Types.Relay_Name_Type)
      return Boolean;
--switches
   function Is_Open
     (Name : in Jpats_Landing_Gear_Types.Switch_Name_Type)
      return Boolean;
   function Is_Closed
     (Name : in Jpats_Landing_Gear_Types.Switch_Name_Type)
      return Boolean;


   function Left_Landing_Gear_Position return Jpats_Landing_Gear_Types.Gear_Position_Type;
   function Right_Landing_Gear_Position return Jpats_Landing_Gear_Types.Gear_Position_Type;
   function Nose_Landing_Gear_Position return Jpats_Landing_Gear_Types.Gear_Position_Type;
   function Mean_Gear_Position return Jpats_Landing_Gear_Types.Gear_Position_Type;
   function All_Gear_Up return Boolean;

   function Gear_Aero_Factor return Jpats_Landing_Gear_Types.Gear_Aero_Factor_Type;

   function Gear_Hyd_Load return Length_Types.Gpm;

   function Gear_Doors_Hyd_Load return Length_Types.Gpm;

   function Nws_Enabled return Boolean;

   function Left_Landing_Gear_A1_WOW_Relay_Load   return Electrical_Units_Types.Amps;
   function Right_Landing_Gear_A1_WOW_Relay_Load  return Electrical_Units_Types.Amps;
   function Left_Landing_Gear_A2_WOW_Relay_Load   return Electrical_Units_Types.Amps;
   function Right_Landing_Gear_A2_WOW_Relay_Load  return Electrical_Units_Types.Amps;
   function Q_Switch_Control_Relay_Load           return Electrical_Units_Types.Amps;
   function Landing_Gear_Down_And_Locked_Rly_Load return Electrical_Units_Types.Amps;
   function Landing_Gear_Control_Assembly_Load    return Electrical_Units_Types.Amps;

   -- hardware

   function Emergency_Gear_Handle_Extended return Boolean;

   function Gear_Handle_Is_Up return Boolean;


   -- brakes
   function Left_Brake_Psi return Force_Types.Psi;
   function Right_Brake_Psi return Force_Types.Psi;
   function Left_Brake_Back_Px return Force_Types.Psi;
   function Right_Brake_Back_Px return Force_Types.Psi;
   function Left_Brake_K_Pump return Float;
   function Right_Brake_K_Pump return Float;

   -- sound
   function Left_Main_Gear_Door_Position return Float;
   function Right_Main_Gear_Door_Position return Float;
   function Nose_Gear_Door_Position return Float;
   function Left_Main_Gear_Position return Float;
   function Right_Main_Gear_Position return Float;
   function Nose_Gear_Position return Float;

   -- cnia
   function Parking_Brake_Set return Boolean;

   -- wheel chocks
   function Wheel_Chocks return Boolean;

   -- ios pilot gear
   function Ios_Pilot_Gear return Integer;

   -- Malfunctions
   function Right_Tire_Blown return Boolean;
   function Left_Brake_Fail return Boolean;
   function Right_Tire_Blown_Left_Brake_Fail return Boolean;
   function Left_Tire_Blown_Right_Brake_Fail return Boolean;

end Jpats_Landing_Gear;

