-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Landing_Gear.Container;
with Jpats_Landing_Gear.Controller;
with Log;
with Jpats_Auto_Test;

package body Jpats_Landing_Gear is

-- relays
   function Is_Open
     (Name : in Jpats_Landing_Gear_Types.Relay_Name_Type)
     return Boolean
   is
      package Ctnr renames Container;
      The_Relays : Ctnr.Relays.Instance renames Ctnr.This_Subsystem.The_Gear_Position_Relays;
   begin
      return Ctnr.Relays.Is_Open (The_Relays, Name);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Is_Open()");
         raise;
   end Is_Open;

   function Is_Closed
     (Name : in Jpats_Landing_Gear_Types.Relay_Name_Type)
     return Boolean
   is
      package Ctnr renames Container;
      The_Relays : Ctnr.Relays.Instance renames Ctnr.This_Subsystem.The_Gear_Position_Relays;
   begin
      return Ctnr.Relays.Is_Closed (The_Relays, Name);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Is_Closed()");
         raise;
   end Is_Closed;

--switches
   function Is_Open
     (Name : in Jpats_Landing_Gear_Types.Switch_Name_Type)
     return Boolean
   is
      package Ctnr renames Container;
      The_Switches : Ctnr.Position_Switches.Instance renames Ctnr.This_Subsystem.The_Gear_Position_Switches;
   begin
      return Ctnr.Position_Switches.Is_Open (The_Switches, Name);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Is_Open()");
         raise;
   end Is_Open;

   function Is_Closed
     (Name : in Jpats_Landing_Gear_Types.Switch_Name_Type)
     return Boolean
   is
      package Ctnr renames Container;
      The_Switches : Ctnr.Position_Switches.Instance renames Ctnr.This_Subsystem.The_Gear_Position_Switches;
   begin
      return Ctnr.Position_Switches.Is_Closed (The_Switches, Name);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Is_Closed()");
         raise;
   end Is_Closed;

   function Left_Landing_Gear_Position return Jpats_Landing_Gear_Types.Gear_Position_Type
   is
      package Ctnr renames Container;
      The_Left_Gear : Ctnr.Main_Gear.Instance renames Ctnr.This_Subsystem.The_Left_Main_Landing_Gear;
   begin
      return Ctnr.Main_Gear.Position (The_Left_Gear);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Left_Landing_Gear_Position()");
         raise;
   end Left_Landing_Gear_Position;

   function Right_Landing_Gear_Position return Jpats_Landing_Gear_Types.Gear_Position_Type
   is
      package Ctnr renames Container;
      The_Right_Gear : Ctnr.Main_Gear.Instance renames Ctnr.This_Subsystem.The_Right_Main_Landing_Gear;
   begin
      return Ctnr.Main_Gear.Position (The_Right_Gear);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Right_Landing_Gear_Position()");
         raise;
   end Right_Landing_Gear_Position;

   function Nose_Landing_Gear_Position return Jpats_Landing_Gear_Types.Gear_Position_Type
   is
      package Ctnr renames Container;
      The_Nose_Gear : Ctnr.Nose_Gear.Instance renames Ctnr.This_Subsystem.The_Nose_Landing_Gear;
   begin
      return Ctnr.Nose_Gear.Position (The_Nose_Gear);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Nose_Landing_Gear_Position()");
         raise;
   end Nose_Landing_Gear_Position;

   function Mean_Gear_Position return Jpats_Landing_Gear_Types.Gear_Position_Type
   is
   begin
      return (Left_Landing_Gear_Position+Right_Landing_Gear_Position+Nose_Landing_Gear_Position)/3.0;
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Mean_Gear_Position()");
         raise;
   end Mean_Gear_Position;

   function All_Gear_Up return Boolean
   is
   begin
      return Mean_Gear_Position = 0.0;
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.All_Gear_Up()");
         raise;
   end All_Gear_Up;

   function Gear_Aero_Factor return Jpats_Landing_Gear_Types.Gear_Aero_Factor_Type
   is
      package Ctnr   renames Container;
      package Gear_T renames Jpats_Landing_Gear_Types;
      Left_Gear_Door  : constant Float := Ctnr.Gear_Door.Position (Ctnr.This_Subsystem.The_Left_Main_Gear_Door);
      Right_Gear_Door : constant Float := Ctnr.Gear_Door.Position (Ctnr.This_Subsystem.The_Right_Main_Gear_Door);
   begin
      return Gear_T.Gear_Aero_Factor_Type(Float'Min(1.0,4.0*Mean_Gear_Position) + 0.08 * (Left_Gear_Door+Right_Gear_Door));
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Gear_Aero_Factor()");
         raise;
   end Gear_Aero_Factor;

   function Gear_Hyd_Load return Length_Types.Gpm
   is
   begin
      return (Container.Main_Gear.Hydraulic_Load (Container.This_Subsystem.The_Left_Main_Landing_Gear) +
              Container.Main_Gear.Hydraulic_Load (Container.This_Subsystem.The_Right_Main_Landing_Gear) +
              Container.Nose_Gear.Hydraulic_Load (Container.This_Subsystem.The_Nose_Landing_Gear));
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Gear_Hyd_Load()");
         raise;
   end Gear_Hyd_Load;

   function Gear_Doors_Hyd_Load return Length_Types.Gpm
   is
   begin
      return (Container.Gear_Door.Hydraulic_Load(Container.This_Subsystem.The_Left_Main_Gear_Door) +
              Container.Gear_Door.Hydraulic_Load(Container.This_Subsystem.The_Right_Main_Gear_Door));
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Gear_Doors_Hyd_Load()");
         raise;
   end Gear_Doors_Hyd_Load;

   function Nws_Enabled
     return Boolean
   is
   begin
      return Controller.Nws_Enable;
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Nws_Enabled()");
         raise;
   end Nws_Enabled;


   function Left_Landing_Gear_A1_WOW_Relay_Load return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
      package Relays renames Ctnr.Relays;
      package Gear_T renames Jpats_Landing_Gear_Types;
      The_Relays : Relays.Instance renames Ctnr.This_Subsystem.The_Gear_Position_Relays;
   begin
      return Relays.Load (The_Relays, Gear_T.Left_Landing_Gear_A1_WOW_Relay);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Left_Landing_Gear_A1_WOW_Relay_Load()");
         raise;
   end Left_Landing_Gear_A1_WOW_Relay_Load;

   function Right_Landing_Gear_A1_WOW_Relay_Load return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
      package Relays renames Ctnr.Relays;
      package Gear_T renames Jpats_Landing_Gear_Types;
      The_Relays : Relays.Instance renames Ctnr.This_Subsystem.The_Gear_Position_Relays;
   begin
      return Relays.Load (The_Relays, Gear_T.Right_Landing_Gear_A1_WOW_Relay);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Right_Landing_Gear_A1_WOW_Relay_Load()");
         raise;
   end Right_Landing_Gear_A1_WOW_Relay_Load;

   function Left_Landing_Gear_A2_WOW_Relay_Load return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
      package Relays renames Ctnr.Relays;
      package Gear_T renames Jpats_Landing_Gear_Types;
      The_Relays : Relays.Instance renames Ctnr.This_Subsystem.The_Gear_Position_Relays;
   begin
      return Relays.Load (The_Relays, Gear_T.Left_Landing_Gear_A2_WOW_Relay);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Left_Landing_Gear_A2_WOW_Relay_Load()");
         raise;
   end Left_Landing_Gear_A2_WOW_Relay_Load;

   function Right_Landing_Gear_A2_WOW_Relay_Load return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
      package Relays renames Ctnr.Relays;
      package Gear_T renames Jpats_Landing_Gear_Types;
      The_Relays : Relays.Instance renames Ctnr.This_Subsystem.The_Gear_Position_Relays;
   begin
      return Relays.Load (The_Relays, Gear_T.Right_Landing_Gear_A2_WOW_Relay);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Right_Landing_Gear_A2_WOW_Relay_Load()");
         raise;
   end Right_Landing_Gear_A2_WOW_Relay_Load;

   function Q_Switch_Control_Relay_Load return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
      package Relays renames Ctnr.Relays;
      package Gear_T renames Jpats_Landing_Gear_Types;
      The_Relays : Relays.Instance renames Ctnr.This_Subsystem.The_Gear_Position_Relays;
   begin
      return Relays.Load (The_Relays, Gear_T.Q_Switch_Control_Relay);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Q_Switch_Control_Relay_Load()");
         raise;
   end Q_Switch_Control_Relay_Load;

   function Landing_Gear_Down_And_Locked_Rly_Load return Electrical_Units_Types.Amps
   is
      package Ctnr renames Container;
      package Relays renames Ctnr.Relays;
      package Gear_T renames Jpats_Landing_Gear_Types;
      The_Relays : Relays.Instance renames Ctnr.This_Subsystem.The_Gear_Position_Relays;
   begin
      return Relays.Load (The_Relays, Gear_T.Landing_Gear_Down_And_Locked);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Landing_Gear_Down_And_Locked_Rly_Load()");
         raise;
   end Landing_Gear_Down_And_Locked_Rly_Load;

   function Landing_Gear_Control_Assembly_Load return Electrical_Units_Types.Amps
   is
   begin
      return 0.0;
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Landing_Gear_Control_Assembly_Load()");
         raise;
   end Landing_Gear_Control_Assembly_Load;

   -- hardware

   function Emergency_Gear_Handle_Extended return Boolean
   is
      package Ctnr renames Container;
      Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;
   begin
      return Io.Emer_Landing_Gear_Sw or Jpats_Auto_Test.Emer_Gear;
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Emergency_Gear_Handle_Extended()");
         raise;
   end Emergency_Gear_Handle_Extended;


   function Gear_Handle_Is_Up return Boolean
   is
      package Ctnr renames Container;
      Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;
   begin
      return not Io.Landing_Gear_Down_Sw;
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Gear_Handle_Is_Up()");
         raise;
   end Gear_Handle_Is_Up;


   -- brakes

   function Left_Brake_Psi
     return Force_Types.Psi
   is
      package Ctnr renames Container;
   begin
      return Ctnr.left_Brake.Pressure(Ctnr.This_Subsystem.The_Left_Brake);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Left_Brake_Psi()");
         raise;
   end Left_Brake_Psi;

   function Right_Brake_Psi
     return Force_Types.Psi
   is
      package Ctnr renames Container;
   begin
      return Ctnr.right_Brake.Pressure(Ctnr.This_Subsystem.The_Right_Brake);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Right_Brake_Psi()");
         raise;
   end Right_Brake_Psi;

   function Left_Brake_Back_Px
     return Force_Types.Psi
   is
      package Ctnr renames Container;
   begin
      return Ctnr.left_Brake.Back_Pressure(Ctnr.This_Subsystem.The_Left_Brake);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Left_Brake_Back_Px()");
         raise;
   end Left_Brake_Back_Px;

   function Right_Brake_Back_Px
     return Force_Types.Psi
   is
      package Ctnr renames Container;
   begin
      return Ctnr.right_Brake.Back_Pressure(Ctnr.This_Subsystem.The_Right_Brake);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Right_Brake_Back_Px()");
         raise;
   end Right_Brake_Back_Px;

   function Left_Brake_K_Pump
     return Float
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Left_Brake.K_Pump(Ctnr.This_Subsystem.The_Left_Brake);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Left_Brake_K_Pump()");
         raise;
   end Left_Brake_K_Pump;


   function Right_Brake_K_Pump
     return Float
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Right_Brake.K_Pump(Ctnr.This_Subsystem.The_Right_Brake);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Right_Brake_K_Pump()");
         raise;
   end Right_Brake_K_Pump;



   -- sound

   package Ctnr renames Container;
   Sound : Ctnr.Sound_Interface_Instance renames Ctnr.This_Sound_Interface;

   function Left_Main_Gear_Door_Position
     return Float
   is
   begin
      return Sound.Left_Main_Gear_Door_Position;
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Left_Main_Gear_Door_Position()");
         raise;
   end Left_Main_Gear_Door_Position;

   function Right_Main_Gear_Door_Position
     return Float
   is
   begin
      return Sound.Right_Main_Gear_Door_Position;
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Right_Main_Gear_Door_Position()");
         raise;
   end Right_Main_Gear_Door_Position;

   function Nose_Gear_Door_Position
     return Float
   is
   begin
      return Sound.Nose_Gear_Door_Position;
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Nose_Gear_Door_Position()");
         raise;
   end Nose_Gear_Door_Position;

   function Left_Main_Gear_Position
     return Float
   is
   begin
      return Sound.Left_Main_Gear_Position;
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Left_Main_Gear_Position()");
         raise;
   end Left_Main_Gear_Position;

   function Right_Main_Gear_Position
     return Float
   is
   begin
      return Sound.Right_Main_Gear_Position;
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Right_Main_Gear_Position()");
         raise;
   end Right_Main_Gear_Position;

   function Nose_Gear_Position
     return Float
   is
   begin
      return Sound.Nose_Gear_Position;
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Nose_Gear_Position()");
         raise;
   end Nose_Gear_Position;


   function Parking_Brake_Set
     return Boolean
   is
      Io : Container.Io_Interface_Instance renames Container.This_Io_Interface;
   begin
      return Io.Parking_Brake;
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Parking_Brake_Set()");
         raise;
   end Parking_Brake_Set;

   function Wheel_Chocks
     return Boolean
   is
      Ios : Container.Ios_Interface_Instance renames Container.This_Ios_Interface;
   begin
      return Container.This_Subsystem.Wheel_Chock_On;
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Wheel_Chocks()");
         raise;
   end Wheel_Chocks;


   -- ios pilot gear
   function Ios_Pilot_Gear
     return Integer
   is
      Ios : Container.Ios_Interface_Instance renames Container.This_Ios_Interface;
   begin
      return Ios.Ios_Pilot_Gear;
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Ios_Pilot_Gear()");
         raise;
   end Ios_Pilot_Gear;

 -- Malfunctions
   function Right_Tire_Blown
     return Boolean
   is
      Ios : Container.Ios_Interface_Instance renames Container.This_Ios_Interface;
   begin
      return Ios.Right_Tire_Blown_Malf;
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Right_Tire_Blown()");
         raise;
   end Right_Tire_Blown;

   function Left_Brake_Fail
     return Boolean
   is
      Ios : Container.Ios_Interface_Instance renames Container.This_Ios_Interface;
   begin
      return Ios.Left_Brake_Pressure_Loss_Malf;
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Left_Brake_Fail()");
         raise;
   end Left_Brake_Fail;

   function Right_Tire_Blown_Left_Brake_Fail
     return Boolean
   is
      Ios : Container.Ios_Interface_Instance renames Container.This_Ios_Interface;
   begin
      return Ios.Right_Tire_Left_Brake_Malf;
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Right_Tire_Blown_Left_Brake_Fail()");
         raise;
   end Right_Tire_Blown_Left_Brake_Fail;

   function Left_Tire_Blown_Right_Brake_Fail
     return Boolean
   is
      Ios : Container.Ios_Interface_Instance renames Container.This_Ios_Interface;
   begin
      return Ios.Left_Tire_Right_Brake_Malf;
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Left_Tire_Blown_Right_Brake_Fail()");
         raise;
   end Left_Tire_Blown_Right_Brake_Fail;

end Jpats_Landing_Gear;