-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Landing_Gear.Container;
with Jpats_Ios_Interface;
with Log;
with Jpats_Simulated_Aircraft;
with Length_Types;

package body Jpats_Landing_Gear.Ios_Interface is

   package Ctnr renames Container;
   Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;
   Io  : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;
   package JII renames Jpats_Ios_Interface;

   procedure Nws_Enable_Command
     (PData : in JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Nws_Enable := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Ios_Interface.Nws_Enable_Command()");
         raise;
   end Nws_Enable_Command;

   procedure Main_Gear_Stuck_Up_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Main_Gear_Stuck_Up_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Ios_Interface.Main_Gear_Stuck_Up_Malf_Command()");
         raise;
   end Main_Gear_Stuck_Up_Malf_Command;

   procedure Nose_Gear_Stuck_Up_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Nose_Gear_Stuck_Up_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Ios_Interface.Nose_Gear_Stuck_Up_Malf_Command()");
         raise;
   end Nose_Gear_Stuck_Up_Malf_Command;

   procedure Main_Gear_Stuck_Down_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Main_Gear_Stuck_Down_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Ios_Interface.Main_Gear_Stuck_Down_Malf_Command()");
         raise;
   end Main_Gear_Stuck_Down_Malf_Command;

   procedure Nose_Gear_Stuck_Down_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Nose_Gear_Stuck_Down_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Ios_Interface.Nose_Gear_Stuck_Down_Malf_Command()");
         raise;
   end Nose_Gear_Stuck_Down_Malf_Command;

   procedure Main_Gear_Door_Stuck_Open_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Main_Gear_Door_Stuck_Open_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Ios_Interface.Main_Gear_Door_Stuck_Open_Malf_Command()");
         raise;
   end Main_Gear_Door_Stuck_Open_Malf_Command;

   procedure Right_Brake_Pressure_Loss_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Right_Brake_Pressure_Loss_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Ios_Interface.Right_Brake_Pressure_Loss_Malf_Command()");
         raise;
   end Right_Brake_Pressure_Loss_Malf_Command;

   procedure Left_Brake_Pressure_Loss_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Left_Brake_Pressure_Loss_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Ios_Interface.Left_Brake_Pressure_Loss_Malf_Command()");
         raise;
   end Left_Brake_Pressure_Loss_Malf_Command;

   procedure Right_Tire_Blown_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Right_Tire_Blown_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Ios_Interface.Right_Tire_Blown_Malf_Command()");
         raise;
   end Right_Tire_Blown_Malf_Command;

   procedure Right_Tire_Left_Brake_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Right_Tire_Left_Brake_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Ios_Interface.Right_Tire_Left_Brake_Malf_Command()");
         raise;
   end Right_Tire_Left_Brake_Malf_Command;

   procedure Left_Tire_Right_Brake_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Left_Tire_Right_Brake_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Ios_Interface.Left_Tire_Right_Brake_Malf_Command()");
         raise;
   end left_Tire_Right_Brake_Malf_Command;

   procedure Total_Brake_Pressure_Loss_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Total_Brake_Pressure_Loss_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Ios_Interface.Total_Brake_Pressure_Loss_Malf_Command()");
         raise;
   end Total_Brake_Pressure_Loss_Malf_Command;

   procedure Loss_NWS_Indication_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Loss_NWS_Indication_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Ios_Interface.Loss_NWS_Indication_Malf_Command()");
         raise;
   end Loss_NWS_Indication_Malf_Command;

   procedure Main_Gear_Down_Indicator_Fail_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Main_Gear_Down_Indicator_Fail_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Ios_Interface.Main_Gear_Down_Indicator_Fail_Malf_Command()");
         raise;
   end Main_Gear_Down_Indicator_Fail_Malf_Command;

   procedure Main_Gear_Inboard_Door_Fail_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Main_Gear_Inboard_Door_Fail_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Ios_Interface.Main_Gear_Inboard_Door_Fail_Malf_Command()");
         raise;
   end Main_Gear_Inboard_Door_Fail_Malf_Command;

   procedure Gear_Sequencing_Fail_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Gear_Sequencing_Fail_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Ios_Interface.Gear_Sequencing_Fail_Malf_Command()");
         raise;
   end Gear_Sequencing_Fail_Malf_Command;

   procedure Gear_Control_Unit_Malf_One_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Gear_Control_Unit_Malf_One := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Ios_Interface.Gear_Control_Unit_Malf_One_Command()");
         raise;
   end Gear_Control_Unit_Malf_One_Command;

   procedure Gear_Control_Unit_Malf_Two_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Gear_Control_Unit_Malf_Two := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Ios_Interface.Gear_Control_Unit_Malf_Two_Command()");
         raise;
   end Gear_Control_Unit_Malf_Two_Command;

   procedure Wheel_Chocks_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
--       package Sim_Acft renames Jpats_Simulated_Aircraft;
--       package Alt renames Length_Types;
--       package Vel renames Length_Types;
--       Altitude     : constant Alt.Feet         := Sim_Acft.Get_Aircraft_Height_Above_Local_Terrain;
--       Ground_Speed : constant Vel.Feet_per_Sec := Sim_Acft.Get_Ground_Speed;
--       Ground_Service_Available : constant Boolean := Altitude < 10.0 and Ground_Speed < 5.0;
   begin
--       if Ground_Service_Available then
--          Ios.Wheel_Chocks := JII.Convert_To_Bool(PData);
--       else
--          Ios.Wheel_Chocks := False;
      --       end if;
      -- all this logic is moved to the controller
      --and this var is seen as a request only
      Ios.Wheel_Chocks := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("");
         raise;
   end Wheel_Chocks_Command;

   procedure Ios_Pilot_Gear_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Ios_Pilot_Gear := JII.Convert_To_Integer(PData);
   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Ios_Interface.Ios_Pilot_Gear_Command()");
         raise;
   end Ios_Pilot_Gear_Command;

   procedure Register_Ios_Variables
   is
   begin

      JPATS_IOS_Interface.Register
        (Name        => "Wheel_Chocks",
         Variable    => Ios.Wheel_Chocks'Address,
         Set_Routine => Wheel_Chocks_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Main_Gear_Stuck_Up_Malf",
         Variable    => Ios.Main_Gear_Stuck_Up_Malf'Address,
         Set_Routine => Main_Gear_Stuck_Up_Malf_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Nose_Gear_Stuck_Up_Malf",
         Variable    => Ios.Nose_Gear_Stuck_Up_Malf'Address,
         Set_Routine => Nose_Gear_Stuck_Up_Malf_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Main_Gear_Stuck_Down_Malf",
         Variable    => Ios.Main_Gear_Stuck_Down_Malf'Address,
         Set_Routine => Main_Gear_Stuck_Down_Malf_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Nose_Gear_Stuck_Down_Malf",
         Variable    => Ios.Nose_Gear_Stuck_Down_Malf'Address,
         Set_Routine => Nose_Gear_Stuck_Down_Malf_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Main_Gear_Door_Stuck_Open_Malf",
         Variable    => Ios.Main_Gear_Door_Stuck_Open_Malf'Address,
         Set_Routine => Main_Gear_Door_Stuck_Open_Malf_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Right_Brake_Pressure_Loss_Malf",
         Variable    => Ios.Right_Brake_Pressure_Loss_Malf'Address,
         Set_Routine => Right_Brake_Pressure_Loss_Malf_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Left_Brake_Pressure_Loss_Malf",
         Variable    => Ios.Left_Brake_Pressure_Loss_Malf'Address,
         Set_Routine => Left_Brake_Pressure_Loss_Malf_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Right_Tire_Blown_Malf",
         Variable    => Ios.Right_Tire_Blown_Malf'Address,
         Set_Routine => Right_Tire_Blown_Malf_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Right_Tire_Left_Brake_Malf",
         Variable    => Ios.Right_Tire_Left_Brake_Malf'Address,
         Set_Routine => Right_Tire_Left_Brake_Malf_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Left_Tire_Right_Brake_Malf",
         Variable    => Ios.Left_Tire_Right_Brake_Malf'Address,
         Set_Routine => Left_Tire_Right_Brake_Malf_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Total_Brake_Pressure_Loss_Malf",
         Variable    => Ios.Total_Brake_Pressure_Loss_Malf'Address,
         Set_Routine => Total_Brake_Pressure_Loss_Malf_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Loss_NWS_Indication_Malf",
         Variable    => Ios.Loss_NWS_Indication_Malf'Address,
         Set_Routine => Loss_NWS_Indication_Malf_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Main_Gear_Down_Indicator_Fail_Malf",
         Variable    => Ios.Main_Gear_Down_Indicator_Fail_Malf'Address,
         Set_Routine => Main_Gear_Down_Indicator_Fail_Malf_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Main_Gear_Inboard_Door_Fail_Malf",
         Variable    => Ios.Main_Gear_Inboard_Door_Fail_Malf'Address,
         Set_Routine => Main_Gear_Inboard_Door_Fail_Malf_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Gear_Sequencing_Fail_Malf",
         Variable    => Ios.Gear_Sequencing_Fail_Malf'Address,
         Set_Routine => Gear_Sequencing_Fail_Malf_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Gear_Control_Unit_Malf_One",
         Variable    => Ios.Gear_Control_Unit_Malf_One'Address,
         Set_Routine => Gear_Control_Unit_Malf_One_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Gear_Control_Unit_Malf_Two",
         Variable    => Ios.Gear_Control_Unit_Malf_Two'Address,
         Set_Routine => Gear_Control_Unit_Malf_Two_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Nws_Enable",
         Variable    => Ios.Nws_Enable'Address,
         Set_Routine => Nws_Enable_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Ios_Pilot_Gear",
         Variable    => Ios.Ios_Pilot_Gear'Address,
         Set_Routine => Ios_Pilot_Gear_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Lh_Gear_Green",
         Variable    => Io.Lh_Gear_Green'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Lh_Gear_Red",
         Variable    => Io.Lh_Gear_Red'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Nose_Gear_Green",
         Variable    => Io.Nose_Gear_Green'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Nose_Gear_Red",
         Variable    => Io.Nose_Gear_Red'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Rh_Gear_Green",
         Variable    => Io.Rh_Gear_Green'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Rh_Gear_Red",
         Variable    => Io.Rh_Gear_Red'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Emer_Landing_Gear_Sw",
         Variable    => Io.Emer_Landing_Gear_Sw'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Landing_Gear_Down_Sw",
         Variable    => Io.Landing_Gear_Down_Sw'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Landing_Gear_Handle_Lt",
         Variable    => Io.Landing_Gear_Handle_Lt'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Parking_Brake",
         Variable    => Io.Parking_Brake'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Nws_Engaged",
         Variable    => Ios.Nws_Engaged'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Gear_Position",
         Variable    => Ios.Gear_Position'Address
         );

   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Ios_Interface.Register_Ios_Variables()");
         raise;
   end Register_Ios_Variables;


end Jpats_Landing_Gear.Ios_Interface;
