-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Landing_Gear.Container;
with Jpats_Io;
with Jpats_Io_Types;
with Io_Types;
with Log;

package body Jpats_Landing_Gear.Io_Interface is

   package JIOT renames Jpats_Io_Types;
   Io : Container.Io_Interface_Instance renames Container.This_Io_Interface;

   procedure Register_Io_Variables
   is
   begin


      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "DOWNLOCK_OVERRIDE_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Downlock_Override_Sw'Address,
         A_Size          => Io.Downlock_Override_Sw'Size);


      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "LANDING_GEAR_DOWN_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Landing_Gear_Down_Sw'Address,
         A_Size          => Io.Landing_Gear_Down_Sw'Size);


      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "EMER_LANDING_GEAR_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Emer_Landing_Gear_Sw'Address,
         A_Size          => Io.Emer_Landing_Gear_Sw'Size);


--       Jpats_Io.Map_To_Icd_mnemonic
--         (An_Interface    => JIOT.Flight_Deck,
--          An_Icd_Mnemonic => "LDG_GR_TEST_SW",
--          A_Direction     => IO_Types.Input,
--          An_Address      => Io.Ldg_Gr_Test_Sw'Address,
--          A_Size          => Io.Ldg_Gr_Test_Sw'Size);


      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "parking_brake_sw",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Parking_Brake'Address,
         A_Size          => Io.Parking_Brake'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "NOSE_WHEEL_STEER",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Nose_Wheel_Steer'Address,
         A_Size          => Io.Nose_Wheel_Steer'Size);


      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "LH_GEAR_GREEN",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Lh_Gear_Green'Address,
         A_Size          => Io.Lh_Gear_Green'Size);


      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "LH_GEAR_RED",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Lh_Gear_Red'Address,
         A_Size          => Io.Lh_Gear_Red'Size);


      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "NOSE_GEAR_GREEN",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Nose_Gear_Green'Address,
         A_Size          => Io.Nose_Gear_Green'Size);


      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "NOSE_GEAR_RED",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Nose_Gear_Red'Address,
         A_Size          => Io.Nose_Gear_Red'Size);


      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "RH_GEAR_GREEN",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Rh_Gear_Green'Address,
         A_Size          => Io.Rh_Gear_Green'Size);


      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "RH_GEAR_RED",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Rh_Gear_Red'Address,
         A_Size          => Io.Rh_Gear_Red'Size);


      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "LANDING_GEAR_LOCK",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Landing_Gear_Lock'Address,
         A_Size          => Io.Landing_Gear_Lock'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "LANDING_GEAR_HANDLE_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Landing_Gear_Handle_Lt'Address,
         A_Size          => Io.Landing_Gear_Handle_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "NOSE_WHEEL_STEERING_ANN",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Nose_Wheel_Steering_Ann'Address,
         A_Size          => Io.Nose_Wheel_Steering_Ann'Size);


   exception
      when others =>
         Log.Report("Jpats_Landing_Gear.Io_Interface.Register_Io_Variables()");
         raise;
   end Register_Io_Variables;

end Jpats_Landing_Gear.Io_Interface;

