-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
--  LANDING GEAR SYSTEM
--  The landing gear system is a hydraulically actuated tricycle
--  type with inward retracting main gear and an aft retracting
--  nose gear. The system includes selectable hydraulically
--  operated nose wheel steering, toe activated hydraulic brakes
--  which are independent of the aircraft hydraulic system, a
--  parking brake, and an electrical control and indicating
--  panel. The emergency hydraulic accumulator provides a
--  means of emergency extension. A normal gear extension/
--  retraction sequence takes approximately six seconds. Emergency
--  extension may take longer than normal extension as
--  emergency hydraulic pressure diminishes during emergency
--  operation.

--  EXTENSION/RETRACTION SYSTEM
--  The extension and retraction system is hydraulically actuated
--  and electrically sequenced to extend and retract the
--  landing gear during normal operation, and to extend the
--  landing gear, gear doors, and flaps for a one time emergency
--  operation. Four actuators, one on each gear and one for the
--  main gear doors, operate the system of struts and mechanical
--  linkages. Under normal operation, the aircraft hydraulic
--  system provides 3000 psi pressure to extend and retract the
--  gear and gear doors. During emergency operation, the emergency
--  accumulator provides hydraulic pressure to the four
--  actuators without reliance on electrical power or engine
--  driven hydraulic pressure.
--  Each landing gear leg is an oleo-pneumatic shock absorber
--  strut which includes a piston and wheel axle assembly, and
--  an upper cylinder. A torque link assembly allows the piston
--  to move up and down in the cylinder and prevents rotation
--  of the piston assembly. A two piece folding strut is connected
--  at one end to the gear housing and at the other end to
--  a bracket mounted on the main spar. The hydraulic actuator
--  is connected to the upper link of the folding strut.
--  Each main gear up-lock includes a latch mechanism which
--  is activated from the landing gear door actuator to engage a
--  latch on the bottom of each main gear. The main gear up-lock
--  engages during the closing of the main doors and disengages
--  during the opening of the doors. Internal locks in
--  the main gear actuators engage to lock the main gear down.
--  A spring-strut braces the nose gear folding strut in the over
--  center position to lock the nose gear down. The nose gear is
--  locked in the up position with an internal actuator lock.
--  Each main landing gear well is enclosed by two doors. The
--  inboard doors are hinged to the wing. An outboard door is
--  connected to each landing gear strut. Both inboard doors are
--  hydraulically actuated by one actuator through a torque tube
--  and bellcranks. The inboard doors are mechanically locked
--  in the closed position by a spring latch. The latch is closed
--  when the closing door contacts a latch pin and is opened by
--  a mechanically operated release rod during the initial movement
--  of the door opening mechanism. The nose gear wheel
--  well is enclosed by two doors which are hinged at the fuselage
--  and held in place by the retracted nose landing gear.

--  EMERGENCY EXTENSION
--  During emergency extension, fluid from the emergency
--  accumulator and emergency hydraulic lines opens the main
--  gear inner doors, and extends the nose and main landing
--  gear. As pressure in the accumulator diminishes, operation
--  of the gear may be slower than normal. Once the gear are
--  down and locked, the main gear inner doors will remain
--  open.
--  Normal cockpit indications when the emergency extension
--  system is used are three green gear lights which indicate the
--  gear is down and locked; a red light at each main gear which
--  indicates the inner doors are down; and a red light in the
--  handle, which also indicates the inner doors are down. The
--  landing gear cannot be retracted after being extended with
--  the emergency system until the aircraft is serviced by maintenance.

--  CONTROLS AND INDICATORS
--  Electrical landing gear controls and indicators are located
--  on a control unit (Figure 1-21) on the lower left side of the
--  instrument panel in each cockpit. The control unit includes a
--  lighted landing gear selector, landing gear position Indicator
--  lights, a WARNING SILENCE button, and a DOWNLOCK
--  OVERRIDE button (front cockpit only).
--  Landing gear controls in each cockpit are linked mechanically
--  so that movement of one control moves the other. A
--  soft detent is provided to prevent inadvertent control handle
--  movement. A separate emergency landing gear extension
--  handle, placarded EMER LDG GR, is located on the left
--  side of the front cockpit instrument panel above the normal
--  extension handle. Indicator lights, located on the control
--  unit, indicate the position of each landing gear and/or gear
--  door.
--  A red light in each gear handle illuminates to indicate the
--  gear doors are not closed. Power for the landing gear controls
--  is provided through a circuit breaker placarded LDG
--  GR CONT, located on the battery bus circuit breaker panel
--  in the front cockpit.
--  Each gear indicator light has a green and red lens. Green is
--  illuminated only when that gear is down and locked. Red is
--  illuminated whenever the gear or gear doors are in transit
--  (main gear only).
--  A normal indication sequence for a normal landing gear
--  extension cycle is:
--    * No lights - gear up, doors closed.
--    * Two reds (main) - gear up, doors opening.
--    * Three reds - gear extending.
--    * Three greens/two reds (main) - gear down, doors closing.
--    * Three greens - gear down, doors closed.
--  A normal indication sequence for a normal landing gear
--  retraction cycle is:
--    * Three greens - gear down, doors closed.
--    * Three greens/two reds (main) - gear down, doors
--  opening.
--    * Three reds - gear retracting.
--    * Two reds (main) - gear up, doors closing.
--    * No lights - gear up, doors closed.
--  The lights may be tested by pressing the system test switch,
--  placarded LAMP TEST, located on the left console.
--  The warning silence button may be used to cancel and reset
--  the landing gear position warning horn when the gear is up
--  and the power setting is low.
--  The downlock override button, located in the front cockpit
--  only, can be used to override the downlock solenoid which
--  prevents movement of the landing gear selector handle
--  when the weight-on-wheels switch is energized (e.g. aircraft
--  on ground, or single weight-on-wheels switch failure). This
--  allows the landing gear handle to be raised on the ground or
--  when airborne with a failure of either weight-on-wheels
--  switch.
--  NOTE
--  The landing gear will not retract if either
--  weight-on-wheels switch indicates weight on
--  wheels, even if the gear handle is raised.
--  Landing Gear Position Warning
--  An aural landing gear position warning is provided in each
--  cockpit and activates when any one of the following conditions
--  exists:
--    * Gear UP and engine power below 87% N 1 , with airspeed
--  below 120 KIAS and flaps at any position.
--    * Gear UP with flaps in the LDG position at any power
--  setting.
--    * Weight on wheels with the gear handle UP.
--  The warning signal is a 250 Hz tone, repeated 5 times per
--  second, which is provided by a tone generator and transmitted
--  through the audio system.
--  An aural warning silence switch is provided on each landing
--  gear indicator panel. The gear UP/power low warning can
--  be cancelled by pressing the silence switch. The gear UP/
--  flaps LDG and the gear UP/aircraft on the ground warnings
--  cannot be cancelled.
--  An airspeed sensor (Q switch) prevents gear warnings above
--  120 KIAS, with the gear and flaps UP, regardless of PCL
--  position.

--  BRAKE SYSTEM
--  The brake system is a non-boosted, mechanically actuated,
--  hydraulically operated system, independent of the aircraft
--  hydraulic system. The brake system is not affected by a failure
--  of the aircraft hydraulic system.
--  Two hydraulic master cylinders provide independent braking
--  from the left and right rudder pedals. The forward and
--  aft cockpits use the same master cylinders. Toe activated
--  120 KIAS, with the gear and flaps UP, regardless of PCL
--  position.

--  pedals mounted to the rudder pedal assemblies in each
--  cockpit operate the disk brake units on each main wheel.
--  The front and rear brake pedals are interconnected.
--  NOTE
--  The pilot applying the most pedal force
--  determines the amount of braking being
--  used.

--  PARKING BRAKE
--  The parking brake is activated by applying toe brakes while
--  simultaneously pulling and turning the parking brake lever
--  90 clockwise. The parking brake handle is located in the
--  front cockpit, on the lower right portion of the instrument
--  panel. Turning the handle 90 counterclockwise releases the
--  parking brake.

-- Data source: Raytheon Phase X Data Package
-- Data source: Flight Manual USAF/USN Series T-6A Aircraft, Air Force TO 1T-6A-1
--              Navy (NAVAIR) A1-T6AAA-NFM-100, CVV Draft December 1998.
-------------------------------------------------------------------------------
private package Jpats_Landing_Gear.Controller is

   procedure Initialize;
   procedure Update
     (Iconst : in Float);
   function Nws_Enable return Boolean;
   procedure Reset_Random_MLG_Generator;

end Jpats_Landing_Gear.Controller;
