-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Position_Indicator_G;
with Position_Indicator_Collection_G;
with Landing_Gear_G;
with Landing_Gear_Door_G;
with Coil_Relay_G;
with Coil_Relay_Collection_G;
with Gear_Switch_G;
with Gear_Switch_Collection_G;
with Selector_Valve_G;
with Brake_G;
with Jpats_Hydraulics_Types;
with Jpats_Landing_Gear_Types;
with Electrical_Units_Types;
with Ada.Numerics.Discrete_Random;

private package Jpats_Landing_Gear.Container is
-- position indicators
   package Gear_Position_Indicator is new Position_Indicator_G
     (Package_Name => "Jpats_Landing_Gear.Container.Gear_Position_Indicator");
   type Gear_Position_Indicator_Name_Type is (Left_Main_Gear_Down_And_Locked_Indicator,
                                              Right_Main_Gear_Down_And_Locked_Indicator,
                                              Nose_Gear_Down_And_Locked_Indicator,
                                              Left_Main_Gear_In_Transit_Indicator,
                                              Right_Main_Gear_In_Transit_Indicator,
                                              Nose_Gear_In_Transit_Indicator);
   type Array_Of_Position_Indicator_Type is array (Gear_Position_Indicator_Name_Type)
     of Gear_Position_Indicator.Instance;
   type Position_Indicator_Array_Of_Boolean is array (Gear_Position_Indicator_Name_Type)
     of Boolean;
   package Gear_Position_Indicators is new Position_Indicator_Collection_G
     (Position_Indicator_Name_Type        => Gear_Position_Indicator_Name_Type,
      Position_Indicator_Type             => Gear_Position_Indicator.Instance,
      Array_Of_Position_Indicator_Type    => Array_Of_Position_Indicator_Type,
      Position_Indicator_Array_Of_Boolean => Position_Indicator_Array_Of_Boolean,
      A_Indicator_Is_On                   => Gear_Position_Indicator.Is_On,
      Update_A_Indicator                  => Gear_Position_Indicator.Update,
      Initialize_A_Indicator              => Gear_Position_Indicator.Initialize,
      Package_Name                        => "Jpats_Landing_Gear.Container.Gear_Position_Indicators");

-- landing gear
   package Main_Gear is new Landing_Gear_G
     (Gear_Position_Type => Jpats_Landing_Gear_Types.Gear_Position_Type,
      Hyd_Fcn_Type       => Jpats_Hydraulics_Types.Normalized_Pressure_Type,
      Hyd_Load_Type      => Length_Types.Gpm,
      Gear_Down_Table    => "MGRDNRT",
      Gear_Up_Table      => "MGRUPRT",
      Package_Name       => "Jpats_Landing_Gear.Container.Main_Gear");


   package Nose_Gear is new Landing_Gear_G
     (Gear_Position_Type => Jpats_Landing_Gear_Types.Gear_Position_Type,
      Hyd_Fcn_Type       => Jpats_Hydraulics_Types.Normalized_Pressure_Type,
      Hyd_Load_Type      => Length_Types.Gpm,
      Gear_Down_Table    => "NGRDNRT",
      Gear_Up_Table      => "NGRUPRT",
      Package_Name       => "Jpats_Landing_Gear.Container.Nose_Gear");

-- landing gear door
   package Gear_Door is new Landing_Gear_Door_G
     (Position_Type => Jpats_Landing_Gear_Types.Gear_Door_Position_Type,
      Hyd_Load_Type => Length_Types.Gpm,
      Hyd_Fcn_Type  => Jpats_Hydraulics_Types.Normalized_Pressure_Type,
      Package_Name  => "Jpats_Landing_Gear.Container.Gear_Door");



-- gear position relays
   package Relay is new Coil_Relay_G
     (Ampere_Type  => Electrical_Units_Types.Amps,
      Closed_Load  => 0.05,
      Package_Name => "Jpats_Landing_Gear.Container.Relay");
   type Array_Of_Relay_Type is array (Jpats_Landing_Gear_Types.Relay_Name_Type) of Relay.Instance;
   type Relay_Array_Of_Boolean is array (Jpats_Landing_Gear_Types.Relay_Name_Type) of Boolean;
   package Relays is new Coil_Relay_Collection_G
     (Ampere_Type           => Electrical_Units_Types.Amps,
      Relay_Name_Type       => Jpats_Landing_Gear_Types.Relay_Name_Type,
      Relay_Type            => Relay.Instance,
      Array_Of_Relay_Type   => Array_Of_Relay_Type,
      Array_Of_Boolean_Type => Relay_Array_Of_Boolean,
      Open_A_Relay          => Relay.Open,
      Close_A_Relay         => Relay.Close,
      A_Relay_Is_Closed     => Relay.Is_Closed,
      A_Relay_Is_Open       => Relay.Is_Open,
      A_Relay_Load          => Relay.Load,
      Initialize_A_Relay    => Relay.Initialize,
      Update_A_Relay        => Relay.Update,
      Package_Name          => "Jpats_Landing_Gear.Container.Relays");

-- position switches
   package Gear_Switch is new Gear_Switch_G
     (Package_Name => "Jpats_Landing_Gear.Container.Gear_Switch");
   type Array_Of_Gear_Switch_Type is array (Jpats_Landing_Gear_Types.Switch_Name_Type) of Gear_Switch.Instance;
   type Gear_Switch_Array_Of_Boolean is array (Jpats_Landing_Gear_Types.Switch_Name_Type) of Boolean;
   package Position_Switches is new Gear_Switch_Collection_G
     (Gear_Switch_Name_Type        => Jpats_Landing_Gear_Types.Switch_Name_Type,
      Gear_Switch_Type             => Gear_Switch.Instance,
      Array_Of_Gear_Switch_Type    => Array_Of_Gear_Switch_Type,
      Gear_Switch_Array_Of_Boolean => Gear_Switch_Array_Of_Boolean,
      A_Switch_Is_Closed           => Gear_Switch.Is_Closed,
      A_Switch_Is_Open             => Gear_Switch.Is_Open,
      Update_A_Switch              => Gear_Switch.Update,
      Initialize_A_Switch          => Gear_Switch.Initialize,
      Package_Name                 => "Jpats_Landing_Gear.Container.Position_Switches");

-- selector valve
   package Selector_Valve is new Selector_Valve_G
     (Package_Name => "Jpats_Landing_Gear.Container.Selector_Valve");

-- brakes
--    package Brake is new Brake_G
--      (Pressure_Type => Force_Types.Psi,
--       Max_Px        => 750.0,
--       Package_Name  => "Jpats_Landing_Gear.Container.Brake");

   package Left_Brake is new Brake_G
     (Pressure_Type => Force_Types.Psi,
      Brake_Pressure_Table => "lbrkpx",
      Package_Name => "Jpats_Landing_Gear.Container.Left_Brake");

   package Right_Brake is new Brake_G
     (Pressure_Type => Force_Types.Psi,
      Brake_Pressure_Table => "rbrkpx",
      Package_Name => "Jpats_Landing_Gear.Container.Right_Brake");

   type MLG is (Left,Right);
   package Random_MLG is new Ada.Numerics.Discrete_Random (MLG);
--   use Random_MLG;

   type Instance is
      record
         The_Position_Indicators     : Gear_Position_Indicators.Instance;
         The_Gear_Handle_Indicator   : Gear_Position_Indicator.Instance;
         The_Left_Main_Landing_Gear  : Main_Gear.Instance;
         The_Right_Main_Landing_Gear : Main_Gear.Instance;
         The_Nose_Landing_Gear       : Nose_Gear.Instance;
         The_Left_Main_Gear_Door     : Gear_Door.Instance;
         The_Right_Main_Gear_Door    : Gear_Door.Instance;
         The_Gear_Position_Relays    : Relays.Instance;
         The_Gear_Position_Switches  : Position_Switches.Instance;
         The_Left_Brake              : Left_Brake.Instance;
         The_Right_Brake             : Right_Brake.Instance;
-- selector valve
         -- brake(s)

         LGC_Old_Gear_Commanded  : Jpats_Landing_Gear_Types.Gear_Position_Type;
         LGC_Nose_Wheel_Steering_Enable                    : Boolean := False;
         LGC_Nws_Switch_Engaged                            : Boolean := False;
         LGC_Nws_Switch_Closed                             : Boolean := False;
         LGC_Nose_Wheel_Steer_Last_Pass                    : Boolean := False;
         LGC_Main_Gear_Stuck_Up_Malf_Last_Pass             : Boolean := False;
         LGC_Main_Gear_Stuck_Down_Malf_Last_Pass           : Boolean := False;
         LGC_Main_Gear_Door_Stuck_Open_Malf_Last_Pass      : Boolean := False;
         LGC_Main_Gear_Down_Indicator_Fail_Malf_Last_Pass  : Boolean := False;
         LGC_Main_Gear_Inboard_Door_Fail_Malf_Last_Pass    : Boolean := False;
         LGC_Gear_Sequencing_Fail_Malf_Last_Pass           : Boolean := False;
         LGC_Gear_Control_Unit_Malf_One_Last_Pass          : Boolean := False;
         LGC_Gear_Control_Unit_Malf_Two_Last_Pass          : Boolean := False;
         LGC_Fail_Left_Main_Up                             : Boolean := False;
         LGC_Fail_Right_Main_Up                            : Boolean := False;
         LGC_Fail_Left_Main_Down                           : Boolean := False;
         LGC_Fail_Right_Main_Down                          : Boolean := False;
         LGC_Fail_Left_Door_Open                           : Boolean := False;
         LGC_Fail_Right_Door_Open                          : Boolean := False;
         LGC_Fail_Left_Main_Down_Ind                       : Boolean := False;
         LGC_Fail_Right_Main_Down_Ind                      : Boolean := False;
         LGC_Fail_Left_Door_Closed                         : Boolean := False;
         LGC_Fail_Right_Door_Closed                        : Boolean := False;
         LGC_Fail_Nose_Up                                  : Boolean := False;

--         LGC_G : Generator;
         LGC_Random_MLG_Generator_State : Random_MLG.State;

         Wheel_Chock_On                                    : Boolean := False;

      end record;
   This_Subsystem : Instance;

   type Io_Interface_Instance is
      record
         -- digital input
         Downlock_Override_Sw        : Boolean := False;
         Landing_Gear_Down_Sw        : Boolean := True;
         Emer_Landing_Gear_Sw        : Boolean := False;
         Parking_Brake               : Boolean := False;
         Nose_Wheel_Steer            : Boolean := False;
         -- digital output
         Lh_Gear_Green               : Boolean := True;
         Lh_Gear_Red                 : Boolean := False;
         Nose_Gear_Green             : Boolean := True;
         Nose_Gear_Red               : Boolean := False;
         Rh_Gear_Green               : Boolean := True;
         Rh_Gear_Red                 : Boolean := False;
         Landing_Gear_Handle_Lt      : Boolean := False;
         Landing_Gear_Lock           : Boolean := True;
         Nose_Wheel_Steering_Ann     : Boolean := False;
         -- analog input
         -- analog output
         -- spare
         Spare_Io_1                  : Boolean := False;
      end record;

   Io_Size : constant Integer := 4;
   for Io_Interface_Instance use
      record
         -- spare
         Spare_Io_1                    at  000*Io_Size range 0..31;
         -- digital input
         Downlock_Override_Sw          at  001*Io_Size range 0..31;
         Landing_Gear_Down_Sw          at  002*Io_Size range 0..31;
         Emer_Landing_Gear_Sw          at  003*Io_Size range 0..31;
         Parking_Brake                 at  004*Io_Size range 0..31;
         Nose_Wheel_Steer              at  005*Io_Size range 0..31;
         -- digital output
         Lh_Gear_Green                 at  006*Io_Size range 0..31;
         Lh_Gear_Red                   at  007*Io_Size range 0..31;
         Nose_Gear_Green               at  008*Io_Size range 0..31;
         Nose_Gear_Red                 at  009*Io_Size range 0..31;
         Rh_Gear_Green                 at  010*Io_Size range 0..31;
         Rh_Gear_Red                   at  011*Io_Size range 0..31;
         Landing_Gear_Handle_Lt        at  012*Io_Size range 0..31;
         Landing_Gear_Lock             at  013*Io_Size range 0..31;
         Nose_Wheel_Steering_Ann       at  014*Io_Size range 0..31;
         -- analog input               at  015*Io_Size range 0..31;
         -- analog output
      end record;
   This_Io_Interface : Io_Interface_Instance;

   type Ios_Interface_Instance is
      record
         Gear_Position : Integer := 1;
         Nws_Enable    : Boolean := False;
         Nws_Engaged   : Boolean := False;
         Wheel_Chocks  : Boolean := False;
         Main_Gear_Stuck_Up_Malf        : Boolean := False;
         Nose_Gear_Stuck_Up_Malf        : Boolean := False;
         Main_Gear_Stuck_Down_Malf      : Boolean := False;
         Nose_Gear_Stuck_Down_Malf      : Boolean := False;
         Main_Gear_Door_Stuck_Open_Malf : Boolean := False;
         Right_Brake_Pressure_Loss_Malf : Boolean := False;
         Left_Brake_Pressure_Loss_Malf  : Boolean := False;
         Total_Brake_Pressure_Loss_Malf : Boolean := False;
         Right_Tire_Blown_Malf          : Boolean := False;
         Left_Tire_Right_Brake_Malf     : Boolean := False;
         Right_Tire_Left_Brake_Malf     : Boolean := False;
         Loss_NWS_Indication_Malf       : Boolean := False;
         Main_Gear_Down_Indicator_Fail_Malf  : Boolean := False;
         Main_Gear_Inboard_Door_Fail_Malf    : Boolean := False;
         Gear_Sequencing_Fail_Malf      : Boolean := False;
         Gear_Control_Unit_Malf_One     : Boolean := False;
         Gear_Control_Unit_Malf_Two     : Boolean := False;
         Ios_Pilot_Gear                 : Integer := 0;
      end record;
   This_Ios_Interface : Ios_Interface_Instance;


   type Sound_Interface_Instance is
      record
         Left_Main_Gear_Door_Position  : Float := 0.0;
         Right_Main_Gear_Door_Position : Float := 0.0;
         Nose_Gear_Door_Position       : Float := 0.0;
         Left_Main_Gear_Position       : Float := 0.0;
         Right_Main_Gear_Position      : Float := 0.0;
         Nose_Gear_Position            : Float := 0.0;
      end record;
   This_Sound_Interface : Sound_Interface_Instance;



end Jpats_Landing_Gear.Container;


