-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

generic
   type Gear_Switch_Name_Type is (<>);
   type Gear_Switch_Type is private;
   type Array_Of_Gear_Switch_Type is array (Gear_Switch_Name_Type) of Gear_Switch_Type;
   type Gear_Switch_Array_Of_Boolean is array (Gear_Switch_Name_Type) of Boolean;

   with function A_Switch_Is_Closed (A_Switch : in Gear_Switch_Type) return Boolean;
   with function A_Switch_Is_Open (A_Switch : in Gear_Switch_Type) return Boolean;
   with procedure Update_A_Switch (A_Switch      : in out Gear_Switch_Type;
                                   Close_Command : in     Boolean);
   with procedure Initialize_A_Switch (A_Switch : in out Gear_Switch_Type);
   Package_Name : in String;
package Gear_Switch_Collection_G is

   type Instance is private;

   procedure Update
     (An_Instance : in out Instance;
      Request     : in     Gear_Switch_Array_Of_Boolean);

   procedure Initialize
     (An_Instance : in out Instance);

   function Is_Closed
     (An_Instance : in Instance;
      Name        : in Gear_Switch_Name_Type)
     return Boolean;

   function Is_Open
     (An_Instance : in Instance;
      Name        : in Gear_Switch_Name_Type)
     return Boolean;

private

   type Instance is
      record
         Gear_Switches : Array_Of_Gear_Switch_Type;
      end record;

end Gear_Switch_Collection_G;
