-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Gear_Switch_Collection_G is

   procedure Update
     (An_Instance : in out Instance;
      Request     : in     Gear_Switch_Array_Of_Boolean)
   is
   begin
      for Name in Gear_Switch_Name_Type
      loop
         Update_A_Switch (An_Instance.Gear_Switches (Name), Request (Name));
      end loop;
   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      for Name in Gear_Switch_Name_Type
      loop
         Initialize_A_Switch (An_Instance.Gear_Switches (Name));
      end loop;
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;

   function Is_Closed
     (An_Instance : in Instance;
      Name        : in Gear_Switch_Name_Type)
     return Boolean
   is
   begin
      return A_Switch_Is_Closed (An_Instance.Gear_Switches (Name));
   exception
      when others =>
         Log.Report(Package_Name & ".Is_Closed()");
         raise;
   end Is_Closed;

   function Is_Open
     (An_Instance : in Instance;
      Name        : in Gear_Switch_Name_Type)
     return Boolean
   is
   begin
      return A_Switch_Is_Open (An_Instance.Gear_Switches (Name));
   exception
      when others =>
         Log.Report(Package_Name & ".Is_Open()");
         raise;
   end Is_Open;

end Gear_Switch_Collection_G;
