-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Angle_Types;
with Length_Types;
with First_Order_Filter;

generic
   --| Setting Parameters
   Tho_Filtered_Yaw_Rate        : Float := 1.5;
   Tho_Filtered_Lat_Acc         : Float := 1.0;
   Max_Heading_Err              : Float := 2.5;
   Max_Lat_Acc                  : Float := 0.3;
   Gain_Yaw_Damper_x1           : Float := 7.0;
   Gain_Yaw_Damper_x2           : Float := 12.0;
   Gain_Heading_Error_X1        : Float := 7.0;
   Gain_Heading_Error_X2        : Float := 12.0;
   Max_Rud_Rate                 : Float :=  1.0;
   Fader_Time                   : Float :=  3.0;

package Yaw_Driver  is

   type Instance is private;


   procedure Set_Gain
     (Tuning_Mode      :in     Integer;
      KP_Sideslip      :in     Float;
      KP_Lat_Acc       :in     Float;
      KI_Lat_Acc       :in     Float;
      KD_Lat_Acc       :in     Float;
      Yaw_Gain         :in     Float;
      Heading_Gain     :in     Float;
      An_Instance      :in out Instance);

   procedure Initialize
     (An_Instance             :in out  Instance);

   procedure Set_Mode
     (Mode                    :in       Integer;
      An_Instance             :in out   Instance);

   procedure Reset_Internal_variables
     (Yaw_Rate           :in      Angle_Types.Degrees_Per_Sec;
      Lateral_Acc        :in      Length_Types.Feet_Per_Sec_Sq;
      Rudder_Deflection  :in      Angle_Types.Degrees;
      An_Instance        :in out  Instance);

   procedure Set_Reference
     (Mode                    :in      Integer;
      Selected_Heading        :in      Angle_Types.Degrees;
      An_Instance             :in out  Instance);


   procedure Update
     (Heading                    :in      Angle_Types.Degrees;
      Altitude_AGL               :in      Length_Types.Feet;
      TAS                        :in      Length_Types.Feet_Per_Sec;
      Roll_Angle                 :in      Angle_Types.Degrees;
      Pitch_Angle                :in      Angle_Types.Degrees;
      Yaw_Rate                   :in      Angle_Types.Degrees_Per_Sec;
      Sideslip_Angle             :in      Angle_Types.Degrees;
      Lateral_Acc                :in      Length_Types.Feet_Per_Sec_Sq;
      V_North                    :in      Length_Types.Feet_Per_Sec;
      V_East                     :in      Length_Types.Feet_Per_Sec;
      Q_Bar                      :in      Float;
      Nose_Wow                   :in      Boolean;
      Force_Body_Z               :in      Float;
      Rudder_Deflection          :in      Angle_Types.Degrees;
      Pilot_Force                :in      Float;
      Dt                         :in      Float;
      An_Instance                :in out  Instance);

   procedure Set_Backdrive_Mode
     (Is_On                   :in       Boolean;
      An_Instance             :in out   Instance);

   function Commanded_Rudder_deflection(An_Instance :in Instance)
                                         return Angle_Types.Degrees;
   function Is_on(An_Instance :in Instance)
                                         return Boolean;
   function Mode(An_Instance :in Instance)
                                         return Integer;
   function Debug1(An_Instance :in Instance) return Float;
   function Debug2(An_Instance :in Instance) return Float;
   function Debug3(An_Instance :in Instance) return Float;
   function Debug4(An_Instance :in Instance) return Float;
   function Backdrive(An_Instance :in Instance) return Boolean;
   function Backdrive_Force (An_Instance :in Instance) return Float;

   private
   type Instance is
      record
         Mode                         : Integer  := 0;
         Selected_Heading             : Angle_Types.Degrees := 0.0;
         Filtered_Yaw_Rate            : First_Order_Filter.Washout;
         Filtered_Lat_Acc             : First_Order_Filter.Lowpass;
         Last_Lat_Acc                 : Float  := 0.0;
         Integral_Lat_Acc             : Float  := 0.0;

         Error                        : Float := 0.0;
         Error_L                      : Float := 0.0;
         t_TO                         : Float := 0.0;
         lat_TO                       : Float := 0.0;
         long_TO                      : Float := 0.0;

         Commanded_Rudder_Deflection  : Angle_Types.Degrees := 0.0;
         Fader                        : Float  := 0.0;



         --| Tuning Variables
         Tuning_mode                  : Integer  := 0;
         KP_Sideslip                  : Float    := 1.0;
         KP_Lat_Acc                   : Float    := 1.0;
         KI_Lat_Acc                   : Float    := 0.10;
         KD_Lat_Acc                   : Float    := 1.0;
         Yaw_Gain                     : Float    := 1.5;
         Heading_Gain                 : Float    := 1.5;

          -- BACKDRIVE
         Backdrive                   : Boolean := False;
         Filtered_Force              : First_Order_Filter.Lowpass;
         Washout_Force               : First_Order_Filter.washout;
         Backdrive_Force             : Float  := 0.0;



         -- debug
         Debug1 :Float :=0.0;
         Debug2 :Float :=0.0;
         Debug3 :Float :=0.0;
         Debug4 :Float :=0.0;

      end record;

end  Yaw_Driver;





