-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Asep Rahmat
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Angle_Types;
with Length_Types;
with Normalized_Types;
with First_Order_Filter;

generic
   --| Setting Parameters

   Tho_Filtered_Pitch          : Float ;
   Tho_Filtered_IAS            : Float ;
   Tho_washout_Pitch           : Float ;
   Max_Delta_PLA               : Float ;
   Fader_Time                  : Float ;



package Torque_Driver  is

   type Instance is private;



   procedure Set_Gain
     (Tuning_Mode              :in     Integer;
      KP_Torque                :in     Float;
      KI_Torque                :in     Float;
      KD_Torque                :in     Float;
      Max_Torque_Err           :in     Float;

      KP_IAS                   :in     Float;
      KI_IAS                   :in     Float;
      KD_IAS                   :in     Float;
      Max_IAS_Err              :in     Float;

      Pitch_Gain               :in     Float;
      Nominal_Torque_Comp      :in     Float;
      An_Instance              :in out Instance);

   procedure initialize
     (An_Instance             :in out  Instance);

   procedure Set_Mode
     (Mode                    :in       Integer;
      An_Instance             :in out   Instance);

   procedure Reset_Internal_variables
     (Pitch_Angle        :in      Angle_Types.Degrees;
      PLA                :in      Angle_Types.Degrees;
      An_Instance        :in out  Instance);

   procedure Set_Reference
     (Mode                    :in      Integer;
      Selected_Torque         :in      float;
      Selected_IAS            :in      Length_Types.Knots;
      Selected_Time_Constant  :in      float;
      An_Instance             :in out  Instance);


   procedure Update
     (Torque                     :in      Normalized_Types.Normalize;
      PLA                        :in      Angle_Types.Degrees;
      IAS                        :in      Length_Types.Knots;
      Pitch_Angle                :in      Angle_Types.Degrees;
      Flap_Pos                   :in      Angle_Types.Degrees;
      Gear_Pos                   :in      Float;
      Nx                         :in      Float;
      Dt                         :in      Float;
      An_Instance                :in out  Instance);

   procedure Set_debug1
     (Debug1                  :in       float;
      An_Instance             :in out   Instance);
   procedure Set_debug2
     (Debug2                  :in       float;
      An_Instance             :in out   Instance);


   function Commanded_PLA(An_Instance :in Instance)
                          return Angle_Types.Degrees;
   function Is_On(An_Instance :in Instance)
                  return Boolean;
   function Established(An_Instance :in Instance)
                        return Boolean;
   function Mode(An_Instance :in Instance)
                 return Integer;
   function Debug1(An_Instance :in Instance) return Float;
   function Debug2(An_Instance :in Instance) return Float;
   function Debug3(An_Instance :in Instance) return Float;
   function Debug4(An_Instance :in Instance) return Float;

   function Selected_IAS(An_Instance :in Instance) return Float;
   function Selected_Torque(An_Instance :in Instance) return Float;

private
   type Instance is
      record
         Mode                         : Integer  := 0;
         Selected_Torque              : Float:=0.0;
         Time_Constant                : Float:=5.0;
         Selected_IAS                 : Length_Types.Knots:=0.0;
         Filtered_Pitch               : First_Order_Filter.Lowpass;
         Filtered_IAS                 : First_Order_Filter.Lowpass;
         Filtered_Torque              : First_Order_Filter.Lowpass;
         Washout_Pitch                : First_Order_Filter.washout;
         Integral_IAS_Error           : Length_Types.Knots := 0.0;
         Last_IAS_Error               : Length_Types.Knots := 0.0;
         Integral_Torque_Error        : Float := 0.0;
         Last_Torque_Error            : Float := 0.0;
         Commanded_Pla                : Angle_Types.Degrees := 0.0;
         Fader                        : Float  := 0.0;
         Easy_On                      : Float  := 0.0;

         -- TUNING VARIABLES
         Tuning_Mode                  : Integer  := 0;
         KP_Torque                    : Float := 0.3;
         KI_Torque                    : Float := 0.1;
         KD_Torque                    : Float := 0.5;
         Max_Torque_Err               : Float :=  2.5;

         KP_IAS                      : Float := 10.0;
         KI_IAS                      : Float := 0.1;
         KD_IAS                      : Float := 1.0;
         Max_IAS_Err                 : Float := 3.0;

         Pitch_Gain                  : Float := 3.0;
         Nominal_Torque_Comp         : Float := 35.0;



         -- debug
         Debug1 :Float :=0.0;
         Debug2 :Float :=0.0;
         Debug3 :Float :=0.0;
         Debug4 :Float :=0.0;
      end record;


end  Torque_Driver;





