-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Asep Rahmat
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Angle_Types;
with Length_Types;
with First_Order_Filter;

generic
   --| Setting Parameters
   Tho_Filtered_Selected_Roll    : Float ;
   Tho_Filtered_Selected_turn    : Float ;
   Tho_Filtered_Heading_error    : Float ;
   Max_Roll_Angle                : Float ;
   Max_Ail_Rate                  : Float ;
   Gain_Aileron_Effectiveness_x1 : Float ;
   Gain_Aileron_Effectiveness_x2 : Float ;
   Gain_Wing_level_x1            : Float ;
   Gain_Wing_level_x2            : Float ;
   Fader_Time                    : Float ;
package Roll_Driver  is

   type Instance is private;

   HEADING_DELTA       : constant array(1..9) of Float := 
                           (1 => 10.0,
                            2 => 15.0,
                            3 => 20.0,
                            4 => 40.0,
                            5 => 50.0,
                            6 => 70.0,
                            7 => 80.0,
                            8 => 140.0,
                            9 => 220.0);
   Heading_Buffer     : Float := 0.0;
                            

   procedure Set_Gain
     (Tuning_Mode      :in      Integer;
      Comm_Roll        :in      Float;
      KP_Roll          :in      Float;
      KI_Roll          :in      Float;
      KD_Roll          :in      Float;
      Max_Roll_Rate    :in      Float;

      Comm_Turn_Rate   :in      Float;
      KP_Turn_Rate     :in      Float;
      KI_Turn_Rate     :in      Float;
      Delta_Max_Selected_Turn:in Float;
      Max_Turn_Err     :in      Float;

      KP_Heading       :in      Float;
      KI_Heading       :in      Float;
      KD_Heading       :in      Float;
      Max_Heading_Err  :in      Float;

      An_Instance      :in out Instance);

   procedure initialize
     (An_Instance             :in out  Instance);

   procedure Init_Rapid_Direction_Change(
      Roll_Angle              :in Angle_Types.Degrees;      
      An_Instance             :in out  Instance);

   procedure Set_Mode
     (Mode                    :in       Integer;
      An_Instance             :in out   Instance);

   procedure Reset_Internal_variables
     (Roll_Angle         :in      Angle_Types.Degrees;
      Roll_Rate          :in      Angle_Types.Degrees_Per_Sec;
      Aileron_Deflection :in      Angle_Types.Degrees;
      An_Instance        :in out   Instance);

   procedure Set_Reference
     (Mode                    :in      Integer;
      Steady_Turn             :in      Boolean;
      Selected_Heading        :in      Angle_Types.Degrees;
      Heading                 :in      Angle_Types.Degrees;
      Selected_Turn_Rate      :in      Integer;
      Selected_Turn_Direction :in      Integer;
      Selected_Climb_rate     :in      Length_Types.Feet_Per_Min;
      Selected_IAS            :in      Length_Types.Knots;
      Selected_Torque         :in      Float;
      Performance_Mode        :in      Integer;
      An_Instance             :in out  Instance);


   procedure Update
     (Turn_Rate          : in      Angle_Types.Degrees_Per_Sec;
      Steady_Right_Turn  : in      Boolean;
      Steady_Left_Turn   : in      Boolean;
      Heading            : in      Angle_Types.Degrees;
      Roll_Rate          : in      Angle_Types.Degrees_Per_Sec;
      Roll_Angle         : in      Angle_Types.Degrees;
      Pitch_Angle        : in      Angle_Types.Degrees;
      Aileron_Deflection : in      Angle_Types.Degrees;
      TAS                : in      Length_Types.Feet_Per_Sec;
      Altitude_AGL       : in      Length_Types.Feet;
      Flap_Pos           : in      Float;
      Gear_Pos           : in      Float;
      Pilot_Force        : in      Float;
      Dt                 : in      Float;
      An_Instance        : in out  Instance);

   procedure Set_Backdrive_Mode
     (Is_On                   :in       Boolean;
      An_Instance             :in out   Instance);

   procedure Set_Selected_Heading
     (Heading                 :in       Float;
      An_Instance             :in out   Instance);


   procedure Set_debug1
     (Debug1                  :in       float;
      An_Instance             :in out   Instance);
   procedure Set_debug2
     (Debug2                  :in       float;
      An_Instance             :in out   Instance);

   function Commanded_Aileron_deflection(An_Instance :in Instance)
                                         return Angle_Types.Degrees;
   function Is_on(An_Instance :in Instance)
                  return Boolean;
   function Selected_heading(An_Instance :in Instance)
                                         return Angle_Types.Degrees;
   function Mode(An_Instance :in Instance)
                                         return Integer;
   function Debug1(An_Instance :in Instance) return Float;
   function Debug2(An_Instance :in Instance) return Float;
   function Debug3(An_Instance :in Instance) return Float;
   function Debug4(An_Instance :in Instance) return Float;

   function Selected_Turn_Rate(An_Instance :in Instance) return Float;
   function Maximum_Roll_Angle(An_Instance : in Instance) return Float;
   function Backdrive(An_Instance :in Instance) return Boolean;
   function Backdrive_Force (An_Instance :in Instance) return Float;

   private


   type Instance is
      record
         Mode                         : Integer  := 0;
         Selected_Turn_Rate           : Angle_Types.Degrees_Per_Sec := 3.0;
         Selected_Heading             : Angle_Types.Degrees := 0.0;
         Filtered_Selected_Roll       : First_Order_Filter.Lowpass;
         Filtered_Selected_turn       : First_Order_Filter.Lowpass;
         Filtered_Heading_Error       : First_Order_Filter.Lowpass;
         Commanded_Roll               : Angle_Types.Degrees := 0.0;
         Commanded_Roll_Rate          : Angle_Types.Degrees_Per_Sec := 0.0;
         Integral_Turn_Rate_error     : Angle_Types.Degrees_Per_Sec := 0.0;
         Integral_Roll_Error          : Angle_Types.Degrees := 0.0;
         Integral_Heading_Error       : Angle_Types.Degrees := 0.0;
         Mode_Catch_Up_Is_On          : Boolean := True;
         Commanded_Aileron_Deflection : Angle_Types.Degrees := 0.0;
         Heading_Hold_Is_On           : Boolean := False;
         Heading_Hold_Is_Locked       : Boolean := False;
         Fader                        : Float  := 0.0;
         Easy_On                      : Float  := 0.0;


         -- TUNING VARIABLES
         Tuning_Mode                 : Integer  := 0;
         Comm_Roll                   : Float := 0.0;
         KP_Roll                     : Float := 1.0;
         KI_Roll                     : Float := 0.5;
         KD_Roll                     : Float := 1.0;
         Max_Roll_Rate               : Float := 19.5;

         Comm_Turn_Rate              : Float := 0.0;
         KP_Turn_Rate                : Float := 0.1;
         KI_Turn_Rate                : Float := 0.1;
         Delta_Max_Selected_Turn     : Float := 30.0;
         Max_Turn_Err                : Float := 0.3;

         KP_Heading                  : Float := 1.0;
         KI_Heading                  : Float := 1.0;
         KD_Heading                  : Float := 0.05;
         Max_Heading_Err             : Float := 0.5;

         Gain_Selected_Turn_Rate_x1  : Float := 3.0;
         Gain_Selected_Turn_Rate_x2  : Float := 10.0;
         Gain_Heading_Error_X1       : Float := 3.0;
         Gain_Heading_Error_X2       : Float := 10.0;

         -- BACKDRIVE
         Backdrive                   : Boolean := False;
         Backdrive_Force              : Float  := 0.0;

         -- debug
         Debug1 :Float :=0.0;
         Debug2 :Float :=0.0;
         Debug3 :Float :=0.0;
         Debug4 :Float :=0.0;

      end record;

end  Roll_Driver;





