-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Asep Rahmat
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|: Length_Types.Feet_per_Min := 0.0;
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Angle_Types;
with Length_Types;
with First_Order_Filter;
with Interpolation_Table.Singly_Indexed;
with Jpats_Ios_Pilot_Types;           use  Jpats_Ios_Pilot_Types;


generic
   --| Setting Parameters
   Tho_Filtered_Selected_Pitch     : Float ;
   Tho_Filtered_IAS_Err            : Float ;
   Tho_Filtered_Selected_Climb     : Float ;
   Tho_Filtered_Selected_Altitude  : Float ;
   Max_Delta_elev                  : Float ;
   AOA_Stall                       : Float ;
   Fader_Time                      : Float ;

package Pitch_Driver  is

   type Instance is private;


   procedure Set_Gain
     (Tuning_Mode                    :in     Integer;
      Comm_Pitch                     :in     Float;
      KP_Pitch                       :in     Float;
      KI_Pitch                       :in     Float;
      KD_Pitch                       :in     Float;
      Max_Pitch_Rate                 :in     Float;

      KP_Climb                       :in     Float;
      KI_Climb                       :in     Float;
      Max_Climb_rate                 :in     Float;

      KP_IAS                         :in     Float;
      KI_IAS                         :in     Float;
      KD_IAS                         :in     Float;
      Max_IAS_Err                    :in     Float;
      Max_IAS_Rate                   :in     Float;

      KP_Altitude                    :in     Float;
      KI_Altitude                    :in     Float;
      KD_Altitude                    :in     Float;
      Max_Alt_Err                    :in     Float;

      Gain_Roll_compensator          :in     Float;
      Gain_Torque_compensator        :in     Float;
      Gain_Stall_Correction          :in     Float;


      Limited_AOA                    :in     Float;
      An_Instance                    :in out Instance);

   procedure initialize
     (An_Instance             :in out  Instance);

   procedure Set_Mode
     (Mode                    :in       Integer;
      An_Instance             :in out   Instance);

   procedure Reset_Internal_Variables
     (Pitch_Angle        :in      Angle_Types.Degrees;
      Pitch_Rate         :in      Angle_Types.Degrees_Per_Sec;
      AOA                :in      Angle_Types.Degrees;
      Altitude           :in      Length_Types.Feet;
      Climb_rate         :in      Length_Types.Feet_Per_Min;
      IAS                :in      Length_Types.Knots;
      Torque             :in      Float;
      Elevator_Deflection:in      Angle_Types.Degrees;
      An_Instance        :in out  Instance);

   procedure Set_Reference
     (Mode                    :in      Integer;
      Selected_Altitude       :in      Length_Types.Feet;
      Selected_Climb_rate     :in      Length_Types.Feet_Per_Min;
      Selected_IAS            :in      Length_Types.Knots;
      Selected_Torque         :in      Float;
      Performance_Mode        :in      Integer;
      An_Instance             :in out  Instance);


   procedure Update
     (Altitude                   :in      Length_Types.Feet;
      Climb_rate                 :in      Length_Types.Feet_Per_Min;
      IAS                        :in      Length_Types.Knots;
      Roll_Angle                 :in      Angle_Types.Degrees;
      Pitch_Angle                :in      Angle_Types.Degrees;
      AOA                        :in      Angle_Types.Degrees;
      Pitch_Rate                 :in      Angle_Types.Degrees_Per_Sec;
      TAS                        :in      Length_Types.Feet_Per_Sec;
      Altitude_AGL               :in      Length_Types.Feet;
      Elevator_Deflection        :in      Angle_Types.Degrees;
      Flap_Pos                   :in      Angle_Types.Degrees;
      Nx                         :in      Float;
      Torque                     :in      Float;
      Pilot_Force                :in      Float;
      Dt                         :in      Float;
      Bypass                     :in      Boolean;
      An_Instance                :in out  Instance);


   procedure Set_Backdrive_Mode
     (Is_On                   :in       Boolean;
      An_Instance             :in out   Instance);

   procedure Set_Altitude_Hold_Enable
     (Is_enabled              :in       Boolean;
      An_Instance             :in out   Instance);

   procedure Set_Selected_Altitude
     (Selected_Altitude       :in       float;
      An_Instance             :in out   Instance);

   procedure Set_debug1
     (Debug1                  :in       float;
      An_Instance             :in out   Instance);
   procedure Set_debug2
     (Debug2                  :in       float;
      An_Instance             :in out   Instance);

   function Commanded_Elevator_Deflection(An_Instance :in Instance)
                                          return Angle_Types.Degrees;
   function Is_On(An_Instance :in Instance)
                  return Boolean;
   function Mode(An_Instance :in Instance)
                 return Integer;
   function Performance_Mode(An_Instance :in Instance)
                             return Integer;
   function Debug1(An_Instance :in Instance) return Float;
   function Debug2(An_Instance :in Instance) return Float;
   function Debug3(An_Instance :in Instance) return Float;
   function Debug4(An_Instance :in Instance) return Float;

   function Selected_Climb_Rate(An_Instance :in Instance) return Float;

   function Selected_IAS(An_Instance :in Instance) return Float;
   function Selected_Altitude(An_Instance :in Instance) return Float;
   function Backdrive(An_Instance :in Instance) return Boolean;
   function Backdrive_Force (An_Instance :in Instance) return Float;
   function Altitude_Hold_Is_on(An_Instance :in Instance)return Boolean;
   function Get_AOA_Stall return Float;


private
   type Instance is
      record
         Mode                         : Integer  := 0;
         Performance_Mode             : Performance_Mode_Type :=IAS_TORQUE_HOLD;
         Selected_Altitude            : Length_Types.Feet := 0.0;
         Selected_Climb_rate          : Length_Types.Feet_per_Min := 0.0;
         Selected_IAS                 : Length_Types.Knots:=0.0;
         IAS_Last                     : Length_Types.Knots:=0.0;
         Commanded_Pitch_Angle        : Angle_Types.Degrees := 0.0;
         Commanded_Pitch_Rate         : Angle_Types.Degrees_Per_Sec := 0.0;
         Filtered_Selected_Pitch      : First_Order_Filter.Lowpass;
         Filtered_IAS_Err             : First_Order_Filter.Lowpass;
         Filtered_Selected_Climb      : First_Order_Filter.Lowpass;
         Filtered_Selected_Altitude   : First_Order_Filter.Lowpass;
         Filtered_AOA                 : First_Order_Filter.Lowpass;
         Filtered_Torque              : First_Order_Filter.Lowpass;
         Washout_Torque               : First_Order_Filter.washout;
         Integral_Pitch_Error         : Angle_Types.Degrees := 0.0;
         Integral_Altitude_Error      : Angle_Types.Degrees := 0.0;
         Integral_IAS_Error           : Length_Types.Knots:=0.0;
         Integral_Climb_Error         : Length_Types.Feet_per_Min := 0.0;
         Commanded_Elevator_Deflection: Angle_Types.Degrees := 0.0;
         Altitude_Hold_Enabled        : Boolean := False;
         Altitude_Hold_Is_On          : Boolean := False;
         Altitude_Hold_Is_Locked      : Boolean := False;
         Fader                        : Float  := 0.0;
         Easy_On                      : Float  := 0.0;

         -- TUNING VARIABLES
         Tuning_Mode                  : Integer  := 0;
         Comm_Pitch                   : Float := 0.0;
         KP_Pitch                     : Float := 1.0;
         KI_Pitch                     : Float := 0.5;
         KD_Pitch                     : Float := 1.0;
         Max_Pitch_Rate               : Float := 7.5;

         KP_Climb                     : Float := 0.01;
         KI_Climb                     : Float := 0.005;
         Max_Climb_rate               : Float := 400.0;

         KP_IAS                       : Float := 3.0;
         KI_IAS                       : Float := 0.3;
         KD_IAS                       : Float := 10.0;
         Max_IAS_Err                  : Float := 7.5;
         Max_IAS_Rate                 : Float := 7.5;

         KP_Altitude                  : Float := 0.5;
         KI_Altitude                  : Float := 0.055;
         KD_Altitude                  : Float := 10.0;
         Max_Alt_Err                  : Float := 10.0;

         Gain_Roll_compensator        : Float := 2.0;
         Gain_Torque_compensator      : Float := 2.0;
         Gain_Stall_Correction        : Float := 2.0;

         Altitude_to_Climb_Hold_Gain_x1  : Float := 30.0;
         Altitude_to_Climb_Hold_Gain_x2  : Float := 200.0;
         Altitude_Hold_Gain_x1           : Float := 30.0;
         Altitude_Hold_Gain_x2           : Float := 200.0;
         Limited_AOA                     : Float := 0.0;

          -- BACKDRIVE
         Backdrive                   : Boolean := False;
         Backdrive_Force             : Float  := 0.0;


                -- debug
         Debug1 :Float :=0.0;
         Debug2 :Float :=0.0;
         Debug3 :Float :=0.0;
         Debug4 :Float :=0.0;


      end record;
end  Pitch_Driver;





