-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------



package Jpats_Ios_Pilot is

   function Ios_Pilot_Enable     return Boolean;
   function Is_on                return Boolean;
   function Is_Established       return Boolean;
   function Pitch_Driver_Is_on   return Boolean;
   function Roll_Driver_Is_on    return Boolean;
   function Yaw_Driver_Is_on     return Boolean;
   function Torque_Driver_Is_on  return Boolean;
   function Request_Gear_Up      return Boolean;
   function Request_Gear_Down    return Boolean;

   function R_Ail_pos return float;
   function Elev_pos return float;
   function Rud_pos return float;
   function PLA  return Float;

   function Pitch_Backdrive return Boolean;
   function Pitch_Backdrive_force return Float;
   function Roll_Backdrive return Boolean;
   function Roll_Backdrive_force return Float;
   function Yaw_Backdrive return Boolean;
   function Yaw_Backdrive_force return Float;


   function Debug1  return Float;
   function Debug2  return Float;
   function Debug3  return Float;
   function Debug4  return Float;
   function Debug5  return Float;
   function Debug6  return Float;
   function Debug7  return Float;
   function Debug8  return Float;
   function Debug9  return Float;
   function Debug10 return Float;

   function Bool1 return Boolean;
   function Bool2 return Boolean;
   function Bool3 return Boolean;
   function Bool4 return Boolean;
   function Bool5 return Boolean;



end Jpats_Ios_Pilot;
