-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:   Asep Rahmat
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Ios_Pilot.container;
with Torque_Driver;
with Log;

package body Jpats_Ios_pilot is

   package CNT   renames JPATS_IOS_Pilot.Container;

   function Ios_Pilot_Enable    return Boolean
   is

      Ios_Pilot : CNT.Ios_Interface_Instance renames CNT.This_Ios_Interface;
   begin
      return Ios_Pilot.Enable;
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Pilot_Enable()");
         raise;
   end Ios_Pilot_Enable;

   function Is_on                return Boolean
   is
   begin
      return ((CNT.This_Subsystem.Mode /=0) and
              (CNT.IOS_Pilot_Pitch_Driver.Is_On(CNT.This_Subsystem.The_IOS_Pilot_Pitch_Driver) or
               CNT.IOS_Pilot_Roll_Driver.Is_On(CNT.This_Subsystem.The_IOS_Pilot_Roll_Driver) or
               CNT.IOS_Pilot_Yaw_Driver.Is_On(CNT.This_Subsystem.The_IOS_Pilot_Yaw_Driver) or
               CNT.IOS_Pilot_Torque_Driver.Is_On(CNT.This_Subsystem.The_IOS_Pilot_Torque_Driver) or
               CNT.This_Subsystem.TO_Phase > 0)) ;
   exception
      when others =>
         Log.Report("Jpats_ios_pilot.Is_on()");
         raise;
   end Is_on;

   function Is_Established            return Boolean
   is
   begin
      return CNT.IOS_Pilot_Torque_Driver.Established(CNT.This_Subsystem.The_IOS_Pilot_Torque_Driver) ;
   exception
      when others =>
         Log.Report("Jpats_ios_pilot.Is_Established()");
         raise;
   end Is_Established;

   function Pitch_Driver_Is_on  return Boolean
   is
   begin
      return ((CNT.This_Subsystem.Mode /=0) and
              CNT.IOS_Pilot_Pitch_Driver.Is_On(CNT.This_Subsystem.The_IOS_Pilot_Pitch_Driver)) ;
   exception
      when others =>
         Log.Report("Jpats_ios_pilot.Pitch_Driver_Is_on()");
         raise;
   end Pitch_Driver_Is_on;

   function Roll_Driver_Is_on  return Boolean
   is
   begin
      return ((CNT.This_Subsystem.Mode/=0) and
              CNT.IOS_Pilot_Roll_Driver.Is_On(CNT.This_Subsystem.The_IOS_Pilot_Roll_Driver)) ;
   exception
      when others =>
         Log.Report("Jpats_ios_pilot.Roll_Driver_Is_on()");
         raise;
   end Roll_Driver_Is_on;

   function Yaw_Driver_Is_on  return Boolean
   is
   begin
      return ((CNT.This_Subsystem.Mode/=0) and
              CNT.IOS_Pilot_Yaw_Driver.Is_On(CNT.This_Subsystem.The_IOS_Pilot_Yaw_Driver)) ;
   exception
      when others =>
         Log.Report("Jpats_ios_pilot.Yaw_Driver_Is_on()");
         raise;
   end Yaw_Driver_Is_on;

   function Torque_Driver_Is_on  return Boolean
   is
   begin
      return ((CNT.This_Subsystem.Mode/=0) and
              CNT.IOS_Pilot_Torque_Driver.Is_On(CNT.This_Subsystem.The_IOS_Pilot_Torque_Driver)) ;
   exception
      when others =>
         Log.Report("Jpats_ios_pilot.Torque_Driver_Is_on()");
         raise;
   end Torque_Driver_Is_on;


   function Request_Gear_Up   return Boolean
   is
      Ios_Pilot : CNT.Ios_Interface_Instance renames CNT.This_Ios_Interface;
   begin
      return IOS_Pilot.Request_Gear_Up;
   exception
      when others =>
         Log.Report("Jpats_ios_pilot.Request_Gear_Up()");
         raise;
   end Request_Gear_Up ;

   function Request_Gear_Down   return Boolean
   is
      Ios_Pilot : CNT.Ios_Interface_Instance renames CNT.This_Ios_Interface;
   begin
      return IOS_Pilot.Request_Gear_Down;
   exception
      when others =>
         Log.Report("Jpats_ios_pilot.Request_Gear_Down()");
         raise;
   end Request_Gear_Down ;

   function R_Ail_pos return Float is
   begin
      return CNT.IOS_Pilot_Roll_Driver.Commanded_Aileron_Deflection
        (CNT.This_Subsystem.The_IOS_Pilot_Roll_Driver);
   end R_Ail_Pos;
   function Elev_pos return Float is
   begin
      return CNT.IOS_Pilot_Pitch_Driver.Commanded_Elevator_Deflection
        (CNT.This_Subsystem.The_IOS_Pilot_Pitch_Driver);
   end Elev_Pos;
   function Rud_pos return Float is
   begin
      return CNT.IOS_Pilot_Yaw_Driver.Commanded_Rudder_Deflection
        (CNT.This_Subsystem.The_IOS_Pilot_Yaw_Driver);
   end Rud_Pos;

   function PLA  return Float is
   begin
       return CNT.IOS_Pilot_Torque_Driver.Commanded_PLA
         (CNT.This_Subsystem.The_IOS_Pilot_torque_Driver);
   end PLA;


   function Pitch_Backdrive return Boolean  is
   begin
      return CNT.IOS_Pilot_Pitch_Driver.Backdrive(CNT.This_Subsystem.The_IOS_Pilot_Pitch_Driver);
   exception
      when others =>
         Log.Report(Event    => "Jpats_ios_pilot.Pitch_Backdrive",
                    Severity => Log.ERROR);
         raise;
   end Pitch_Backdrive;

   function Pitch_Backdrive_force return float  is
   begin
      return CNT.IOS_Pilot_Pitch_Driver.Backdrive_force(CNT.This_Subsystem.The_IOS_Pilot_Pitch_Driver);
   exception
      when others =>
         Log.Report(Event    => "Jpats_ios_pilot.Pitch_Backdrive_force",
                    Severity => Log.ERROR);
         raise;
   end Pitch_Backdrive_force;

   function Roll_Backdrive return Boolean  is
   begin
      return CNT.IOS_Pilot_Roll_Driver.Backdrive(CNT.This_Subsystem.The_IOS_Pilot_Roll_Driver);
   exception
      when others =>
         Log.Report(Event    => "Jpats_ios_pilot.Roll_Backdrive",
                    Severity => Log.ERROR);
         raise;
   end Roll_Backdrive;

   function Roll_Backdrive_force return float  is
   begin
      return CNT.IOS_Pilot_Roll_Driver.Backdrive_force(CNT.This_Subsystem.The_IOS_Pilot_Roll_Driver);
   exception
      when others =>
         Log.Report(Event    => "Jpats_ios_pilot.Roll_Backdrive_force",
                    Severity => Log.ERROR);
         raise;
   end Roll_Backdrive_force;

   function Yaw_Backdrive return Boolean  is
   begin
      return CNT.IOS_Pilot_Yaw_Driver.Backdrive(CNT.This_Subsystem.The_IOS_Pilot_Yaw_Driver);
   exception
      when others =>
         Log.Report(Event    => "Jpats_ios_pilot.Yaw_Backdrive",
                    Severity => Log.ERROR);
         raise;
   end Yaw_Backdrive;

   function Yaw_Backdrive_force return float  is
   begin
      return CNT.IOS_Pilot_Yaw_Driver.Backdrive_force(CNT.This_Subsystem.The_IOS_Pilot_Yaw_Driver);
   exception
      when others =>
         Log.Report(Event    => "Jpats_ios_pilot.Yaw_Backdrive_force",
                    Severity => Log.ERROR);
         raise;
   end Yaw_Backdrive_force;



   function Debug1  return Float is
   begin
      return CNT.Debug1;
   end Debug1;
   function Debug2  return Float is
   begin
      return CNT.Debug2;
   end Debug2;
   function Debug3  return Float is
   begin
      return CNT.Debug3;
   end Debug3;
   function Debug4  return Float is
   begin
      return CNT.Debug4;
   end Debug4;
   function Debug5  return Float is
   begin
      return CNT.Debug5;
   end Debug5;
   function Debug6  return Float is
   begin
      return CNT.Debug6;
   end Debug6;
   function Debug7  return Float is
   begin
      return CNT.Debug7;
   end Debug7;
   function Debug8  return Float is
   begin
      return CNT.Debug8;
   end Debug8;
   function Debug9  return Float is
   begin
      return CNT.Debug9;
   end Debug9;
   function Debug10 return Float is
   begin
      return CNT.Debug10;
   end Debug10;

   function Bool1 return Boolean is
   begin
      return CNT.Bool1;
   end Bool1;
   function Bool2 return Boolean is
   begin
      return CNT.Bool2;
   end Bool2;
   function Bool3 return Boolean is
   begin
      return CNT.Bool3;
   end Bool3;
   function Bool4 return Boolean is
   begin
      return CNT.Bool4;
   end Bool4;
   function Bool5 return Boolean is
   begin
      return CNT.Bool5;
   end Bool5;
end Jpats_Ios_pilot;
