-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Asep Rahmat
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_IOS_Pilot.Container;
with Jpats_Ios_Interface;
with Log;

package body Jpats_IOS_Pilot.Ios_Interface is

   package Ctnr renames Container;
   Ios_Pilot : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;

   package JII renames Jpats_Ios_Interface;

   procedure Enable(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Enable := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Enable()");
         raise;
   end Enable;

   procedure Takeoff(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Takeoff := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Takeoff()");
         raise;
   end Takeoff;

   procedure Altitude_Engaged(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Altitude_Engaged := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Altitude_Engaged()");
         raise;
   end Altitude_Engaged;

   procedure Altitude(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Altitude := JII.Convert_To_Float(PData);
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Altitude()");
         raise;
   end Altitude;

   procedure Altitude_increase(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Altitude_increase := JII.Convert_To_Bool(PData);
      Ios_Pilot.Altitude := Ios_Pilot.Altitude + 100.0;
      Ios_Pilot.Altitude_Increase := False;
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Altitude_increase()");
         raise;
   end Altitude_increase;

   procedure Altitude_Decrease(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Altitude_Decrease := JII.Convert_To_Bool(PData);
      Ios_Pilot.Altitude := Ios_Pilot.Altitude - 100.0;
      Ios_Pilot.Altitude_Decrease := False;
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Altitude_Decrease()");
         raise;
   end Altitude_Decrease;

   procedure Performance_Mode (PData : JII.Set_Value) is
   begin
      Ios_Pilot.Performance_Mode := JII.Convert_To_Integer(PData);
      case Ios_pilot.Performance_mode is
         when 1 =>
            -- IAS and Climb Rate hold -------------------------------------------------
            Ios_Pilot.Ias_Enabled :=True;
            Ios_Pilot.Climb_Rate_Enabled := True;
            Ios_Pilot.Torque_Enabled :=False;

         when 2 =>
            -- Climb Rate and Torque hold ----------------------------------------------
            Ios_Pilot.Ias_Enabled :=False;
            Ios_Pilot.Climb_Rate_Enabled := True;
            Ios_Pilot.Torque_Enabled :=True;

         when 3 =>
            -- Torque and IAS hold ----------------------------------------------------
            Ios_Pilot.Ias_Enabled :=True;
            Ios_Pilot.Climb_Rate_Enabled := False;
            Ios_Pilot.Torque_Enabled :=True;

         when others =>
            null;
      end case;
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Performance_Mode()");
         raise;
   end Performance_Mode;

   procedure IAS(PData : JII.Set_Value) is
   begin
      Ios_Pilot.IAS := JII.Convert_To_Float(PData);
      if Ios_Pilot.IAS > 270.0 then
         Ios_Pilot.IAS := 270.0;
      elsif Ios_Pilot.IAS < 80.0 then
         Ios_Pilot.IAS := 80.0;
      end if;
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.IAS()");
         raise;
   end IAS;

   procedure IAS_Enabled(PData : JII.Set_Value) is
   begin
      Ios_Pilot.IAS_Enabled := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.IAS_Enabled()");
         raise;
   end IAS_Enabled;

   procedure IAS_Increase(PData : JII.Set_Value) is
   begin
      Ios_Pilot.IAS_Increase := JII.Convert_To_Bool(PData);
      Ios_Pilot.IAS := Ios_Pilot.IAS + 5.0;
      Ios_Pilot.IAS_Increase := False;
      if Ios_Pilot.IAS > 270.0 then
         Ios_Pilot.IAS := 270.0;
      elsif Ios_Pilot.IAS < 80.0 then
         Ios_Pilot.IAS := 80.0;
      end if;
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.IAS_Increase()");
         raise;
   end IAS_Increase;

   procedure IAS_Decrease(PData : JII.Set_Value) is
   begin
      Ios_Pilot.IAS_Decrease := JII.Convert_To_Bool(PData);
      Ios_Pilot.IAS := Ios_Pilot.IAS - 5.0;
      Ios_Pilot.IAS_Decrease := False;
      if Ios_Pilot.IAS > 270.0 then
         Ios_Pilot.IAS := 270.0;
      elsif Ios_Pilot.IAS < 80.0 then
         Ios_Pilot.IAS := 80.0;
      end if;
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.IAS_Decrease()");
         raise;
   end IAS_Decrease;

   procedure Climb_Rate(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Climb_Rate := JII.Convert_To_Float(PData);
      if Ios_Pilot.Climb_rate > 4000.0 then
         Ios_Pilot.Climb_rate := 4000.0;
      elsif Ios_Pilot.Climb_rate < -4000.0 then
         Ios_Pilot.Climb_rate := -4000.0;
      end if;
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Climb_Rate()");
         raise;
   end Climb_Rate;

   procedure Climb_Rate_Enabled(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Climb_Rate_Enabled := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Climb_Rate_Enabled()");
         raise;
   end Climb_Rate_Enabled;

   procedure Climb(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Climb := JII.Convert_To_Bool(PData);
      Ios_Pilot.Climb_rate := Ios_Pilot.Climb_rate + 100.0;
      Ios_Pilot.Climb := False;
      if Ios_Pilot.Climb_rate > 4000.0 then
         Ios_Pilot.Climb_rate := 4000.0;
      elsif Ios_Pilot.Climb_rate < -4000.0 then
         Ios_Pilot.Climb_rate := -4000.0;
      end if;
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Climb()");
         raise;
   end Climb;

   procedure Descend(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Descend := JII.Convert_To_Bool(PData);
      Ios_Pilot.Climb_rate := Ios_Pilot.Climb_rate - 100.0;
      Ios_Pilot.Descend := False;
      if Ios_Pilot.Climb_rate > 4000.0 then
         Ios_Pilot.Climb_rate := 4000.0;
      elsif Ios_Pilot.Climb_rate < -4000.0 then
         Ios_Pilot.Climb_rate := -4000.0;
      end if;
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Descend()");
         raise;
   end Descend;

   procedure Torque(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Torque := JII.Convert_To_Float(PData);
      if Ios_Pilot.Torque > 100.0 then
         Ios_Pilot.Torque := 100.0;
      elsif Ios_Pilot.Torque < 0.0 then
         Ios_Pilot.Torque := 0.0;
      end if;
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Torque()");
         raise;
   end Torque;

   procedure Torque_Enabled(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Torque_Enabled := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Torque_Enabled()");
         raise;
   end Torque_Enabled;

   procedure Torque_Increase(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Torque_Increase := JII.Convert_To_Bool(PData);
      Ios_Pilot.Torque := Ios_Pilot.Torque + 5.0;
      Ios_Pilot.Torque_Increase := False;
      if Ios_Pilot.Torque > 100.0 then
         Ios_Pilot.Torque := 100.0;
      elsif Ios_Pilot.Torque < 0.0 then
         Ios_Pilot.Torque := 0.0;
      end if;
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Torque_Increase()");
         raise;
   end Torque_Increase;

   procedure Torque_Decrease(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Torque_Decrease := JII.Convert_To_Bool(PData);
      Ios_Pilot.Torque := Ios_Pilot.Torque - 5.0;
      Ios_Pilot.Torque_Decrease := False;
      if Ios_Pilot.Torque > 100.0 then
         Ios_Pilot.Torque := 100.0;
      elsif Ios_Pilot.Torque < 0.0 then
         Ios_Pilot.Torque := 0.0;
      end if;
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Torque_Decrease()");
         raise;
   end Torque_Decrease;

   procedure Heading(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Heading := JII.Convert_To_Float(PData);
      while Ios_Pilot.Heading >= 360.0 loop
         Ios_Pilot.Heading := Ios_Pilot.Heading - 360.0;
      end loop;
      while Ios_Pilot.Heading < 0.0 loop
         Ios_Pilot.Heading := Ios_Pilot.Heading + 360.0;
      end loop;
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Heading()");
         raise;
   end Heading;

   procedure Heading_increase(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Heading_increase := JII.Convert_To_Bool(PData);
      Ios_Pilot.Heading := Ios_Pilot.Heading + 1.0;
      Ios_Pilot.Heading_Increase := False;
      while Ios_Pilot.Heading >= 360.0 loop
         Ios_Pilot.Heading := Ios_Pilot.Heading - 360.0;
      end loop;
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Heading_increase()");
         raise;
   end Heading_increase;

   procedure Heading_Decrease(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Heading_Decrease := JII.Convert_To_Bool(PData);
      Ios_Pilot.Heading := Ios_Pilot.Heading - 1.0;
      Ios_Pilot.Heading_Decrease := False;
      while Ios_Pilot.Heading < 0.0 loop
         Ios_Pilot.Heading := Ios_Pilot.Heading + 360.0;
      end loop;
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Heading_Decrease()");
         raise;
   end Heading_Decrease;

   procedure Turn_Left(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Turn_Left := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Turn_Left()");
         raise;
   end Turn_Left;

   procedure Turn_Right(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Turn_Right := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Turn_Right()");
         raise;
   end Turn_Right;

   procedure Synchronize_Heading(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Synchronize_Heading := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Synchronize_Heading()");
         raise;
   end Synchronize_Heading;

   procedure Turn_Rate(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Turn_Rate := JII.Convert_To_Integer(PData);
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Turn_Rate()");
         raise;
   end Turn_Rate;

   procedure Turn_Direction(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Turn_Direction := JII.Convert_To_Integer(PData);
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Turn_Direction()");
         raise;
   end Turn_Direction;

   procedure Apply(PData : JII.Set_Value) is
   begin

      Ios_Pilot.Apply := JII.Convert_To_Bool(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Apply()");
         raise;
   end Apply;

   procedure Apply_Enabled(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Apply_Enabled := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Apply_Enabled()");
         raise;
   end Apply_Enabled;

   procedure Turn_Right_Enabled(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Turn_Right_Enabled := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Turn_Right_Enabled()");
         raise;
   end Turn_Right_Enabled;

   procedure Turn_Left_Enabled(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Turn_Left_Enabled := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Turn_Left_Enabled()");
         raise;
   end Turn_Left_Enabled;

   procedure Error_Number(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Error_Number := JII.Convert_To_Integer(PData);
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Error_Number()");
         raise;
   end Error_Number ;

   -- ------------------------------------------------------------------------
   --| TUNING VARIABLES
   -- ------------------------------------------------------------------------
   procedure IOS_Pilot_Debug(PData : JII.Set_Value) is
   begin
      Ios_Pilot.IOS_Pilot_Debug := JII.Convert_To_Bool(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.IOS_Pilot_Debug()");
         raise;
   end IOS_Pilot_Debug;

   procedure ios_pilot_mode(PData : JII.Set_Value) is
   begin
      Ios_Pilot.ios_pilot_mode := JII.Convert_To_Integer(PData);
      if not Ios_Pilot.IOS_Pilot_Debug then
         Ios_Pilot.Ios_Pilot_Mode := 0;
      end if;
   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.ios_pilot_mode()");
         raise;
   end ios_pilot_mode;

   procedure Comm_Pitch(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Comm_Pitch := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Comm_Pitch()");
         raise;
   end Comm_Pitch;

   procedure KP_Pitch(PData : JII.Set_Value) is
   begin
      Ios_Pilot.KP_Pitch := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.KP_Pitch()");
         raise;
   end KP_Pitch;

   procedure KI_Pitch(PData : JII.Set_Value) is
   begin
      Ios_Pilot.KI_Pitch := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.KI_Pitch()");
         raise;
   end KI_Pitch;

   procedure KD_Pitch(PData : JII.Set_Value) is
   begin
      Ios_Pilot.KD_Pitch := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.KD_Pitch()");
         raise;
   end KD_Pitch;

   procedure Max_Pitch_Rate(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Max_Pitch_Rate := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Max_Pitch_Rate()");
         raise;
   end Max_Pitch_Rate;

   procedure Comm_Climb(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Comm_Climb := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Comm_Climb()");
         raise;
   end Comm_Climb;

   procedure KP_Climb(PData : JII.Set_Value) is
   begin
      Ios_Pilot.KP_Climb := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.KP_Climb()");
         raise;
   end KP_Climb;

   procedure KI_Climb(PData : JII.Set_Value) is
   begin
      Ios_Pilot.KI_Climb := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.KI_Climb()");
         raise;
   end KI_Climb;

   procedure Max_Delta_Climb(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Max_Delta_Climb := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Max_Delta_Climb()");
         raise;
   end Max_Delta_Climb;

   procedure Comm_IAS(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Comm_IAS := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Comm_IAS()");
         raise;
   end Comm_IAS;

   procedure KP_IAS(PData : JII.Set_Value) is
   begin
      Ios_Pilot.KP_IAS := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.KP_IAS()");
         raise;
   end KP_IAS;

   procedure KI_IAS(PData : JII.Set_Value) is
   begin
      Ios_Pilot.KI_IAS := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.KI_IAS()");
         raise;
   end KI_IAS;

   procedure Max_Delta_IAS(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Max_Delta_IAS := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Max_Delta_IAS()");
         raise;
   end Max_Delta_IAS;

   procedure KP_Altitude(PData : JII.Set_Value) is
   begin
      Ios_Pilot.KP_Altitude := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.KP_Altitude()");
         raise;
   end KP_Altitude;

   procedure KI_Altitude(PData : JII.Set_Value) is
   begin
      Ios_Pilot.KI_Altitude := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.KI_Altitude()");
         raise;
   end KI_Altitude;

   procedure KD_Altitude(PData : JII.Set_Value) is
   begin
      Ios_Pilot.KD_Altitude := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.KD_Altitude()");
         raise;
   end KD_Altitude;

   procedure Max_Altitude_Err(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Max_Altitude_Err := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Max_Altitude_Err()");
         raise;
   end Max_Altitude_Err;

   procedure Comm_Roll(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Comm_Roll := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Comm_Roll()");
         raise;
   end Comm_Roll;

   procedure KP_Roll(PData : JII.Set_Value) is
   begin
      Ios_Pilot.KP_Roll := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.KP_Roll()");
         raise;
   end KP_Roll;

   procedure KI_Roll(PData : JII.Set_Value) is
   begin
      Ios_Pilot.KI_Roll := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.()");
         raise;
   end KI_Roll;

   procedure KD_Roll(PData : JII.Set_Value) is
   begin
      Ios_Pilot.KD_Roll := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.KD_Roll()");
         raise;
   end KD_Roll;

   procedure Max_Roll_Rate(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Max_Roll_Rate := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Max_Roll_Rate()");
         raise;
   end Max_Roll_Rate;

   procedure Comm_Turn_Rate(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Comm_Turn_Rate := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Comm_Turn_Rate()");
         raise;
   end Comm_Turn_Rate;

   procedure KP_Turn_Rate(PData : JII.Set_Value) is
   begin
      Ios_Pilot.KP_Turn_Rate := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.KP_Turn_Rate()");
         raise;
   end KP_Turn_Rate;

   procedure KI_Turn_Rate(PData : JII.Set_Value) is
   begin
      Ios_Pilot.KI_Turn_Rate := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.KI_Turn_Rate()");
         raise;
   end KI_Turn_Rate;

   procedure KD_Turn_Rate(PData : JII.Set_Value) is
   begin
      Ios_Pilot.KD_Turn_Rate := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.KD_Turn_Rate()");
         raise;
   end KD_Turn_Rate;

   procedure Max_Delta_Turn(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Max_Delta_Turn := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Max_Delta_Turn()");
         raise;
   end Max_Delta_Turn ;

   procedure KP_Heading(PData : JII.Set_Value) is
   begin
      Ios_Pilot.KP_Heading := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.KP_Heading()");
         raise;
   end KP_Heading;

   procedure KI_Heading(PData : JII.Set_Value) is
   begin
      Ios_Pilot.KI_Heading := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.KI_Heading()");
         raise;
   end KI_Heading;

   procedure KD_Heading(PData : JII.Set_Value) is
   begin
      Ios_Pilot.KD_Heading := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.KD_Heading()");
         raise;
   end KD_Heading;

   procedure Max_Heading_Err(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Max_Heading_Err := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Max_Heading_Err()");
         raise;
   end Max_Heading_Err;

   procedure KP_Sideslip(PData : JII.Set_Value) is
   begin
      Ios_Pilot.KP_Sideslip := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.KP_Sideslip()");
         raise;
   end KP_Sideslip;

   procedure KP_Lat_Acc(PData : JII.Set_Value) is
   begin
      Ios_Pilot.KP_Lat_Acc := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.KP_Lat_Acc()");
         raise;
   end KP_Lat_Acc;

   procedure KP_Slipball(PData : JII.Set_Value) is
   begin
      Ios_Pilot.KP_Slipball := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.KP_Slipball()");
         raise;
   end KP_Slipball;

   procedure KI_Slipball(PData : JII.Set_Value) is
   begin
      Ios_Pilot.KI_Slipball := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.KI_Slipball()");
         raise;
   end KI_Slipball;

   procedure Yaw_Gain(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Yaw_Gain := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Yaw_Gain()");
         raise;
   end Yaw_Gain;

   procedure KP_Torque(PData : JII.Set_Value) is
   begin
      Ios_Pilot.KP_Torque := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.KP_Torque()");
         raise;
   end KP_Torque;

   procedure KI_Torque(PData : JII.Set_Value) is
   begin
      Ios_Pilot.KI_Torque := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.KI_Torque()");
         raise;
   end KI_Torque;

   procedure KD_Torque(PData : JII.Set_Value) is
   begin
      Ios_Pilot.KD_Torque := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.KD_Torque()");
         raise;
   end KD_Torque;

   procedure Max_Torque_Rate(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Max_Torque_Rate := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Max_Torque_Rate()");
         raise;
   end Max_Torque_Rate;

   procedure KP_IAS_Torque(PData : JII.Set_Value) is
   begin
      Ios_Pilot.KP_IAS_Torque  := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.KP_IAS_Torque()");
         raise;
   end KP_IAS_Torque;

   procedure KI_IAS_Torque(PData : JII.Set_Value) is
   begin
      Ios_Pilot.KI_IAS_Torque := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.KI_IAS_Torque()");
         raise;
   end KI_IAS_Torque;

   procedure KD_IAS_Torque(PData : JII.Set_Value) is
   begin
      Ios_Pilot.KD_IAS_Torque := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.KD_IAS_Torque()");
         raise;
   end KD_IAS_Torque;

   procedure Max_Delta_IAS_Torque(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Max_Delta_IAS_Torque := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Max_Delta_IAS_Torque()");
         raise;
   end Max_Delta_IAS_Torque;

   procedure Rotation_Speed(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Rotation_Speed := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Rotation_Speed()");
         raise;
   end Rotation_Speed;

   procedure Rotation_Climb(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Rotation_Climb := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Rotation_Climb()");
         raise;
   end Rotation_Climb;

   procedure Altitude_Off(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Altitude_Off := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Altitude_Off()");
         raise;
   end Altitude_Off;

   procedure KP_Yaw_Heading(PData : JII.Set_Value) is
   begin
      Ios_Pilot.KP_Yaw_Heading := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.KP_Yaw_Heading()");
         raise;
   end KP_Yaw_Heading;

   procedure Misc_Var1(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Misc_Var1 := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Misc_Var1()");
         raise;
   end Misc_Var1;

   procedure Misc_Var2(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Misc_Var2 := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Misc_Var2()");
         raise;
   end Misc_Var2;

   procedure Misc_Var3(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Misc_Var3 := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Misc_Var3()");
         raise;
   end Misc_Var3;

   procedure Misc_Var4(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Misc_Var4 := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Misc_Var4()");
         raise;
   end Misc_Var4;

   procedure Misc_Var5(PData : JII.Set_Value) is
   begin
      Ios_Pilot.Misc_Var5 := JII.Convert_To_Float(PData);

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Misc_Var5()");
         raise;
   end Misc_Var5;

   procedure Register_Ios_Variables
   is
   begin

      JII.Register
        (Name        => "ios_pilot_enable",
         Variable    => Ios_Pilot.Enable'Address,
         Set_Routine => Enable'Access
         );

      JII.Register
        (Name        => "ios_pilot_takeoff",
         Variable    => Ios_Pilot.takeoff'Address,
         Set_Routine => takeoff'Access
         );

      JII.Register
        (Name        => "ios_pilot_altitude_engage",
         Variable    => Ios_Pilot.Altitude_Engaged'Address,
         Set_Routine => Altitude_Engaged'Access
         );

      JII.Register
        (Name        => "ios_pilot_altitude",
         Variable    => Ios_Pilot.altitude'Address,
         Set_Routine => altitude'Access
         );

      JII.Register
        (Name        => "ios_pilot_altitude_increase",
         Variable    => Ios_Pilot.altitude_increase'Address,
         Set_Routine => altitude_increase'Access
         );

      JII.Register
        (Name        => "ios_pilot_altitude_decrease",
         Variable    => Ios_Pilot.altitude_decrease'Address,
         Set_Routine => altitude_decrease'Access
         );

      JII.Register
        (Name        => "ios_pilot_performance_mode",
         Variable    => Ios_Pilot.Performance_Mode'Address,
         Set_Routine => Performance_Mode'Access
         );

      JII.Register
        (Name        => "ios_pilot_ias",
         Variable    => Ios_Pilot.ias'Address,
         Set_Routine => ias'Access
         );

     JII.Register
        (Name        => "ios_pilot_ias_enabled",
         Variable    => Ios_Pilot.Ias_enabled'Address,
         Set_Routine => Ias_enabled'Access
         );

     JII.Register
        (Name        => "ios_pilot_ias_increase",
         Variable    => Ios_Pilot.Ias_increase'Address,
         Set_Routine => Ias_increase'Access
         );

     JII.Register
        (Name        => "ios_pilot_ias_decrease",
         Variable    => Ios_Pilot.Ias_decrease'Address,
         Set_Routine => Ias_decrease'Access
         );

      JII.Register
        (Name        => "ios_pilot_climb_rate",
         Variable    => Ios_Pilot.Climb_Rate'Address,
         Set_Routine => Climb_Rate'Access
         );

      JII.Register
        (Name        => "ios_pilot_climb_rate_enabled",
         Variable    => Ios_Pilot.Climb_Rate_Enabled'Address,
         Set_Routine => Climb_Rate_Enabled'Access
         );

      JII.Register
        (Name        => "ios_pilot_climb",
         Variable    => Ios_Pilot.Climb'Address,
         Set_Routine => Climb'Access
         );

      JII.Register
        (Name        => "ios_pilot_descend",
         Variable    => Ios_Pilot.Descend'Address,
         Set_Routine => Descend'Access
         );

      JII.Register
        (Name        => "ios_pilot_torque",
         Variable    => Ios_Pilot.Torque'Address,
         Set_Routine => Torque'Access
         );

      JII.Register
        (Name        => "ios_pilot_torque_enabled",
         Variable    => Ios_Pilot.Torque_Enabled'Address,
         Set_Routine => Torque_Enabled'Access
         );

      JII.Register
        (Name        => "ios_pilot_torque_increase",
         Variable    => Ios_Pilot.Torque_increase'Address,
         Set_Routine => Torque_increase'Access
         );

      JII.Register
        (Name        => "ios_pilot_torque_decrease",
         Variable    => Ios_Pilot.Torque_decrease'Address,
         Set_Routine => Torque_decrease'Access
         );

      JII.Register
        (Name        => "ios_pilot_heading",
         Variable    => Ios_Pilot.Heading'Address,
         Set_Routine => Heading'Access
         );

      JII.Register
        (Name        => "ios_pilot_heading_increase",
         Variable    => Ios_Pilot.Heading_increase'Address,
         Set_Routine => Heading_increase'Access
         );

      JII.Register
        (Name        => "ios_pilot_heading_decrease",
         Variable    => Ios_Pilot.Heading_decrease'Address,
         Set_Routine => Heading_decrease'Access
         );

      JII.Register
        (Name        => "ios_pilot_turn_left",
         Variable    => Ios_Pilot.Turn_Left'Address,
         Set_Routine => Turn_Left'Access
         );

      JII.Register
        (Name        => "ios_pilot_turn_right",
         Variable    => Ios_Pilot.Turn_Right'Address,
         Set_Routine => Turn_Right'Access
         );

      JII.Register
        (Name        => "ios_pilot_synchronize_heading",
         Variable    => Ios_Pilot.Synchronize_Heading'Address,
         Set_Routine => Synchronize_Heading'Access
         );

      JII.Register
        (Name        => "ios_pilot_turn_direction",
         Variable    => Ios_Pilot.Turn_Direction'Address,
         Set_Routine => Turn_Direction'Access
         );

      JII.Register
        (Name        => "ios_pilot_turn_rate",
         Variable    => Ios_Pilot.Turn_Rate'Address,
         Set_Routine => Turn_Rate'Access
         );

      JII.Register
        (Name        => "ios_pilot_apply",
         Variable    => Ios_Pilot.Apply'Address,
         Set_Routine => Apply'Access
         );

      JII.Register
        (Name        => "ios_pilot_error",
         Variable    => Ios_Pilot.Error_Number'Address,
         Set_Routine => Error_Number'Access
         );

      -- ------------------------------------------------------------------------
      --| TUNING VARIABLES
      -- ------------------------------------------------------------------------
      JII.Register
        (Name        => "ios_pilot_apply_enabled",
         Variable    => Ios_Pilot.apply_enabled'Address,
         Set_Routine => Apply_Enabled'Access
         );

      JII.Register
        (Name        => "ios_pilot_turn_right_enabled",
         Variable    => Ios_Pilot.turn_right_enabled'Address,
         Set_Routine => Turn_Right_Enabled'Access
         );

      JII.Register
        (Name        => "ios_pilot_turn_left_enabled",
         Variable    => Ios_Pilot.turn_left_enabled'Address,
         Set_Routine => Turn_Left_Enabled'Access
         );

      JII.Register
        (Name        => "ios_pilot_debug",
         Variable    => Ios_Pilot.Ios_Pilot_Debug'Address,
         Set_Routine => Ios_Pilot_Debug'Access
         );

      JII.Register
        (Name        => "ios_pilot_mode",
         Variable    => Ios_Pilot.ios_pilot_mode'Address,
         Set_Routine => ios_pilot_mode'Access
         );

      JII.Register
        (Name        => "Comm_Pitch",
         Variable    => Ios_Pilot.Comm_Pitch'Address,
         Set_Routine => Comm_Pitch'Access
         );

      JII.Register
        (Name        => "KP_Pitch",
         Variable    => Ios_Pilot.KP_Pitch'Address,
         Set_Routine => KP_Pitch'Access
         );

      JII.Register
        (Name        => "KI_Pitch",
         Variable    => Ios_Pilot.KI_Pitch'Address,
         Set_Routine => KI_Pitch'Access
         );

      JII.Register
        (Name        => "KD_Pitch",
         Variable    => Ios_Pilot.KD_Pitch'Address,
         Set_Routine => KD_Pitch'Access
         );

      JII.Register
        (Name        => "Max_Pitch_Rate",
         Variable    => Ios_Pilot.Max_Pitch_Rate'Address,
         Set_Routine => Max_Pitch_Rate'Access
         );

      JII.Register
        (Name        => "Comm_Climb",
         Variable    => Ios_Pilot.Comm_Climb'Address,
         Set_Routine => Comm_Climb'Access
         );

      JII.Register
        (Name        => "KP_Climb",
         Variable    => Ios_Pilot.KP_Climb'Address,
         Set_Routine => KP_Climb'Access
         );

      JII.Register
        (Name        => "KI_Climb",
         Variable    => Ios_Pilot.KI_Climb'Address,
         Set_Routine => KI_Climb'Access
         );

      JII.Register
        (Name        => "Max_Delta_Climb",
         Variable    => Ios_Pilot.Max_Delta_Climb'Address,
         Set_Routine => Max_Delta_Climb'Access
         );

      JII.Register
        (Name        => "Comm_IAS",
         Variable    => Ios_Pilot.Comm_IAS'Address,
         Set_Routine => Comm_IAS'Access
         );

      JII.Register
        (Name        => "KP_IAS",
         Variable    => Ios_Pilot.KP_IAS'Address,
         Set_Routine => KP_IAS'Access
         );

      JII.Register
        (Name        => "KI_IAS",
         Variable    => Ios_Pilot.KI_IAS'Address,
         Set_Routine => KI_IAS'Access
         );

      JII.Register
        (Name        => "Max_Delta_IAS",
         Variable    => Ios_Pilot.Max_Delta_IAS'Address,
         Set_Routine => Max_Delta_IAS'Access
         );

      JII.Register
        (Name        => "KP_Altitude",
         Variable    => Ios_Pilot.KP_Altitude'Address,
         Set_Routine => KP_Altitude'Access
         );

      JII.Register
        (Name        => "KI_Altitude",
         Variable    => Ios_Pilot.KI_Altitude'Address,
         Set_Routine => KI_Altitude'Access
         );

      JII.Register
        (Name        => "KD_Altitude",
         Variable    => Ios_Pilot.KD_Altitude'Address,
         Set_Routine => KD_Altitude'Access
         );

      JII.Register
        (Name        => "Max_Altitude_Err",
         Variable    => Ios_Pilot.Max_Altitude_Err'Address,
         Set_Routine => Max_Altitude_Err'Access
         );

      JII.Register
        (Name        => "Comm_Roll",
         Variable    => Ios_Pilot.Comm_Roll'Address,
         Set_Routine => Comm_Roll'Access
         );

      JII.Register
        (Name        => "KP_Roll",
         Variable    => Ios_Pilot.KP_Roll'Address,
         Set_Routine => KP_Roll'Access
         );

      JII.Register
        (Name        => "KI_Roll",
         Variable    => Ios_Pilot.KI_Roll'Address,
         Set_Routine => KI_Roll'Access
         );

      JII.Register
        (Name        => "KD_Roll",
         Variable    => Ios_Pilot.KD_Roll'Address,
         Set_Routine => KD_Roll'Access
         );

      JII.Register
        (Name        => "Max_Roll_Rate",
         Variable    => Ios_Pilot.Max_Roll_Rate'Address,
         Set_Routine => Max_Roll_Rate'Access
         );

      JII.Register
        (Name        => "Comm_Turn_Rate",
         Variable    => Ios_Pilot.Comm_Turn_Rate'Address,
         Set_Routine => Comm_Turn_Rate'Access
         );

      JII.Register
        (Name        => "KP_Turn_Rate",
         Variable    => Ios_Pilot.KP_Turn_Rate'Address,
         Set_Routine => KP_Turn_Rate'Access
         );

      JII.Register
        (Name        => "KI_Turn_Rate",
         Variable    => Ios_Pilot.KI_Turn_Rate'Address,
         Set_Routine => KI_Turn_Rate'Access
         );

      JII.Register
        (Name        => "KD_Turn_Rate",
         Variable    => Ios_Pilot.KD_Turn_Rate'Address,
         Set_Routine => KD_Turn_Rate'Access
         );

      JII.Register
        (Name        => "Max_Delta_Turn",
         Variable    => Ios_Pilot.Max_Delta_Turn'Address,
         Set_Routine => Max_Delta_Turn'Access
         );

      JII.Register
        (Name        => "KP_Heading",
         Variable    => Ios_Pilot.KP_Heading'Address,
         Set_Routine => KP_Heading'Access
         );

      JII.Register
        (Name        => "KI_Heading",
         Variable    => Ios_Pilot.KI_Heading'Address,
         Set_Routine => KI_Heading'Access
         );

      JII.Register
        (Name        => "KD_Heading",
         Variable    => Ios_Pilot.KD_Heading'Address,
         Set_Routine => KD_Heading'Access
         );

      JII.Register
        (Name        => "Max_Heading_Err",
         Variable    => Ios_Pilot.Max_Heading_Err'Address,
         Set_Routine => Max_Heading_Err'Access
         );

      JII.Register
        (Name        => "KP_Sideslip",
         Variable    => Ios_Pilot.KP_Sideslip'Address,
         Set_Routine => KP_Sideslip'Access
         );

      JII.Register
        (Name        => "KP_Lat_Acc",
         Variable    => Ios_Pilot.KP_Lat_Acc'Address,
         Set_Routine => KP_Lat_Acc'Access
         );

      JII.Register
        (Name        => "KP_Slipball",
         Variable    => Ios_Pilot.KP_Slipball'Address,
         Set_Routine => KP_Slipball'Access
         );

      JII.Register
        (Name        => "KI_Slipball",
         Variable    => Ios_Pilot.KI_Slipball'Address,
         Set_Routine => KI_Slipball'Access
         );

      JII.Register
        (Name        => "Yaw_Gain",
         Variable    => Ios_Pilot.Yaw_Gain'Address,
         Set_Routine => Yaw_Gain'Access
         );

      JII.Register
        (Name        => "KP_Torque",
         Variable    => Ios_Pilot.KP_Torque'Address,
         Set_Routine => KP_Torque'Access
         );

      JII.Register
        (Name        => "KI_Torque",
         Variable    => Ios_Pilot.KI_Torque'Address,
         Set_Routine => KI_Torque'Access
         );

      JII.Register
        (Name        => "KD_Torque",
         Variable    => Ios_Pilot.KD_Torque'Address,
         Set_Routine => KD_Torque'Access
         );

      JII.Register
        (Name        => "Max_Torque_Rate",
         Variable    => Ios_Pilot.Max_Torque_Rate'Address,
         Set_Routine => Max_Torque_Rate'Access
         );

      JII.Register
        (Name        => "KP_IAS_Torque",
         Variable    => Ios_Pilot.KP_IAS_Torque'Address,
         Set_Routine => KP_IAS_Torque'Access
         );

      JII.Register
        (Name        => "KI_IAS_Torque",
         Variable    => Ios_Pilot.KI_IAS_Torque'Address,
         Set_Routine => KI_IAS_Torque'Access
         );

      JII.Register
        (Name        => "KD_IAS_Torque",
         Variable    => Ios_Pilot.KD_IAS_Torque'Address,
         Set_Routine => KD_IAS_Torque'Access
         );

      JII.Register
        (Name        => "Max_Delta_IAS_Torque",
         Variable    => Ios_Pilot.Max_Delta_IAS_Torque'Address,
         Set_Routine => Max_Delta_IAS_Torque'Access
         );

      JII.Register
        (Name        => "Rotation_Speed",
         Variable    => Ios_Pilot.Rotation_Speed'Address,
         Set_Routine => Rotation_Speed'Access
         );

      JII.Register
        (Name        => "Rotation_Climb",
         Variable    => Ios_Pilot.Rotation_Climb'Address,
         Set_Routine => Rotation_Climb'Access
         );

      JII.Register
        (Name        => "Altitude_Off",
         Variable    => Ios_Pilot.Altitude_Off'Address,
         Set_Routine => Altitude_Off'Access
         );

      JII.Register
        (Name        => "KP_Yaw_Heading",
         Variable    => Ios_Pilot.KP_Yaw_Heading'Address,
         Set_Routine => KP_Yaw_Heading'Access
         );

      JII.Register
        (Name        => "Misc_Var1",
         Variable    => Ios_Pilot.Misc_Var1'Address,
         Set_Routine => Misc_Var1'Access
         );

      JII.Register
        (Name        => "Misc_Var2",
         Variable    => Ios_Pilot.Misc_Var2'Address,
         Set_Routine => Misc_Var2'Access
         );

      JII.Register
        (Name        => "Misc_Var3",
         Variable    => Ios_Pilot.Misc_Var3'Address,
         Set_Routine => Misc_Var3'Access
         );

      JII.Register
        (Name        => "Misc_Var4",
         Variable    => Ios_Pilot.Misc_Var4'Address,
         Set_Routine => Misc_Var4'Access
         );

      JII.Register
        (Name        => "Misc_Var5",
         Variable    => Ios_Pilot.Misc_Var5'Address,
         Set_Routine => Misc_Var5'Access
         );

   exception
      when others =>
         Log.Report("Jpats_IOS_Pilot.Ios_Interface.Register_Ios_Variables()");
         raise;
   end Register_Ios_Variables;

end Jpats_IOS_Pilot.Ios_Interface;
