-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Asep Rahmat
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Pitch_Driver;
with Roll_Driver;
with Yaw_Driver;
with Torque_Driver;
with Jpats_Ios_Pilot_Types;
use  Jpats_Ios_Pilot_Types;

private package Jpats_IOS_Pilot.Container is

   package IOS_Pilot_Pitch_Driver is new
     Pitch_Driver(Tho_Filtered_Selected_Pitch     => Float (1.5 ),
                  Tho_Filtered_IAS_Err            => Float (1.0 ),
                  Tho_Filtered_Selected_Climb     => Float (1.2 ),
                  Tho_Filtered_Selected_Altitude  => Float (1.5 ),
                  Max_Delta_elev                  => Float (0.5 ),
                  AOA_Stall                       => Float (15.0),
                  Fader_Time                      => Float (10.0));

   package IOS_Pilot_Roll_Driver is new
     Roll_Driver(Tho_Filtered_Selected_Roll    => Float (1.2 ),
                 Tho_Filtered_Selected_turn    => Float (1.0 ),
                 Tho_Filtered_Heading_error    => Float (1.0 ),
                 Max_Roll_Angle                => Float (90.0),
                 Max_Ail_Rate                  => Float (0.5),
                 Gain_Aileron_Effectiveness_x1 => Float (120.0),
                 Gain_Aileron_Effectiveness_x2 => Float (130.0),
                 Gain_Wing_level_x1            => Float (5.0 ),
                 Gain_Wing_level_x2            => Float (10.0),
                 Fader_Time                    => Float (1.0));

   package Ios_Pilot_Yaw_Driver is new
     Yaw_Driver(Tho_Filtered_Yaw_Rate        => Float (1.5  ),
                Tho_Filtered_Lat_Acc         => Float (1.0  ),
                Max_Heading_Err              => Float (2.5  ),
                Max_Lat_Acc                  => Float (0.3  ),
                Gain_Yaw_Damper_x1           => Float (7.0  ),
                Gain_Yaw_Damper_x2           => Float (12.0 ),
                Gain_Heading_Error_X1        => Float (7.0  ),
                Gain_Heading_Error_X2        => Float (12.0 ),
                Max_Rud_Rate                 => Float (1.0  ),
                Fader_Time                   => Float (3.0  ));

   package Ios_Pilot_Torque_Driver is new
     Torque_Driver(Tho_Filtered_Pitch          => float (0.2 ),
                   Tho_Filtered_IAS            => float (1.0 ),
                   Tho_washout_Pitch           => float (8.0 ),
                   Max_Delta_PLA               => float (10.0),
                   Fader_Time                  => Float (3.0 ));

   type Instance is
      record
         The_IOS_Pilot_Roll_Driver              : Ios_Pilot_Roll_Driver.Instance;
         The_IOS_Pilot_Pitch_Driver             : IOS_Pilot_Pitch_Driver.Instance;
         The_Ios_Pilot_Torque_Driver            : Ios_Pilot_Torque_Driver.Instance;
         The_IOS_Pilot_Yaw_Driver               : Ios_Pilot_Yaw_Driver.Instance;
         Mode                                   : Integer:=0;
         Previous_Mode                          : Integer:=0;
         TO_Phase                               : Integer := -1;
         Reposition_Active                      : Boolean := False;
         Error_Counter                          : Integer := 0;
         Start_Lat                              : Long_Float := 0.0;
         Start_Long                             : Long_Float := 0.0;
      end record;
   This_Subsystem : Instance;

   type Ios_Interface_Instance is
      record

         Enable                   : Boolean := False;
         Takeoff                  : Boolean := False;
         TO_Is_started            : Boolean := False;
         TO_Is_Ready              : Boolean := False;
         TO_Is_Done               : Boolean := False;
         Altitude_Engaged         : Boolean := False;
         Altitude                 : Float   := 5000.0;
         Altitude_increase        : Boolean := False;
         Altitude_decrease        : Boolean := False;
         Performance_Mode         : Integer := 3;
         IAS                      : Float   := 160.0;
         IAS_Enabled              : Boolean := True;
         IAS_increase             : Boolean := False;
         IAS_decrease             : Boolean := False;
         Climb_Rate               : Float   := 1500.0;
         Climb_Rate_Enabled       : Boolean := False;
         Climb                    : Boolean := False;
         Descend                  : Boolean := False;
         Torque                   : Float   := 35.0;
         Torque_Enabled           : Boolean := True;
         Torque_increase          : Boolean := False;
         Torque_decrease          : Boolean := False;
         Heading                  : Float   := 154.0;
         Heading_increase         : Boolean := False;
         Heading_decrease         : Boolean := False;
         Turn_Direction           : Integer := 1;
         Turn_Rate                : Integer := 2;
         Turn_Left                : Boolean := False;
         Turn_Right               : Boolean := False;
         Synchronize_Heading      : Boolean := True;

         Request_Gear_Up          : Boolean := False;
         Request_Gear_Down        : Boolean := False;

         Apply                    : Boolean := False;
         Apply_Enabled            : Boolean := False;
         Turn_Right_Enabled       : Boolean := False;
         Turn_Left_Enabled        : Boolean := False;
         Error_Number             : Integer := 0;

         -- TUNING VARIABLES -------------------------
         Ios_Pilot_Debug          : Boolean := False;
         ios_pilot_mode           : Integer := 0;
         Comm_Pitch               : Float   := 1.0;
         KP_Pitch                 : Float   := 1.0;
         KI_Pitch                 : Float   := 1.0;
         KD_Pitch                 : Float   := 1.0;
         Max_Pitch_Rate           : Float   := 1.0;
         Comm_Climb               : Float   := 1.0;
         KP_Climb                 : Float   := 1.0;
         KI_Climb                 : Float   := 1.0;
         Max_Delta_Climb          : Float   := 1.0;
         Comm_IAS                 : Float   := 1.0;
         KP_IAS                   : Float   := 1.0;
         KI_IAS                   : Float   := 1.0;
         Max_Delta_IAS            : Float   := 1.0;
         KP_Altitude              : Float   := 1.0;
         KI_Altitude              : Float   := 1.0;
         KD_Altitude              : Float   := 1.0;
         Max_Altitude_Err         : Float   := 1.0;
         Comm_Roll                : Float   := 1.0;
         KP_Roll                  : Float   := 1.0;
         KI_Roll                  : Float   := 1.0;
         KD_Roll                  : Float   := 1.0;
         Max_Roll_Rate            : Float   := 1.0;
         Comm_Turn_Rate           : Float   := 1.0;
         KP_Turn_Rate             : Float   := 1.0;
         KI_Turn_Rate             : Float   := 1.0;
         KD_Turn_Rate             : Float   := 1.0;
         Max_Delta_Turn           : Float   := 1.0;
         KP_Heading               : Float   := 1.0;
         KI_Heading               : Float   := 1.0;
         KD_Heading               : Float   := 1.0;
         Max_Heading_Err          : Float   := 1.0;
         KP_Sideslip              : Float   := 1.0;
         KP_Lat_Acc               : Float   := 1.0;
         KP_Slipball              : Float   := 1.0;
         KI_Slipball              : Float   := 1.0;
         Yaw_Gain                 : Float   := 1.0;
         KP_Torque                : Float   := 1.0;
         KI_Torque                : Float   := 1.0;
         KD_Torque                : Float   := 1.0;
         Max_Torque_Rate          : Float   := 1.0;
         KP_IAS_Torque            : Float   := 1.0;
         KI_IAS_Torque            : Float   := 1.0;
         KD_IAS_Torque            : Float   := 1.0;
         Max_Delta_IAS_Torque     : Float   := 1.0;
         Rotation_Speed           : Float   := 1.0;
         Rotation_Climb           : Float   := 1.0;
         Altitude_Off             : Float   := 1.0;
         KP_Yaw_Heading           : Float   := 1.0;
         Misc_Var1                : Float   := 1.0;
         Misc_Var2                : Float   := 1.0;
         Misc_Var3                : Float   := 1.0;
         Misc_Var4                : Float   := 1.0;
         Misc_Var5                : Float   := 1.0;


      end record;
   This_Ios_Interface : Ios_Interface_Instance;


   Debug1  : Float := 0.0;
   Debug2  : Float := 0.0;
   Debug3  : Float := 0.0;
   Debug4  : Float := 0.0;
   Debug5  : Float := 0.0;
   Debug6  : Float := 0.0;
   Debug7  : Float := 0.0;
   Debug8  : Float := 0.0;
   Debug9  : Float := 0.0;
   Debug10 : Float := 0.0;

   Bool1   : Boolean := False;
   Bool2   : Boolean := False;
   Bool3   : Boolean := False;
   Bool4   : Boolean := False;
   Bool5   : Boolean := False;




end Jpats_IOS_Pilot.Container;
