-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Asep Rahmat
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Angle_Types;
with Force_Types;
with Length_Types;
with Mass_Types;


package First_Order_Filter  is

   type Lowpass is  record
      Last_Output           : Float ;
      Output                : Float;
   end record;


   type Washout is record
      Last_1_Input          : Float;
      Last_2_Input          : Float;
      Last_Output           : Float;
      Output                : Float;
   end record;

    -- First order lowpass filter using Euler integration method
    procedure Initialize
        (Uk0             :in      Float;
         A_Lowpass       :in out  Lowpass);

    procedure Update
        (Uk              :in     Float;
         Time_Constant   :in     Float;
         Dt              :in     Float;
         A_Lowpass       :in out Lowpass);


        procedure Update
        (Uk              :in     Float;
         Rate_Limit      :in     Float;
         Time_Constant   :in     Float;
         Dt              :in     Float;
         A_Lowpass       :in out Lowpass);

    function Output (A_Lowpass       :in Lowpass)
                        return Float;



    -- First order highpass filter using Bilinear transformation method
    procedure Initialize
        (Uk0             :in      Float;
         A_Washout       :in out  Washout);

    procedure Update
        (Uk              :in     Float;
         Time_Constant   :in     Float;
         Dt              :in     Float;
         A_Washout       :in out  Washout);

    function Output ( A_Washout       :in  Washout)
                        return Float;

end First_Order_Filter;





