@ECHO OFF

:: Folder C:\TEMP must exist for the "View All" buttons on the bottom collar of the IOS page
:: to operate.  Folder C:\TEMP exists as part of a Windows 2000 installation, but not as
:: part of a Windows 7 installation.  Create folder C:\TEMP if it does not exist.

if not exist c:\temp (mkdir c:\temp)


:: NFS is used to allow the HOST and IOS computers to access files from each other.  Windows 7 Ultimate
:: supports NFS.  NFS must first be enabled in Win 7 Ultimate via "Control Panel > Programs and Features >
:: Turn Windows Features On or Off".  Scroll to "Services for NFS".  Check both "Administrative Tools"
:: and "Client for NFS".  Then, in an elevated (i.e. administrative-level) command prompt (DOS window) 
:: execute the command:
::    nfsadmin client config protocol=udp fileaccess=777 <Enter>

net use r: /delete       >> c:\temp\login.txt

:MOUNT_RAMDISK
mount -o retry=5 fileaccess=777 anon \\sim-ios-rt\ramdisk r:        >> c:\temp\login.txt
if exist r: goto ARCHIVE_LOGFILE

:: The HOST computer might not be ready yet. We need to wait for it to finish booting
:: before we can map the IOS RAMDISK to it.
:: This segment of code injects a 20sec delay into the batch script before reattempting
:: the disk mount command. 
:: (and yes, the "REM | CHOICE" line is actively used even though it is preceeded by a "REM" statement)

ECHO.
ECHO Host RAMDISK not available ... retrying disk mount in 20 seconds
REM | CHOICE /C:AB /T:A,20 > NUL
IF ERRORLEVEL 255 ECHO Invalid parameter
goto MOUNT_RAMDISK


:: The simulation message log files exist in folder D:\HOST_DATA\. File LOG.TXT contains
:: messages from the current simulation session. Archive the LOG.TXT file by adding a numerical
:: suffix of 1 through 4 each time this batch file is executed.  (This batch file is called
:: from the user's STARTUP folder, so it is run during each LOGIN event on the IOS computer)

:ARCHIVE_LOGFILE
del d:\host_data\log4.txt
rename d:\host_data\log3.txt log4.txt
rename d:\host_data\log2.txt log3.txt
rename d:\host_data\log1.txt log2.txt
rename d:\host_data\log.txt log1.txt
if not exist d:\host_data\log.txt (type nul > d:\host_data\log.txt)


:: Delete any existing Formation Leadship and Demo files.

:: Commented out for USN B model
:: del "C:\ftd data\formation_lead\*.*" /q
:: del "C:\ftd data\demos\*.*" /q

