// WorkingDlg.cpp : implementation file
//

#include "stdafx.h"
#include "WorkingDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWorkingDlg dialog

CProgressCtrl	   CWorkingDlg::m_ctrl_progress;
BOOL              CWorkingDlg::m_BOOL_cancel_flag;
bool              CWorkingDlg::m_copy_in_progress;

CWorkingDlg::COPY_PARAMETERS  CWorkingDlg::m_copy_param;


CWorkingDlg::CWorkingDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CWorkingDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWorkingDlg)
	//}}AFX_DATA_INIT
   m_BOOL_cancel_flag   =  FALSE;
   m_copy_in_progress   =  false;
}


void CWorkingDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWorkingDlg)
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_PROGRESS, m_ctrl_progress);
}


BEGIN_MESSAGE_MAP(CWorkingDlg, CDialog)
	//{{AFX_MSG_MAP(CWorkingDlg)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWorkingDlg message handlers


BOOL CWorkingDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
   SetTimer(1, 100, 0);       // Make a timer go off every 0.1 seconds.

   m_ctrl_progress.SetRange(0, 100);


   m_copy_param.source              =  m_CStr_source;
   m_copy_param.destination         =  m_CStr_destination;
   m_copy_param.primary_extension   =  m_CStr_primary_extension;
   m_copy_param.secondary_extension =  m_CStr_secondary_extension;

   SetWindowText(m_CStr_start_caption);

   AfxBeginThread(ThreadWaitBeforeCopying, (LPVOID)&m_copy_param);
      
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


void CWorkingDlg::OnCancel() 
{
   m_BOOL_cancel_flag   =  TRUE;

   CDialog::OnCancel();
}


void CWorkingDlg::OnTimer(UINT nIDEvent) 
{
   if (!m_copy_in_progress)
   {
      KillTimer(1);
      SetWindowText(m_CStr_finish_caption);
      CWnd  *pWnd =  GetDlgItem(IDOK);
      if (pWnd)
      {
         GetDlgItem(IDOK)->EnableWindow(TRUE);
         GetDlgItem(IDOK)->SetFocus();
      }
      else
      {
         CDialog::OnOK();
      }
   }
	
   CDialog::OnTimer(nIDEvent);
}


UINT CWorkingDlg::ThreadWaitBeforeCopying(LPVOID param)
{
   COPY_PARAMETERS   *copy_param;
   copy_param     =  (COPY_PARAMETERS  *)param;

   // Copy the file...
   CopyFileAndReportErrors(copy_param->source, copy_param->destination, copy_param->primary_extension, copy_param->secondary_extension);

   return 0;
}


bool  CWorkingDlg::CopyFileAndReportErrors(CString &source, CString &destination, CString &primary_extension, CString &secondary_extension)
{
   static   CString  primary_copy_failed_caption;
   static   CString  secondary_copy_failed_caption;
   BOOL     retval;

   primary_copy_failed_caption.Format(    "Error copying from %s to %s",   source   +  "."   +  primary_extension,   destination +  "."   +  primary_extension);
   secondary_copy_failed_caption.Format(  "Error copying from %s to %s",   source   +  "."   +  secondary_extension, destination +  "."   +  secondary_extension);

   m_copy_in_progress   =  true;

   retval   =  CopyFileEx(LPCTSTR(source  +  "."   +  primary_extension),  LPCTSTR(destination  +  "."   +  primary_extension),
                          CopyProgressRoutine,  NULL, &m_BOOL_cancel_flag,  COPY_FILE_RESTARTABLE);

   if (retval  == 0)
   {
      LPVOID lpMsgBuf;
      FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER |  FORMAT_MESSAGE_FROM_SYSTEM |  FORMAT_MESSAGE_IGNORE_INSERTS,
                    NULL,  GetLastError(),   MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),   (LPTSTR)&lpMsgBuf,   0, NULL);
      // Display the string.
      ::MessageBox(NULL, (LPCTSTR)lpMsgBuf, (LPCTSTR)primary_copy_failed_caption, MB_OK | MB_ICONINFORMATION);
      // Free the buffer.
      LocalFree(lpMsgBuf);
   }
   else if (! secondary_extension.IsEmpty())
   {
      retval   =  CopyFileEx(LPCTSTR(source  +  "."   +  secondary_extension),   LPCTSTR(destination  +  "."   +  secondary_extension),
                             CopyProgressRoutine,  NULL, &m_BOOL_cancel_flag,  COPY_FILE_RESTARTABLE);

      if (retval  == 0)
      {
         LPVOID lpMsgBuf;
         FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER |  FORMAT_MESSAGE_FROM_SYSTEM |  FORMAT_MESSAGE_IGNORE_INSERTS,
                       NULL,  GetLastError(),   MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),   (LPTSTR)&lpMsgBuf,   0, NULL);
         // Display the string.
         ::MessageBox(NULL, (LPCTSTR)lpMsgBuf, (LPCTSTR)secondary_copy_failed_caption, MB_OK | MB_ICONINFORMATION );
         // Free the buffer.
         LocalFree(lpMsgBuf);
      }
   }

   m_copy_in_progress   =  false;

   return   (retval  != 0);
}


DWORD CALLBACK CWorkingDlg::CopyProgressRoutine(LARGE_INTEGER  TotalFileSize,    LARGE_INTEGER  TotalBytesTransferred,
                                                LARGE_INTEGER  StreamSize,       LARGE_INTEGER  StreamBytesTransferred,
                                                DWORD          dwStreamNumber,   DWORD          dwCallbackReason,
                                                HANDLE         hSourceFile,      HANDLE         hDestinationFile,
                                                LPVOID         lpData)
{
   if (m_BOOL_cancel_flag)
      return   PROGRESS_CANCEL;

   switch   (dwCallbackReason)
   {
      case  CALLBACK_STREAM_SWITCH:
      {
      }
      break;

      case  CALLBACK_CHUNK_FINISHED:
      {
         int   position =  (int)(100.0f   *  (float)TotalBytesTransferred.QuadPart  /  (float)TotalFileSize.QuadPart);
         m_ctrl_progress.SetPos(position);
         m_ctrl_progress.UpdateWindow();
      }
      break;
   }

   return   PROGRESS_CONTINUE;
}
