// WeatherGlobalsRecordSet.cpp : implementation file
//

#include "..\core\stdafx.h"
#include <afxdao.h>			// MFC DAO database classes
#include "WeatherGlobalsRecordSet.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWeatherGlobalsRecordSet

IMPLEMENT_DYNAMIC(CWeatherGlobalsRecordSet, CDaoRecordset)

CWeatherGlobalsRecordSet::CWeatherGlobalsRecordSet(CDaoDatabase* pdb)
	: CDaoRecordset(pdb)
{
	//{{AFX_FIELD_INIT(CWeatherGlobalsRecordSet)
	m_Lesson_ID = _T("");
	m_Base_ID = _T("");
	m_Surface_Wind_Altitude_AGL = _T("");
	m_Cruise_Wind_Altitude_MSL = _T("");
	m_Weather_Mode = _T("");
	m_Windshear_Model = _T("");
	m_Windshear_Intensity = _T("");
	m_Windshear_Enable = _T("");
	m_Microburst_Model = _T("");
	m_Microburst_Intensity = _T("");
	m_Microburst_Position = _T("");
	m_Microburst_Enable = _T("");
	m_Cruise_Wind_Direction = _T("");
	m_Cruise_Wind_Speed___knots = _T("");
	m_Turbulence_Enable = _T("");
	m_Turbulence_Intensity = _T("");
	m_Moon_Azimuth = _T("");
	m_Moon_Elevation = _T("");
	m_Moon_Phase = _T("");
	m_nFields = 19;
	//}}AFX_FIELD_INIT
	m_nDefaultType = dbOpenDynaset;
}


CString CWeatherGlobalsRecordSet::GetDefaultDBName()
{
	return m_dbName;
}

CString CWeatherGlobalsRecordSet::GetDefaultSQL()
{
	return _T("[Weather Globals]");
}

void CWeatherGlobalsRecordSet::DoFieldExchange(CDaoFieldExchange* pFX)
{
	//{{AFX_FIELD_MAP(CWeatherGlobalsRecordSet)
	pFX->SetFieldType(CDaoFieldExchange::outputColumn);
	DFX_Text(pFX, _T("[Lesson ID]"), m_Lesson_ID);
	DFX_Text(pFX, _T("[Base ID]"), m_Base_ID);
	DFX_Text(pFX, _T("[Surface Wind Altitude AGL]"), m_Surface_Wind_Altitude_AGL);
	DFX_Text(pFX, _T("[Cruise Wind Altitude MSL]"), m_Cruise_Wind_Altitude_MSL);
	DFX_Text(pFX, _T("[Weather Mode]"), m_Weather_Mode);
	DFX_Text(pFX, _T("[Windshear Model]"), m_Windshear_Model);
	DFX_Text(pFX, _T("[Windshear Intensity]"), m_Windshear_Intensity);
	DFX_Text(pFX, _T("[Windshear Enable]"), m_Windshear_Enable);
	DFX_Text(pFX, _T("[Microburst Model]"), m_Microburst_Model);
	DFX_Text(pFX, _T("[Microburst Intensity]"), m_Microburst_Intensity);
	DFX_Text(pFX, _T("[Microburst Position]"), m_Microburst_Position);
	DFX_Text(pFX, _T("[Microburst Enable]"), m_Microburst_Enable);
	DFX_Text(pFX, _T("[Cruise Wind Direction]"), m_Cruise_Wind_Direction);
	DFX_Text(pFX, _T("[Cruise Wind Speed - knots]"), m_Cruise_Wind_Speed___knots);
	DFX_Text(pFX, _T("[Turbulence Enable]"), m_Turbulence_Enable);
	DFX_Text(pFX, _T("[Turbulence Intensity]"), m_Turbulence_Intensity);
	DFX_Text(pFX, _T("[Moon Azimuth]"), m_Moon_Azimuth);
	DFX_Text(pFX, _T("[Moon Elevation]"), m_Moon_Elevation);
	DFX_Text(pFX, _T("[Moon Phase]"), m_Moon_Phase);
	//}}AFX_FIELD_MAP
}

/////////////////////////////////////////////////////////////////////////////
// CWeatherGlobalsRecordSet diagnostics

#ifdef _DEBUG
void CWeatherGlobalsRecordSet::AssertValid() const
{
	CDaoRecordset::AssertValid();
}

void CWeatherGlobalsRecordSet::Dump(CDumpContext& dc) const
{
	CDaoRecordset::Dump(dc);
}
#endif //_DEBUG
