// SortieFilesSystemInterface.h: interface for the CSortieFilesSystemInterface class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(_SORTIEFILESSYSTEMINTERFACE_H_)
#define _SORTIEFILESSYSTEMINTERFACE_H_

#include "..\core\widget.h"
#include <afxdao.h>			// MFC DAO database classes
#include "VariableMapRecordSet.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CSortieCommsAction;
class CSortieFilesSystemInterface  
{
protected:
    _FSI_STL::string                                        m_stlStrSortieFile;
    _FSI_STL::map<_FSI_STL::string, CSortieCommsAction*>    m_mapCommsActions;
    _FSI_STL::map<_FSI_STL::string, CXMLWidget>             m_mapCommsXMLWidgets;

public:
	CSortieFilesSystemInterface();
	virtual ~CSortieFilesSystemInterface();

    void Clean();
    void LoadData(const _FSI_STL::string& rstlStrDataFile);

    // Accessors
    _FSI_STL::string SortieFile();

    // Mutators
    void SortieFile(const _FSI_STL::string& rstlStrSortieFile);


   void  ChangeData(BOOL isLocal, _FSI_STL::string stlStrVariable, _FSI_STL::string stlStrValue);

   CString  m_condition_for_find;

   CVariableMapRecordSet   *m_pVariableMapSet;
   
   _FSI_STL::map<long, _FSI_STL::list<_FSI_STL::string> >   m_list_of_lessons;

private:
	void ResetMissionTime();

   inline void  SetReposition(void);

   inline void  SetAreaMap(void);
   inline void  SetSymDisp(void);

   inline void  SetWeatherGlobals(void);
   inline void  SetWeatherAreas(void);    

   inline void  SetThreats(void);
   inline void  SetMalfunctions(void);

   inline void  SetAircraftConfig(void);

   inline void  SetRecordedData(void);

   void         LoadItem(CString& member, char *row);
};

#endif // !defined(_SORTIEFILESSYSTEMINTERFACE_H_)
