/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : SortieFilesComponentInterface.cpp
//
// Date             : 19 October 1998
//
// Engineer         : Billy Baker
//
// Revision         : $Revision$
//
// Description      : CSortieFilesComponentInterface is derived from 
//                    CComponentInterface.  CComponentInterface is the 
//                    contract that all plugin components to the 
//                    framework must implement in the form of a derived 
//                    class.  See the information in 
//                    CComponentInterface for more information.  
//                    CSortieFilesComponentInterface is used for the Sortieunction
//                    Files library of controls and option pages.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : None.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log$
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "SortieFilesComponentInterface.h"
#include "SortieFilesSystemInterface.h"

#include "LoadSortieAction.h"
#include "PickBaseAction.h"
#include "PickLessonAction.h"

#include "..\fsisuite\product_version.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// The following static members contain the date and time of the last
// compilation of this class.
const char CSortieFilesComponentInterface::m_cRevisionDate[] = __DATE__;
const char CSortieFilesComponentInterface::m_cRevisionTime[] = __TIME__;

/////////////////////////////////////////////////////////////////////////////
//
// CSortieFilesComponentInterface::CSortieFilesComponentInterface()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 19 October 1998
//
// Engineer         : Billy Baker
//
// Description      : This is the default constuctor for this class.  It 
//                    initializes the map of option pages, initializes 
//                    the string with the date and time of compilation, 
//                    and initializes the name of the component.
//
/////////////////////////////////////////////////////////////////////////////
CSortieFilesComponentInterface::CSortieFilesComponentInterface(
                                                  _FSI_STL::string stlStrPathName) :
                    CComponentInterface(_FSI_STL::string("Sortie Files"),
                                        stlStrPathName)
{
    _FSI_STL::string stlStrDate(m_cRevisionDate);
    _FSI_STL::string stlStrTime(m_cRevisionTime);

    m_stlStrDate = stlStrDate + " " + stlStrTime;

    m_listActions.push_back(CLoadSortieAction::CreateObject);
    m_listActions.push_back(CPickBaseAction::CreateObject);
    m_listActions.push_back(CPickLessonAction::CreateObject);
}

/////////////////////////////////////////////////////////////////////////////
//
// CSortieFilesComponentInterface::~CSortieFilesComponentInterface()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 19 October 1998
//
// Engineer         : Billy Baker
//
// Description      : This is the default destructor for this class.  It 
//                    does not need to delete the option pages since 
//                    they are attached to a window when they are 
//                    created and will be delete when that window is 
//                    destroyed.  The pointers in the map, though, are 
//                    freed with a call to the map clear() method in the
//                    base class destructor.
//
/////////////////////////////////////////////////////////////////////////////
CSortieFilesComponentInterface::~CSortieFilesComponentInterface()
{
}

/////////////////////////////////////////////////////////////////////////////
//
// void CSortieFilesComponentInterface::CleanComponentResources()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 March 2000
//
// Engineer         : Billy Baker
//
// Description      : CleanComponentResources() is a common framework method
//                    used to cleanup any resources that were probably created
//                    in InitializeComponentConfig().
//
/////////////////////////////////////////////////////////////////////////////
void CSortieFilesComponentInterface::CleanComponentResources()
{
    CComponentInterface::CleanComponentResources();

    CSortieFilesSystemInterface* pSortieFilesSystem = CLoadSortieAction::SortieSystem();

    if (pSortieFilesSystem != NULL)
    {
        delete pSortieFilesSystem;
    }
}

void CSortieFilesComponentInterface::InitializeComponentConfig()
{
   CComponentInterface::InitializeComponentConfig();

   CSortieFilesSystemInterface* pSortieFilesSystem = CLoadSortieAction::SortieSystem();

   if (pSortieFilesSystem != NULL)
   {
      delete pSortieFilesSystem;
   }

   pSortieFilesSystem = new CSortieFilesSystemInterface;

   CLoadSortieAction::SortieSystem(pSortieFilesSystem);
   CPickBaseAction::SortieSystem(pSortieFilesSystem);
   CPickLessonAction::SortieSystem(pSortieFilesSystem);
}

void  CSortieFilesComponentInterface::AfterInitComplete(void)
{
   CString        eventProfilePath;
   unsigned long  preload_sortie =  0;

   HKEY  hKey;
   RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\Common"), 0, KEY_READ, &hKey);

   if (hKey != NULL)
   {
      unsigned long  ulData   =  0;
      DWORD dwSize      =  sizeof(unsigned long);
      RegQueryValueEx(hKey, _T("Preload Sortie"), NULL, NULL, (BYTE*)&ulData, &dwSize);
      preload_sortie    =  ulData;

      // This is a temporary fix for the case where they're logging-in as "runsim" and getting all
      // sorts of network errors because they're not logged-in to the domain, and can't see the SWS.
      // In this case, it takes a full 60 seconds or more for the app to come up
      if (preload_sortie)
      {
         // go see if a HKCU value overrides it
         HKEY  hkcuKey;
         RegOpenKeyEx(HKEY_CURRENT_USER, _T("Software\\FlightSafety"), 0, KEY_READ, &hkcuKey);

         if (hkcuKey != NULL)
         {
            unsigned long  ulData   =  0;
            DWORD dwSize      =  sizeof(unsigned long);
            RegQueryValueEx(hkcuKey, _T("Override Preload Sortie"), NULL, NULL, (BYTE*)&ulData, &dwSize);
            if (ulData)
               preload_sortie    =  FALSE;
            RegCloseKey(hkcuKey);
         }
      }
      // end temporary fix

      // get SWS name
      CString  strValue;
      DWORD    dwType, dwCount;
      LONG     lResult  =  RegQueryValueEx(hKey,   _T("SWS Name"),  NULL, &dwType, NULL, &dwCount);
      if (lResult == ERROR_SUCCESS)
      {
         ASSERT(dwType  == REG_SZ);
         lResult  =  RegQueryValueEx(hKey,   _T("SWS Name"),  NULL, &dwType, (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)), &dwCount);
         strValue.ReleaseBuffer();
      }
      eventProfilePath  =  strValue;

      // get event path file
      lResult  =  RegQueryValueEx(hKey,   _T("Profile Path"),  NULL, &dwType, NULL, &dwCount);
      if (lResult == ERROR_SUCCESS)
      {
         ASSERT(dwType  == REG_SZ);
         lResult  =  RegQueryValueEx(hKey,   _T("Profile Path"),  NULL, &dwType, (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)), &dwCount);
         strValue.ReleaseBuffer();
      }
      eventProfilePath  += strValue;

      // clean up
      RegCloseKey(hKey);
   }

   if (preload_sortie)  // Registry may have this set but the *.ini file may overide the preload_sortie flag.
   {
      CSortieFilesSystemInterface* pSortieFilesSystem = CLoadSortieAction::SortieSystem();

      if (pSortieFilesSystem)
      {
         char     szLoginName[256];
         DWORD    dwSizeofLoginName =  sizeof(szLoginName);
         GetUserName(szLoginName,   &dwSizeofLoginName);
         CString  userName          =  szLoginName;
         CString  fullProfilePath   =  eventProfilePath   +  "\\"  +  userName +  ".ini";

         preload_sortie =  GetPrivateProfileInt("FTD TIMS Interface",   "Preload Sortie", 0,  fullProfilePath);


         int   timeout  =  10;
         while (!CCommsShared::m_pCommsSystemInterface->Connected()  && preload_sortie)
         {
            Sleep(1000);         // Sleep 1 second
            timeout--;

            if (timeout <= 0)    // Still not connected so warn user.
            {
               CString  msg;
               msg.Format("Restart the host, then press RETRY to try the automatic loading of sortie file again OR press CANCEL to cancel the automatic loading of the sortie file.");
               int   retval   =  ::MessageBox(NULL, msg, "Host must be running in order to load a sortie file...", MB_ICONEXCLAMATION |  MB_RETRYCANCEL);

               if (retval  == IDCANCEL)
               {
                  msg.Format("Reminder:  The automatic loading of the sortie file was just canceled.");
                  ::MessageBox(NULL, msg, "No sortie was loaded...", MB_ICONEXCLAMATION |  MB_OK);
                  preload_sortie =  0;
               }
               timeout  =  10;
            }
         }


         if (GetPrivateProfileInt("FTD TIMS Interface",   "Record Debriefing", 0,  fullProfilePath))
            CCommsShared::m_pCommsSystemInterface->Debrief(true);
         else
            CCommsShared::m_pCommsSystemInterface->Debrief(false);


         if (preload_sortie)
         {
            char     base_name[256];
            char     lesson_name[256];
            int      count    =  0;
            long     old_type;
            CVariant var;

            count    =  GetPrivateProfileString("FTD TIMS Interface",   "Sortie Base",       "NONE",  base_name,     sizeof(base_name),   fullProfilePath);
            base_name[count   +  1] =  '\0';
            count    =  GetPrivateProfileString("FTD TIMS Interface",   "Selected Sortie",   "NONE",  lesson_name,   sizeof(lesson_name), fullProfilePath);
            lesson_name[count +  1] =  '\0';


            CCommsShared::GetLocalValue(var, _FSI_STL::string("selected_sortie_base"));
            old_type =  var.Type();
            var.Value((_FSI_STL::string)(LPCTSTR)base_name);
            var.ChangeType(old_type);
            CCommsShared::SetLocalValue(var, _FSI_STL::string("selected_sortie_base"), 0);

            CCommsShared::GetLocalValue(var, _FSI_STL::string("selected_sortie_lesson"));
            old_type =  var.Type();
            var.Value((_FSI_STL::string)(LPCTSTR)lesson_name);
            var.ChangeType(old_type);
            CCommsShared::SetLocalValue(var, _FSI_STL::string("selected_sortie_lesson"), 0);

            if (!strcmp(base_name,  "NONE")  || !strcmp(lesson_name, "NONE"))
            {
               CString  msg;
               msg.Format("Lesson %s at base %s is not a valid sortie.", lesson_name, base_name);
               ::MessageBox(NULL, msg, "Could not load sortie...", MB_ICONEXCLAMATION |  MB_OK);
            }
            else
            {
               Sleep(1000);   // Wait a second - give Comms a better chance to finish initializing.
               pSortieFilesSystem->LoadData("");
            }
         }
      }
   }

   if (!preload_sortie)
   {
      long     old_type;
      CVariant var;

      CCommsShared::GetLocalValue(var, _FSI_STL::string("selected_sortie_base"));
      old_type =  var.Type();
      var.Value((_FSI_STL::string)(LPCTSTR)"None");
      var.ChangeType(old_type);
      CCommsShared::SetLocalValue(var, _FSI_STL::string("selected_sortie_base"), 0);

      CCommsShared::GetLocalValue(var, _FSI_STL::string("selected_sortie_lesson"));
      old_type =  var.Type();
      var.Value((_FSI_STL::string)(LPCTSTR)"None");
      var.ChangeType(old_type);
      CCommsShared::SetLocalValue(var, _FSI_STL::string("selected_sortie_lesson"), 0);
   }
}
