// SortieDbName.cpp : implementation file
//

#include "..\core\stdafx.h"
#include "SortieDbName.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSortieDbName

CString CSortieDbName::m_dbName = _T("sortie.mdb");

bool CSortieDbName::m_initialized = false;

CSortieDbName::CSortieDbName()
{
   if (m_initialized)
      return;

   HKEY hKey;

   CString strValue = "sortie.mdb"; // default db name


   long  retval   =  RegOpenKeyEx(HKEY_CURRENT_USER, _T("Software\\FlightSafety\\FSISuite\\Sortie Files"), 0, KEY_READ, &hKey);

   if (hKey != NULL)
   {
      unsigned long  int   ulData   =  0;
      DWORD    dwSize   =  sizeof(unsigned   long  int);
      DWORD    dwType,  dwCount;
      LONG     lResult;

      lResult     =  RegQueryValueEx(hKey, "SORTIE_DB", NULL, &dwType, NULL, &dwCount);
      if (lResult == ERROR_SUCCESS)
      {
	      ASSERT(dwType == REG_SZ);
	      lResult  =  RegQueryValueEx(hKey, "SORTIE_DB", NULL, &dwType, (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)), &dwCount);
	      strValue.ReleaseBuffer();
      }
      RegCloseKey(hKey);
   }

   if (hKey == NULL  || strValue.CompareNoCase("sortie.mdb")   == 0)
   {
      retval   =  RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\Sortie Files"), 0, KEY_READ, &hKey);

      if (hKey != NULL)
      {
         unsigned long  int   ulData   =  0;
         DWORD    dwSize   =  sizeof(unsigned   long  int);
         DWORD    dwType,  dwCount;
         LONG     lResult;

	      lResult  =  RegQueryValueEx(hKey, "SORTIE_DB", NULL, &dwType, NULL, &dwCount);
	      if (lResult == ERROR_SUCCESS)
	      {
		      ASSERT(dwType == REG_SZ);
		      lResult  =  RegQueryValueEx(hKey, "SORTIE_DB", NULL, &dwType, (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)), &dwCount);
            strValue.ReleaseBuffer();
	      }
         RegCloseKey(hKey);
      }
   }

   m_initialized  =  true;
   m_dbName       =  strValue;   
}


CString CSortieDbName::GetDefaultDBName()
{
	return m_dbName;
}


void CSortieDbName::SetDefaultDBName(CString name)
{
   m_dbName = name;
}
