/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : SortieCommsAction.cpp
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.2 $
//
// Description      : SortieCommsAction.cpp contains the implementation of the 
//                    CSortieCommsAction class.  This Action is derived from 
//                    Core::CIOAction.  Its purpose is to distribute a 
//                    value to a graphical element in its OnUpdate 
//                    member.  This member is called from 
//                    CSortieCommsSystemInterface::UpdateComms().  
//                    CSortieCommsSystemInterface keeps track of all 
//                    CSortieCommsAction instances so that it may update all 
//                    of them.  Each CSortieCommsAction instance shares a 
//                    single CVariant instance.  Thus, many graphical 
//                    elements may want the value of a variable and 
//                    each graphical element will have an instance of a 
//                    CSortieCommsAction to read that variable.  However, the 
//                    value will be read from simulation once and 
//                    placed in the shared CVariant.  CSortieCommsAction will 
//                    also update simulation variable in OnLButtonUp.  
//                    This member will be called whenever an Action 
//                    occurs on a graphical element.  The Action might 
//                    be clicking a button or pressing the 
//                    enter/carriage return key while in an editbox.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : Core::CIOAction, Core::CWidget, Comms::CSortieCommsShared, 
//                    Core::CVariant, _FSI_STL::string, _FSI_STL::list, _FSI_STL::map, 
//                    _FSI_STL::vector, Comms::CSortieCommsSystemInterface, 
//                    Core::CChangeValue, Core::CRange.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 4
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: SortieCommsAction.cpp $
// Revision 1.2  1999/10/20 18:49:01  billyb
// Changed OnLButtonUp to return an enum.
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "SortieCommsAction.h"
#include "..\core\DataConversion.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

/////////////////////////////////////////////////////////////////////////////
//
// CSortieCommsAction::CSortieCommsAction
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default constructor.  Sets the name of the widget.
//                    Adds the CSortieCommsActionPage to the list of widget
//                    property pages.
/////////////////////////////////////////////////////////////////////////////
CSortieCommsAction::CSortieCommsAction()
{
    m_stlStrWidgetName = _FSI_STL::string("Sortie_Comms");

    m_bFirstDelete = true;
    m_bInitialized = false;
}

/////////////////////////////////////////////////////////////////////////////
//
// CSortieCommsAction::~CSortieCommsAction
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.  If a CSortieCommsSystemInterface derived
//                    class has been instaniated, then an attempt is made to
//                    remove this instance of CSortieCommsAction from the list of
//                    CSortieCommsAction instances managed by the 
//                    CSortieCommsSystemInterface derived class.
//
/////////////////////////////////////////////////////////////////////////////
CSortieCommsAction::~CSortieCommsAction()
{
}

/////////////////////////////////////////////////////////////////////////////
//
// void CSortieCommsAction::Initialize()
//
// Inputs           : CXMLWidget*& rpXMLWidget - pointer to return a new 
//                                               instance of a CXMLWidget.
//                    CWnd* pWnd - the parent of this widget.
//                    const long lId - the control ID.
//                    bool bEditMode - whether this widget is being created 
//                                     in the editor or the runtime.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Initialize() is a common framework method that must be
//                    implemented by each CWidget derived class.  Besides 
//                    standard initialization code for a CAction and CWidget
//                    derived class, the CSortieCommsSystemInterface derived class
//                    is started if it has not already been started. 
//
/////////////////////////////////////////////////////////////////////////////
void CSortieCommsAction::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                                const long lId, bool bEditMode)
{
    if (m_pCommsSystemInterface != NULL && lId != 0)
    {
        // Start comms if it hasn't been started and we're not editing.
        if (m_pCommsSystemInterface->Started() == false && m_bEditing == false)
        {
            m_pCommsSystemInterface->Start();
        }
    }

    // Call the base class.
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    // Set the Action and widget pointers.
    m_pAction = this;
    m_pWidget = (CWidget*)this;

    if (rpXMLWidget != NULL)
    {
        m_pIOActionXMLWidget = m_pXMLWidget;
        ResetProperties();
    }

    m_bInitialized = true;
}

/////////////////////////////////////////////////////////////////////////////
//
// CWidget* CSortieCommsAction::CreateObject()
//
// Inputs           : None.
//
// Return Values    : Address of a new instance of CSortieCommsAction.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : CreateObject() is a common framework method that must be
//                    implemented by each CWidget derived class.  The main
//                    application associates the name of this widget with this
//                    static CreateObject method so that a new object can be
//                    created without linking against the library that contains
//                    this class.
//
/////////////////////////////////////////////////////////////////////////////
CWidget* CSortieCommsAction::CreateObject()
{
    return new CSortieCommsAction();
}

/////////////////////////////////////////////////////////////////////////////
//
// enum LButtonUpReturn CSortieCommsAction::OnLButtonUp()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : OnLButtonUp() is a common framework method for CAction
//                    derived classes.  Its purpose is to perform a Action 
//                    based on some user interAction with the graphical 
//                    element to which the instance of this class is attached.
//                    In this case, OnLButtonUp is used to get a value from
//                    the graphical element to then write to simulation.
//
/////////////////////////////////////////////////////////////////////////////
enum LButtonUpReturn CSortieCommsAction::OnLButtonUp()
{
    m_sync.Lock();

    if (m_bCanWrite == false)
    {
        m_sync.Unlock();
        return LBU_CAN_NOT_WRITE;
    }

    if (m_bDeleting == true)
    {
        // Since memory is going away, the parent is probably
        // going away as well.  Let the parent think that
        // everything went ok.  Or, no write can take place
        m_sync.Unlock();
        return LBU_OK;
    }

    if (m_pCommsSystemInterface == NULL)
    {
        m_sync.Unlock();
        return LBU_NO_COMMS;
    }

    CVariableData* pVarData = NULL;

    if (m_pCommsSystemInterface->m_mapVarName2Data.find(m_stlStrVariableToWatch) !=
        m_pCommsSystemInterface->m_mapVarName2Data.end())
    {
        // Get the variable data to change the type.
        pVarData = 
            m_pCommsSystemInterface->m_mapVarName2Data[m_stlStrVariableToWatch];

        if (pVarData == NULL)
        {
            m_sync.Unlock();
            return LBU_OK;
        }
    }
    else
    {
        m_sync.Unlock();
        return LBU_OK;
    }

    CVariant variant = m_varInitial;
    variant.ChangeType(pVarData->Type());
    variant = variant[m_lElement];

    // Perform range check before data conversion because the parent widget
    // will have a high and low in terms of the convert type if a conversion
    // was desired.
    if (!m_vectRanges.empty())
    {
        variant.LimitFloating(m_bLimitFloating);
        variant.Precision(m_ucPrecision);

        // No range check.  No parent widget.
//        if (m_pParentWidget->RangeLow(m_stlStrElementVar) > variant  ||
//            m_pParentWidget->RangeHigh(m_stlStrElementVar) < variant)
//        {
//            m_stlStrError = (_FSI_STL::string)variant + " is not a valid entry.\n" 
//                            "For the variable " +
//                            m_stlStrVariableToWatch +
//                            ", the valid range is " + 
//                            (_FSI_STL::string)m_pParentWidget->RangeLow(m_stlStrElementVar) +
//                            " to " +
//                            (_FSI_STL::string)m_pParentWidget->RangeHigh(m_stlStrElementVar);
//            AfxBeginThread(MsgThread, (LPVOID)0);
//
//            m_sync.Unlock();
//            return LBU_NOT_IN_RANGE;
//        }
    }

    // See the parent widget is using a converted data value.  If so,
    // then convert it back to the format in which it came form the host.
    if (m_lDataFormat != m_lInitialDataFormat &&
        m_lDataFormat != Generic_No_Conversions)
    {
        variant = CDataConversion::Convert(variant, 
                                           (DATA_FORMATS)m_lDataFormat,
                                           (DATA_FORMATS)m_lInitialDataFormat);
    }

    long lOffset = pVarData->ArrayOffset();
    pVarData->ArrayOffset(m_lElement);

    // Call the instantiated CSortieCommsSystemInterface derived class' 
    // WriteData member to update simulation.
    m_pCommsSystemInterface->WriteData(&variant, pVarData);

    pVarData->ArrayOffset(lOffset);

    m_sync.Unlock();

    return LBU_OK;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CSortieCommsAction::OnUpdate()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : OnUpdate() is a common framework method for CAction
//                    derived classes.  Its purpose is to send a new value
//                    to its parent graphical widget.  OnUpdate should 
//                    generally be called by some other class than the parent 
//                    graphical element.
//
/////////////////////////////////////////////////////////////////////////////
void CSortieCommsAction::OnUpdate()
{
    return;
}

//////////////////////////////////////////////////////////////////////
// Accessors
//////////////////////////////////////////////////////////////////////

CVariant CSortieCommsAction::InitialValue()
{
    return m_varInitial;
}

//////////////////////////////////////////////////////////////////////
// Mutators
//////////////////////////////////////////////////////////////////////

void CSortieCommsAction::InitialValue(const CVariant& rvarValue)
{
    m_varInitial = rvarValue;
}
