// RepositionRecordSet.cpp : implementation file
//

#include "..\core\stdafx.h"
#include <afxdao.h>			// MFC DAO database classes
#include "RepositionRecordSet.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRepositionRecordSet

IMPLEMENT_DYNAMIC(CRepositionRecordSet, CDaoRecordset)

CRepositionRecordSet::CRepositionRecordSet(CDaoDatabase* pdb)
	: CDaoRecordset(pdb)
{
	//{{AFX_FIELD_INIT(CRepositionRecordSet)
	m_Active_Airport = _T("");
	m_Active_Runway = _T("");
	m_Base_ID = _T("");
	m_Lesson_ID = _T("");
	m_Reposition_Airspeed = _T("");
	m_Reposition_Altitude_MSL = _T("");
	m_Reposition_Command = _T("");
	m_Reposition_Heading = _T("");
	m_Reposition_Latitude = _T("");
	m_Reposition_Longitude = _T("");
	m_Reposition_Navaid_Distance = _T("");
	m_Reposition_Navaid_ID = _T("");
	m_Reposition_Navaid_Radial = _T("");
	m_Formation_Command = _T("");
	m_nFields = 14;
	//}}AFX_FIELD_INIT
	m_nDefaultType = dbOpenDynaset;
}


CString CRepositionRecordSet::GetDefaultDBName()
{
	return m_dbName;
}

CString CRepositionRecordSet::GetDefaultSQL()
{
	return _T("[Reposition]");
}

void CRepositionRecordSet::DoFieldExchange(CDaoFieldExchange* pFX)
{
	//{{AFX_FIELD_MAP(CRepositionRecordSet)
	pFX->SetFieldType(CDaoFieldExchange::outputColumn);
	DFX_Text(pFX, _T("[Active Airport]"), m_Active_Airport);
	DFX_Text(pFX, _T("[Active Runway]"), m_Active_Runway);
	DFX_Text(pFX, _T("[Base ID]"), m_Base_ID);
	DFX_Text(pFX, _T("[Lesson ID]"), m_Lesson_ID);
	DFX_Text(pFX, _T("[Reposition Airspeed]"), m_Reposition_Airspeed);
	DFX_Text(pFX, _T("[Reposition Altitude MSL]"), m_Reposition_Altitude_MSL);
	DFX_Text(pFX, _T("[Reposition Command]"), m_Reposition_Command);
	DFX_Text(pFX, _T("[Reposition Heading]"), m_Reposition_Heading);
	DFX_Text(pFX, _T("[Reposition Latitude]"), m_Reposition_Latitude);
	DFX_Text(pFX, _T("[Reposition Longitude]"), m_Reposition_Longitude);
	DFX_Text(pFX, _T("[Reposition Navaid Distance]"), m_Reposition_Navaid_Distance);
	DFX_Text(pFX, _T("[Reposition Navaid ID]"), m_Reposition_Navaid_ID);
	DFX_Text(pFX, _T("[Reposition Navaid Radial]"), m_Reposition_Navaid_Radial);
	DFX_Text(pFX, _T("[Formation Command]"), m_Formation_Command);
	//}}AFX_FIELD_MAP
}

/////////////////////////////////////////////////////////////////////////////
// CRepositionRecordSet diagnostics

#ifdef _DEBUG
void CRepositionRecordSet::AssertValid() const
{
	CDaoRecordset::AssertValid();
}

void CRepositionRecordSet::Dump(CDumpContext& dc) const
{
	CDaoRecordset::Dump(dc);
}
#endif //_DEBUG
