// PickLessonAction.cpp: implementation of the CPickLessonAction class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "..\general\ComboWidget.h"
#include "PickLessonAction.h"
#include "SortieFilesSystemInterface.h"
#include "..\comms\commsShared.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

CSortieFilesSystemInterface   *CPickLessonAction::m_pSortieSystem = NULL;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CPickLessonAction::CPickLessonAction()
{
    m_stlStrWidgetName  = _FSI_STL::string("Pick_Lesson");
    m_listWidgetPropPages.pop_back();  // CLocalCommsAction pushes a CFormatPage and a
    m_listWidgetPropPages.pop_back();  // CRangePage that are not needed with this object so pop them off the list.
}

CPickLessonAction::~CPickLessonAction()
{
}

CWidget* CPickLessonAction::CreateObject()
{
    return new CPickLessonAction();
}

enum LButtonUpReturn CPickLessonAction::OnLButtonUp()
{
   m_sync.Lock();

   if (m_bDeleting == true)
   {
      // Since memory is going away, the parent is probably going away as well.  Let the parent think that
      // everything went ok.  Or, no write can take place
      m_sync.Unlock();
      return LBU_OK;
   }

   // Make sure this instance is attached to a graphical element.
   if (CWidget::IsValidAddress(m_pParentWidget) != VALID)
   {
      m_sync.Unlock();
      return LBU_OK;
   }

   CFrameWnd* pFrame = m_pBaseWidget->Wnd()->GetParentFrame(); 
   if (pFrame != NULL)
      pFrame->BeginWaitCursor();


   CVariant *pVarSelection =  ((CComboWidget *)m_pParentWidget)->GetValue("Default");
   long     selection      =  (long)*pVarSelection;

   m_ChangeValue.Variant(pVarSelection);
   m_ChangeValue.UseRange(false);

   m_pParentWidget->ChangeValue("Default", &m_ChangeValue);
   m_pParentWidget->Wnd()->Invalidate();


   if (m_pSortieSystem)
   {
      CString  lesson_name;
      _FSI_STL::list<_FSI_STL::string>::iterator   list_iter   =  m_pSortieSystem->m_list_of_lessons[selection].begin();
      if (list_iter  != m_pSortieSystem->m_list_of_lessons[selection].end())
      {
         lesson_name =  (*list_iter).c_str();
         int   count =  lesson_name.Find(" - ");
         lesson_name =  lesson_name.Left(count);

         CVariant var;
         CCommsShared::GetLocalValue(var, _FSI_STL::string("selected_sortie_lesson"));
         long  old_type =  var.Type();
         var.Value((_FSI_STL::string)(LPCTSTR)lesson_name);
         var.ChangeType(old_type);
         CCommsShared::SetLocalValue(var, _FSI_STL::string("selected_sortie_lesson"), 0);
      }
   }

   if (pFrame != NULL)
      pFrame->EndWaitCursor();

   m_sync.Unlock();
   return   LBU_OK;
}


void  CPickLessonAction::OnUpdate()
{
   m_sync.Lock();

   if (m_bDeleting == true)
   {
      m_sync.Unlock();
      return;
   }

   // Make sure this instance is attached to a graphical element.
   if (CWidget::IsValidAddress(m_pParentWidget) != VALID)
   {
      m_sync.Unlock();
      return;
   }

   if (m_pSortieSystem)
   {
      ((CComboWidget *)m_pParentWidget)->Entries(m_pSortieSystem->m_list_of_lessons);
   }

   m_sync.Unlock();
}


//////////////////////////////////////////////////////////////////////
// Accessors
//////////////////////////////////////////////////////////////////////
CSortieFilesSystemInterface* CPickLessonAction::SortieSystem()
{
    return m_pSortieSystem;
}

//////////////////////////////////////////////////////////////////////
// Mutators
//////////////////////////////////////////////////////////////////////
void CPickLessonAction::SortieSystem(const CSortieFilesSystemInterface* pSortieSystem)
{
    m_pSortieSystem = const_cast<CSortieFilesSystemInterface*>(pSortieSystem);
}
