// PickBaseAction.h: interface for the CPickBaseAction class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(_PickBaseAction_H_)
#define _PickBaseAction_H_

#include "../comms/localcommsaction.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CSortieFilesSystemInterface;

class CPickBaseAction : public CLocalCommsAction
{
protected:
    static CSortieFilesSystemInterface*        m_pSortieSystem;

public:
	CPickBaseAction();
	virtual ~CPickBaseAction();

   static CWidget* CreateObject();

   virtual enum LButtonUpReturn OnLButtonUp();
   virtual void OnUpdate();

   // Accessor
   static CSortieFilesSystemInterface* SortieSystem();
   // Mutator
   static void SortieSystem(const CSortieFilesSystemInterface* pSortieSystem);

private:
   _FSI_STL::map<long, _FSI_STL::list<_FSI_STL::string> >   m_list_of_bases;

};

#endif // !defined(_PickBaseAction_H_)
