// PickBaseAction.cpp: implementation of the CPickBaseAction class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "..\general\ComboWidget.h"
#include "PickBaseAction.h"
#include "SortieFilesSystemInterface.h"
#include "SortieRecordSet.h"
#include "BasesRecordSet.h"
#include "..\comms\commsShared.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

CSortieFilesSystemInterface   *CPickBaseAction::m_pSortieSystem = NULL;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CPickBaseAction::CPickBaseAction()
{
    m_stlStrWidgetName  = _FSI_STL::string("Pick_Base");
    m_listWidgetPropPages.pop_back();  // CLocalCommsAction pushes a CFormatPage and a
    m_listWidgetPropPages.pop_back();  // CRangePage that are not needed with this object so pop them off the list.
}

CPickBaseAction::~CPickBaseAction()
{
}

CWidget* CPickBaseAction::CreateObject()
{
    return new CPickBaseAction();
}

enum LButtonUpReturn CPickBaseAction::OnLButtonUp()
{
   m_sync.Lock();

   if (m_bDeleting == true)
   {
      // Since memory is going away, the parent is probably going away as well.  Let the parent think that
      // everything went ok.  Or, no write can take place
      m_sync.Unlock();
      return LBU_OK;
   }

   // Make sure this instance is attached to a graphical element.
   if (CWidget::IsValidAddress(m_pParentWidget) != VALID)
   {
      m_sync.Unlock();
      return LBU_OK;
   }

   CFrameWnd* pFrame = m_pBaseWidget->Wnd()->GetParentFrame(); 
   if (pFrame != NULL)
      pFrame->BeginWaitCursor();


   CVariant *pVarSelection =  ((CComboWidget *)m_pParentWidget)->GetValue("Default");
   long     selection      =  (long)*pVarSelection;

   m_ChangeValue.Variant(pVarSelection);
   m_ChangeValue.UseRange(false);

   m_pParentWidget->ChangeValue("Default", &m_ChangeValue);
   m_pParentWidget->Wnd()->Invalidate();


   CString  base_name;
   _FSI_STL::list<_FSI_STL::string>::iterator   list_iter   =  m_list_of_bases[selection].begin();
   if (list_iter  != m_list_of_bases[selection].end())
   {
      base_name   =  (*list_iter).c_str();                     // Get the BASE name.

      if (m_pSortieSystem)
      {
         m_pSortieSystem->m_list_of_lessons.clear();           // Clear the list of lessons.

         CSortieRecordSet  *pSortieSet;
         pSortieSet        =  new   CSortieRecordSet(NULL);

         if (! pSortieSet->IsOpen())
         {
            try
            {
               pSortieSet->Open();
            }
            catch(CDaoException  *e)
            {
               AfxMessageBox(e->m_pErrorInfo->m_strDescription);
               e->Delete();
               return   LBU_OK;
            }
         }


         CString  condition;
         condition.Format("[Base ID] = '%s'", base_name);
         BOOL  found =  false;
         try
         {
            found =  pSortieSet->Find(AFX_DAO_FIRST, condition);
         }
         catch(CDaoException  *e)
         {
            AfxMessageBox(e->m_pErrorInfo->m_strDescription);
            e->Delete();
            return   LBU_OK;
         }

         long  index    =  0;

         CString  instruction;
         if (found)
            instruction.Format("Select lesson...");
         else
            instruction.Format("No lessons found for %s...", base_name);

         m_pSortieSystem->m_list_of_lessons[index].push_back((LPCTSTR)instruction);


         CString  list_item;
         // Look up list of lessons here.
         index++;
         while (! pSortieSet->IsEOF()   && found)
         {
            list_item   =  pSortieSet->m_Lesson_ID +  " - " +  pSortieSet->m_Sortie_Description;
            m_pSortieSystem->m_list_of_lessons[index].push_back((LPCTSTR)list_item);

            index++;
            try
            {
               found =  pSortieSet->FindNext(condition);
            }
            catch(CDaoException  *e)
            {
               AfxMessageBox(e->m_pErrorInfo->m_strDescription);
               e->Delete();
               return   LBU_OK;
            }
         }

         pSortieSet->Close();
         delete   pSortieSet;
      }

      CVariant var;
      CCommsShared::GetLocalValue(var, _FSI_STL::string("selected_sortie_base"));
      long  old_type =  var.Type();
      var.Value((_FSI_STL::string)(LPCTSTR)base_name);
      var.ChangeType(old_type);
      CCommsShared::SetLocalValue(var, _FSI_STL::string("selected_sortie_base"), 0);
   }

   if (pFrame != NULL)
      pFrame->EndWaitCursor();

   m_sync.Unlock();
   return   LBU_OK;
}

void  CPickBaseAction::OnUpdate()
{
   m_sync.Lock();

   if (m_bDeleting == true)
   {
      m_sync.Unlock();
      return;
   }

   // Make sure this instance is attached to a graphical element.
   if (CWidget::IsValidAddress(m_pParentWidget) != VALID)
   {
      m_sync.Unlock();
      return;
   }


   m_list_of_bases.clear();
   long  index    =  0;
   m_list_of_bases[index].push_back((LPCTSTR)"Select base...");


   CBasesRecordSet   *pBasesSet;
   pBasesSet         =  new   CBasesRecordSet(NULL);
   pBasesSet->Open();

   // Look up list of bases here.
   index++;
   while (! pBasesSet->IsEOF())
   {
      m_list_of_bases[index].push_back((LPCTSTR)pBasesSet->m_Base_ID);
      index++;
      pBasesSet->MoveNext();
   }

   pBasesSet->Close();
   delete   pBasesSet;

   ((CComboWidget *)m_pParentWidget)->Entries(m_list_of_bases);

   m_sync.Unlock();
}

//////////////////////////////////////////////////////////////////////
// Accessors
//////////////////////////////////////////////////////////////////////
CSortieFilesSystemInterface* CPickBaseAction::SortieSystem()
{
    return m_pSortieSystem;
}

//////////////////////////////////////////////////////////////////////
// Mutators
//////////////////////////////////////////////////////////////////////
void CPickBaseAction::SortieSystem(const CSortieFilesSystemInterface* pSortieSystem)
{
    m_pSortieSystem = const_cast<CSortieFilesSystemInterface*>(pSortieSystem);
}
