// LoadSortieAction.cpp: implementation of the CLoadSortieAction class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "LoadSortieAction.h"
#include "SortieFilesSystemInterface.h"

//#include "..\core\LinkPage.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

CSortieFilesSystemInterface*        CLoadSortieAction::m_pSortieSystem = NULL;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CLoadSortieAction::CLoadSortieAction()
{
   m_stlStrWidgetName  = _FSI_STL::string("Load_Sortie");
   m_listWidgetPropPages.pop_back();  // CPageAction pushes a CLinkPage property page that this object doesn't need.
}

CLoadSortieAction::~CLoadSortieAction()
{
}

void CLoadSortieAction::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                                const long lId, bool bEditMode)
{
    m_strPage = "Untitled.fml";
    m_strComponent = "IOS";
    m_strSubComponent = "PAGES";

    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    if (rpXMLWidget != NULL)
    {
        ResetProperties();
    }

    m_pAction = this;
    m_pWidget = (CWidget*)this;
}

CWidget* CLoadSortieAction::CreateObject()
{
    return new CLoadSortieAction();
}

enum LButtonUpReturn CLoadSortieAction::OnLButtonUp()
{
    if (m_pSortieSystem != NULL)
    {
        CString strPageInfo = CString(m_strComponent + "^" + m_strSubComponent + 
							    "^" + m_strPage);

        CWidget::ExpandPath(strPageInfo);

        CFrameWnd* pFrame = m_pBaseWidget->Wnd()->GetParentFrame(); 

        if (pFrame != NULL)
           pFrame->BeginWaitCursor();

        m_pSortieSystem->LoadData(_FSI_STL::string((LPCTSTR)strPageInfo));

        if (pFrame != NULL)
           pFrame->EndWaitCursor();
    }

    return LBU_OK;
}

//////////////////////////////////////////////////////////////////////
// Accessors
//////////////////////////////////////////////////////////////////////
CSortieFilesSystemInterface* CLoadSortieAction::SortieSystem()
{
    return m_pSortieSystem;
}

//////////////////////////////////////////////////////////////////////
// Mutators
//////////////////////////////////////////////////////////////////////
void CLoadSortieAction::SortieSystem(const CSortieFilesSystemInterface* pSortieSystem)
{
    m_pSortieSystem = const_cast<CSortieFilesSystemInterface*>(pSortieSystem);
}

