// AircraftConfigRecordSet.cpp : implementation file
//

#include "..\core\stdafx.h"
#include <afxdao.h>			// MFC DAO database classes
#include "AircraftConfigRecordSet.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAircraftConfigRecordSet

IMPLEMENT_DYNAMIC(CAircraftConfigRecordSet, CDaoRecordset)

CAircraftConfigRecordSet::CAircraftConfigRecordSet(CDaoDatabase* pdb)
	: CDaoRecordset(pdb)
{
	//{{AFX_FIELD_INIT(CAircraftConfigRecordSet)
	m_Lesson_ID = _T("");
	m_Base_ID = _T("");
	m_Master_Light_Level = _T("");
	m_Master_Light_Level_Activate = _T("");
	m_External_Power = _T("");
	m_Wheel_Chocks = _T("");
	m_Number_of_Pilots = _T("");
	m_Overspeed_Mute = _T("");
	m_Gear_Warning_Mute = _T("");
	m_Left_Fuel_Quantity = _T("");
	m_Right_Fuel_Quantity = _T("");
	m_Chatter_Rate = _T("");
	m_Quickstart = _T("");
        m_Display_Propeller = _T("");
        m_Rear_Seat_View = _T("");
	m_nFields = 15;
	//}}AFX_FIELD_INIT
	m_nDefaultType = dbOpenDynaset;
}


CString CAircraftConfigRecordSet::GetDefaultDBName()
{
	return m_dbName;
}

CString CAircraftConfigRecordSet::GetDefaultSQL()
{
	return _T("[Aircraft Config]");
}

void CAircraftConfigRecordSet::DoFieldExchange(CDaoFieldExchange* pFX)
{
	//{{AFX_FIELD_MAP(CAircraftConfigRecordSet)
	pFX->SetFieldType(CDaoFieldExchange::outputColumn);
	DFX_Text(pFX, _T("[Lesson ID]"), m_Lesson_ID);
	DFX_Text(pFX, _T("[Base ID]"), m_Base_ID);
	DFX_Text(pFX, _T("[Master Light Level]"), m_Master_Light_Level);
	DFX_Text(pFX, _T("[Master Light Level Activate]"), m_Master_Light_Level_Activate);
	DFX_Text(pFX, _T("[External Power]"), m_External_Power);
	DFX_Text(pFX, _T("[Wheel Chocks]"), m_Wheel_Chocks);
	DFX_Text(pFX, _T("[Number of Pilots]"), m_Number_of_Pilots);
	DFX_Text(pFX, _T("[Overspeed Mute]"), m_Overspeed_Mute);
	DFX_Text(pFX, _T("[Gear Warning Mute]"), m_Gear_Warning_Mute);
	DFX_Text(pFX, _T("[Left Fuel Quantity]"), m_Left_Fuel_Quantity);
	DFX_Text(pFX, _T("[Right Fuel Quantity]"), m_Right_Fuel_Quantity);
	DFX_Text(pFX, _T("[Chatter Rate]"), m_Chatter_Rate);
	DFX_Text(pFX, _T("[Quickstart]"), m_Quickstart);
	DFX_Text(pFX, _T("[Display Propeller]"), m_Display_Propeller);
	DFX_Text(pFX, _T("[Rear Seat View]"), m_Rear_Seat_View);
	//}}AFX_FIELD_MAP
}

/////////////////////////////////////////////////////////////////////////////
// CAircraftConfigRecordSet diagnostics

#ifdef _DEBUG
void CAircraftConfigRecordSet::AssertValid() const
{
	CDaoRecordset::AssertValid();
}

void CAircraftConfigRecordSet::Dump(CDumpContext& dc) const
{
	CDaoRecordset::Dump(dc);
}
#endif //_DEBUG
