// WeatherArea4Page.cpp : implementation file
//

#include "stdafx.h"
#include "sortieedit.h"
#include "WeatherArea4Page.h"

#include "CloudTypeRecordSet.h"
#include "FogTypeRecordSet.h"
#include "IcingQuantityRecordSet.h"
#include "IcingTimeRecordSet.h"
#include "PrecipitationIntensityRecordSet.h"
#include "PrecipitationTypeRecordSet.h"
#include "RunwayConditionRecordSet.h"
#include "TimeOfDayRecordSet.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWeatherArea4Page property page

IMPLEMENT_DYNCREATE(CWeatherArea4Page, CPropertyPage)

CWeatherArea4Page::CWeatherArea4Page() : CPropertyPage(CWeatherArea4Page::IDD)
{
	//{{AFX_DATA_INIT(CWeatherArea4Page)
	m_blowing_contamination = FALSE;
	m_cirrus = FALSE;
	m_hail = FALSE;
	m_lightning = FALSE;
	m_scud = FALSE;
	m_use = FALSE;
	m_wet_skid_marks = FALSE;
	m_airport = _T("");
	m_altimeter = _T("");
	m_fog_top = _T("");
	m_lower_clouds_bottom = _T("");
	m_lower_clouds_top = _T("");
	m_radius = _T("");
	m_runway = _T("");
	m_runway_conditions_rating = _T("");
	m_surface_wind_direction = _T("");
	m_surface_wind_speed = _T("");
	m_temperature = _T("");
	m_turbulence = _T("");
	m_upper_clouds_bottom = _T("");
	m_upper_clouds_top = _T("");
	m_visibility = _T("");
	m_wind_gust_direction = _T("");
	m_wind_gust_speed = _T("");
	//}}AFX_DATA_INIT

   m_pWeatherArea4RecordSet   =  new   CWeatherArea4RecordSet(NULL);
}

CWeatherArea4Page::~CWeatherArea4Page()
{
   if (m_pWeatherArea4RecordSet->IsOpen())
      m_pWeatherArea4RecordSet->Close();
   delete   m_pWeatherArea4RecordSet;
}

void CWeatherArea4Page::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWeatherArea4Page)
	DDX_Control(pDX, IDC_COMBO_UPPER_CLOUDS_COVERAGE_4, m_ctrl_upper_clouds_coverage);
	DDX_Control(pDX, IDC_COMBO_TIME_OF_DAY_4, m_ctrl_time_of_day);
	DDX_Control(pDX, IDC_COMBO_RUNWAY_CONDITION_4, m_ctrl_runway_condition);
	DDX_Control(pDX, IDC_COMBO_PRECIP_TYPE_4, m_ctrl_precipitation_type);
	DDX_Control(pDX, IDC_COMBO_PRECIP_INTENSITY_4, m_ctrl_precipitation_intensity);
	DDX_Control(pDX, IDC_COMBO_LOWER_CLOUDS_COVERAGE_4, m_ctrl_lower_clouds_coverage);
	DDX_Control(pDX, IDC_COMBO_ICING_TIME_4, m_ctrl_icing_time);
	DDX_Control(pDX, IDC_COMBO_ICING_QUANTITY_4, m_ctrl_icing_quantity);
	DDX_Control(pDX, IDC_COMBO_FOG_TYPE_4, m_ctrl_fog_type);
	DDX_Check(pDX, IDC_CHECK_BLOWING_CONTAMINATION_4, m_blowing_contamination);
	DDX_Check(pDX, IDC_CHECK_CIRRUS_4, m_cirrus);
	DDX_Check(pDX, IDC_CHECK_HAIL_4, m_hail);
	DDX_Check(pDX, IDC_CHECK_LIGHTNING_4, m_lightning);
	DDX_Check(pDX, IDC_CHECK_SCUD_4, m_scud);
	DDX_Check(pDX, IDC_CHECK_USE_4, m_use);
	DDX_Check(pDX, IDC_CHECK_WET_SKIDMARKS_4, m_wet_skid_marks);
	DDX_Text(pDX, IDC_EDIT_AIRPORT_4, m_airport);
	DDX_Text(pDX, IDC_EDIT_ALTIMETER_4, m_altimeter);
	DDX_Text(pDX, IDC_EDIT_FOG_TOP_4, m_fog_top);
	DDX_Text(pDX, IDC_EDIT_LOWER_CLOUDS_BOTTOM_4, m_lower_clouds_bottom);
	DDX_Text(pDX, IDC_EDIT_LOWER_CLOUDS_TOP_4, m_lower_clouds_top);
	DDX_Text(pDX, IDC_EDIT_RADIUS_4, m_radius);
	DDX_Text(pDX, IDC_EDIT_RUNWAY_4, m_runway);
	DDX_Text(pDX, IDC_EDIT_RUNWAY_COND_RATING_4, m_runway_conditions_rating);
	DDX_Text(pDX, IDC_EDIT_SURFACE_WIND_DIRECTION_4, m_surface_wind_direction);
	DDX_Text(pDX, IDC_EDIT_SURFACE_WIND_SPEED_4, m_surface_wind_speed);
	DDX_Text(pDX, IDC_EDIT_TEMPERATURE_4, m_temperature);
	DDX_Text(pDX, IDC_EDIT_TURBULENCE_4, m_turbulence);
	DDX_Text(pDX, IDC_EDIT_UPPER_CLOUDS_BOTTOM_4, m_upper_clouds_bottom);
	DDX_Text(pDX, IDC_EDIT_UPPER_CLOUDS_TOP_4, m_upper_clouds_top);
	DDX_Text(pDX, IDC_EDIT_VISIBILITY_4, m_visibility);
	DDX_Text(pDX, IDC_EDIT_WIND_GUST_DIRECTION_4, m_wind_gust_direction);
	DDX_Text(pDX, IDC_EDIT_WIND_GUST_SPEED_4, m_wind_gust_speed);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CWeatherArea4Page, CPropertyPage)
	//{{AFX_MSG_MAP(CWeatherArea4Page)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWeatherArea4Page message handlers

BOOL CWeatherArea4Page::OnInitDialog() 
{
   CPropertyPage::OnInitDialog();

   // Populate the Cloud Coverage ComboBoxes.
   CCloudTypeRecordSet  *pCloudTypeRecordSet =  new   CCloudTypeRecordSet(NULL);
   pCloudTypeRecordSet->Open();
   m_ctrl_lower_clouds_coverage.ResetContent();
   m_ctrl_upper_clouds_coverage.ResetContent();
   while (! pCloudTypeRecordSet->IsEOF())
   {
      m_ctrl_lower_clouds_coverage.AddString(pCloudTypeRecordSet->m_Text);
      m_ctrl_upper_clouds_coverage.AddString(pCloudTypeRecordSet->m_Text);
      pCloudTypeRecordSet->MoveNext();
   }
   pCloudTypeRecordSet->Close();
   delete   pCloudTypeRecordSet;
	

   // Populate the Fog Type ComboBox.
   CFogTypeRecordSet  *pFogTypeRecordSet =  new   CFogTypeRecordSet(NULL);
   pFogTypeRecordSet->Open();
   m_ctrl_fog_type.ResetContent();
   while (! pFogTypeRecordSet->IsEOF())
   {
      m_ctrl_fog_type.AddString(pFogTypeRecordSet->m_Text);
      pFogTypeRecordSet->MoveNext();
   }
   pFogTypeRecordSet->Close();
   delete   pFogTypeRecordSet;


   // Populate the Icing Quantity ComboBox.
   CIcingQuantityRecordSet  *pIcingQuantityRecordSet =  new   CIcingQuantityRecordSet(NULL);
   pIcingQuantityRecordSet->Open();
   m_ctrl_icing_quantity.ResetContent();
   while (! pIcingQuantityRecordSet->IsEOF())
   {
      m_ctrl_icing_quantity.AddString(pIcingQuantityRecordSet->m_Text);
      pIcingQuantityRecordSet->MoveNext();
   }
   pIcingQuantityRecordSet->Close();
   delete   pIcingQuantityRecordSet;


   // Populate the Icing Time ComboBox.
   CIcingTimeRecordSet  *pIcingTimeRecordSet =  new   CIcingTimeRecordSet(NULL);
   pIcingTimeRecordSet->Open();
   m_ctrl_icing_time.ResetContent();
   while (! pIcingTimeRecordSet->IsEOF())
   {
      m_ctrl_icing_time.AddString(pIcingTimeRecordSet->m_Text);
      pIcingTimeRecordSet->MoveNext();
   }
   pIcingTimeRecordSet->Close();
   delete   pIcingTimeRecordSet;


   // Populate the Precipitation Intensity ComboBox.
   CPrecipitationIntensityRecordSet  *pPrecipitationIntensityRecordSet =  new   CPrecipitationIntensityRecordSet(NULL);
   pPrecipitationIntensityRecordSet->Open();
   m_ctrl_precipitation_intensity.ResetContent();
   while (! pPrecipitationIntensityRecordSet->IsEOF())
   {
      m_ctrl_precipitation_intensity.AddString(pPrecipitationIntensityRecordSet->m_Text);
      pPrecipitationIntensityRecordSet->MoveNext();
   }
   pPrecipitationIntensityRecordSet->Close();
   delete   pPrecipitationIntensityRecordSet;


   // Populate the Precipitation Type ComboBox.
   CPrecipitationTypeRecordSet  *pPrecipitationTypeRecordSet =  new   CPrecipitationTypeRecordSet(NULL);
   pPrecipitationTypeRecordSet->Open();
   m_ctrl_precipitation_type.ResetContent();
   while (! pPrecipitationTypeRecordSet->IsEOF())
   {
      m_ctrl_precipitation_type.AddString(pPrecipitationTypeRecordSet->m_Text);
      pPrecipitationTypeRecordSet->MoveNext();
   }
   pPrecipitationTypeRecordSet->Close();
   delete   pPrecipitationTypeRecordSet;


   // Populate the Runway Condition ComboBox.
   CRunwayConditionRecordSet  *pRunwayConditionRecordSet =  new   CRunwayConditionRecordSet(NULL);
   pRunwayConditionRecordSet->Open();
   m_ctrl_runway_condition.ResetContent();
   while (! pRunwayConditionRecordSet->IsEOF())
   {
      m_ctrl_runway_condition.AddString(pRunwayConditionRecordSet->m_Text);
      pRunwayConditionRecordSet->MoveNext();
   }
   pRunwayConditionRecordSet->Close();
   delete   pRunwayConditionRecordSet;


   // Populate the Time Of Day ComboBox.
   CTimeOfDayRecordSet  *pTimeOfDayRecordSet =  new   CTimeOfDayRecordSet(NULL);
   pTimeOfDayRecordSet->Open();
   m_ctrl_time_of_day.ResetContent();
   while (! pTimeOfDayRecordSet->IsEOF())
   {
      m_ctrl_time_of_day.AddString(pTimeOfDayRecordSet->m_Text);
      pTimeOfDayRecordSet->MoveNext();
   }
   pTimeOfDayRecordSet->Close();
   delete   pTimeOfDayRecordSet;



   if (! m_pWeatherArea4RecordSet->IsOpen())
   {
      try
      {
         m_pWeatherArea4RecordSet->Open();
      }
      catch(CDaoException  *e)
      {
         AfxMessageBox(e->m_pErrorInfo->m_strDescription);
         e->Delete();
         return   TRUE;
      }
   }

   BOOL  found =  m_pWeatherArea4RecordSet->Find(AFX_DAO_FIRST, m_condition_for_find);
   if (found)
   {
      m_blowing_contamination    =  (m_pWeatherArea4RecordSet->m_Blowing_Contaminant_4 == "1");
	   m_cirrus                   =  (m_pWeatherArea4RecordSet->m_Cirrus_4              == "1");
	   m_hail                     =  (m_pWeatherArea4RecordSet->m_Hail_4                == "1");
	   m_lightning                =  (m_pWeatherArea4RecordSet->m_Lightning_4           == "1");
	   m_scud                     =  (m_pWeatherArea4RecordSet->m_Scud_4                == "1");
	   m_use                      =  (m_pWeatherArea4RecordSet->m_Use_Weather_Area_4    == "1");
	   m_wet_skid_marks           =  (m_pWeatherArea4RecordSet->m_Runway_Skidmarks_4    == "1");
	   m_airport                  =  m_pWeatherArea4RecordSet->m_Active_Airport_4;
	   m_altimeter                =  m_pWeatherArea4RecordSet->m_Field_Pressure_Hg_4;
	   m_fog_top                  =  m_pWeatherArea4RecordSet->m_Fog_Top_4;
	   m_lower_clouds_bottom      =  m_pWeatherArea4RecordSet->m_Lower_Cloud_Bottom_4;
	   m_lower_clouds_top         =  m_pWeatherArea4RecordSet->m_Lower_Cloud_Top_4;
	   m_radius                   =  m_pWeatherArea4RecordSet->m_Weather_Area_Radius_4;
	   m_runway                   =  m_pWeatherArea4RecordSet->m_Active_Runway_4;
	   m_runway_conditions_rating =  m_pWeatherArea4RecordSet->m_Runway_Condition_Rating_4;
	   m_surface_wind_direction   =  m_pWeatherArea4RecordSet->m_Surface_Wind_Direction_4;
	   m_surface_wind_speed       =  m_pWeatherArea4RecordSet->m_Surface_Wind_Speed_4;
	   m_temperature              =  m_pWeatherArea4RecordSet->m_Field_Temperature_F_4;
	   m_turbulence               =  m_pWeatherArea4RecordSet->m_Turbulence_Enable_4;
	   m_upper_clouds_bottom      =  m_pWeatherArea4RecordSet->m_Upper_Cloud_Bottom_4;
	   m_upper_clouds_top         =  m_pWeatherArea4RecordSet->m_Upper_Cloud_Top_4;
	   m_visibility               =  m_pWeatherArea4RecordSet->m_Visibility_sm_4;
	   m_wind_gust_direction      =  m_pWeatherArea4RecordSet->m_Wind_Gust_Variation_4;
	   m_wind_gust_speed          =  m_pWeatherArea4RecordSet->m_Wind_Gust_Speed_4;

	   m_ctrl_upper_clouds_coverage  .SetCurSel(atoi(m_pWeatherArea4RecordSet->m_Upper_Cloud_Type_4));
	   m_ctrl_time_of_day            .SetCurSel(atoi(m_pWeatherArea4RecordSet->m_Time_of_Day_4) - 1);  //Subtracting 1 because variable is 1-based, not zero-based
	   m_ctrl_runway_condition       .SetCurSel(atoi(m_pWeatherArea4RecordSet->m_Runway_Contamination_4));
	   m_ctrl_precipitation_type     .SetCurSel(atoi(m_pWeatherArea4RecordSet->m_Precipitation_Type_4));
	   m_ctrl_precipitation_intensity.SetCurSel(atoi(m_pWeatherArea4RecordSet->m_Precipitation_Intensity_4) - 1);
	   m_ctrl_lower_clouds_coverage  .SetCurSel(atoi(m_pWeatherArea4RecordSet->m_Lower_Cloud_Type_4));
	   m_ctrl_icing_time             .SetCurSel(atoi(m_pWeatherArea4RecordSet->m_Ice_Time_4));
	   m_ctrl_icing_quantity         .SetCurSel(atoi(m_pWeatherArea4RecordSet->m_Ice_Quantity_4));
      m_ctrl_fog_type               .SetCurSel(atoi(m_pWeatherArea4RecordSet->m_Fog_Type_4));
   }

   UpdateData(FALSE);

   return   TRUE; // return TRUE unless you set the focus to a control
	               // EXCEPTION: OCX Property Pages should return FALSE
}

void CWeatherArea4Page::OnOK() 
{
   m_pWeatherArea4RecordSet->Edit();


   m_pWeatherArea4RecordSet->m_Blowing_Contaminant_4     .Format("%d", m_blowing_contamination);
	m_pWeatherArea4RecordSet->m_Cirrus_4                  .Format("%d", m_cirrus               );
	m_pWeatherArea4RecordSet->m_Hail_4                    .Format("%d", m_hail                 );
	m_pWeatherArea4RecordSet->m_Lightning_4               .Format("%d", m_lightning            );
	m_pWeatherArea4RecordSet->m_Scud_4                    .Format("%d", m_scud                 );
	m_pWeatherArea4RecordSet->m_Use_Weather_Area_4        .Format("%d", m_use                  );
	m_pWeatherArea4RecordSet->m_Runway_Skidmarks_4        .Format("%d", m_wet_skid_marks       );

	m_pWeatherArea4RecordSet->m_Active_Airport_4          =  m_airport;
	m_pWeatherArea4RecordSet->m_Field_Pressure_Hg_4       =  m_altimeter;
	m_pWeatherArea4RecordSet->m_Fog_Top_4                 =  m_fog_top;
	m_pWeatherArea4RecordSet->m_Lower_Cloud_Bottom_4      =  m_lower_clouds_bottom;
	m_pWeatherArea4RecordSet->m_Lower_Cloud_Top_4         =  m_lower_clouds_top;
	m_pWeatherArea4RecordSet->m_Weather_Area_Radius_4     =  m_radius;
	m_pWeatherArea4RecordSet->m_Active_Runway_4           =  m_runway;
	m_pWeatherArea4RecordSet->m_Runway_Condition_Rating_4 =  m_runway_conditions_rating;
	m_pWeatherArea4RecordSet->m_Surface_Wind_Direction_4  =  m_surface_wind_direction;
	m_pWeatherArea4RecordSet->m_Surface_Wind_Speed_4      =  m_surface_wind_speed;
	m_pWeatherArea4RecordSet->m_Field_Temperature_F_4     =  m_temperature;
	m_pWeatherArea4RecordSet->m_Turbulence_Enable_4       =  m_turbulence;
	m_pWeatherArea4RecordSet->m_Upper_Cloud_Bottom_4      =  m_upper_clouds_bottom;
	m_pWeatherArea4RecordSet->m_Upper_Cloud_Top_4         =  m_upper_clouds_top;
	m_pWeatherArea4RecordSet->m_Visibility_sm_4           =  m_visibility;
	m_pWeatherArea4RecordSet->m_Wind_Gust_Variation_4     =  m_wind_gust_direction;
	m_pWeatherArea4RecordSet->m_Wind_Gust_Speed_4         =  m_wind_gust_speed;

	m_pWeatherArea4RecordSet->m_Upper_Cloud_Type_4        .Format("%d", m_ctrl_upper_clouds_coverage.GetCurSel());
	m_pWeatherArea4RecordSet->m_Time_of_Day_4             .Format("%d", m_ctrl_time_of_day.GetCurSel() + 1);  // Adding 1 because this var is 1-based, not zero-based
	m_pWeatherArea4RecordSet->m_Runway_Contamination_4    .Format("%d", m_ctrl_runway_condition.GetCurSel());
	m_pWeatherArea4RecordSet->m_Precipitation_Type_4      .Format("%d", m_ctrl_precipitation_type.GetCurSel());
	m_pWeatherArea4RecordSet->m_Precipitation_Intensity_4 .Format("%d", m_ctrl_precipitation_intensity.GetCurSel() + 1);
	m_pWeatherArea4RecordSet->m_Lower_Cloud_Type_4        .Format("%d", m_ctrl_lower_clouds_coverage.GetCurSel());
	m_pWeatherArea4RecordSet->m_Ice_Time_4                .Format("%d", m_ctrl_icing_time.GetCurSel());
	m_pWeatherArea4RecordSet->m_Ice_Quantity_4            .Format("%d", m_ctrl_icing_quantity.GetCurSel());
   m_pWeatherArea4RecordSet->m_Fog_Type_4                .Format("%d", m_ctrl_fog_type.GetCurSel());


   try
   {
      m_pWeatherArea4RecordSet->Update();
   }
   catch (CDaoException *e)
   {
      AfxMessageBox(e->m_pErrorInfo->m_strDescription);
      e->Delete();
      return;
   }

   CPropertyPage::OnOK();
}
