// ThreatControlPage.cpp : implementation file
//
#include "stdafx.h"
#include "sortieedit.h"
#include "ThreatControlPage.h"

#include "GroundHazardTypeRecordSet.h"
#include "ThreatStartPositionRecordSet.h"
#include "ThreatTypeRecordSet.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CThreatControlPage property page

IMPLEMENT_DYNCREATE(CThreatControlPage, CPropertyPage)

CThreatControlPage::CThreatControlPage() : CPropertyPage(CThreatControlPage::IDD)
{
	//{{AFX_DATA_INIT(CThreatControlPage)
	m_display_on_nacws_1 = FALSE;
	m_display_on_nacws_2 = FALSE;
	m_enable_1 = FALSE;
	m_enable_2 = FALSE;
	m_hazard_enable = FALSE;
	m_hazard_pause = FALSE;
	m_bearing_1 = _T("");
	m_bearing_2 = _T("");
	m_distance_1 = _T("");
	m_distance_2 = _T("");
	m_relative_altitude_1 = _T("");
	m_relative_altitude_2 = _T("");
	m_speed_1 = _T("");
	m_speed_2 = _T("");
	m_time_1 = _T("");
	m_time_2 = _T("");
	m_vertical_closure_rate_1 = _T("");
	m_vertical_closure_rate_2 = _T("");
	//}}AFX_DATA_INIT

   m_pThreatsRecordSet  =  new   CThreatsRecordSet(NULL);
}

CThreatControlPage::~CThreatControlPage()
{
   if (m_pThreatsRecordSet->IsOpen())
      m_pThreatsRecordSet->Close();
   delete   m_pThreatsRecordSet;
}

void CThreatControlPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CThreatControlPage)
	DDX_Control(pDX, IDC_COMBO_TYPE_2, m_ctrl_type_2);
	DDX_Control(pDX, IDC_COMBO_TYPE_1, m_ctrl_type_1);
	DDX_Control(pDX, IDC_COMBO_START_POSITION_2, m_ctrl_start_position_2);
	DDX_Control(pDX, IDC_COMBO_START_POSITION_1, m_ctrl_start_position_1);
	DDX_Control(pDX, IDC_COMBO_HAZARD_PATH, m_ctrl_hazard_path);
	DDX_Control(pDX, IDC_COMBO_GROUND_HAZARD_TYPE, m_ctrl_ground_hazard_type);
	DDX_Check(pDX, IDC_CHECK_DISPLAY_ON_NACWS_1, m_display_on_nacws_1);
	DDX_Check(pDX, IDC_CHECK_DISPLAY_ON_NACWS_2, m_display_on_nacws_2);
	DDX_Check(pDX, IDC_CHECK_ENABLE_1, m_enable_1);
	DDX_Check(pDX, IDC_CHECK_ENABLE_2, m_enable_2);
	DDX_Check(pDX, IDC_CHECK_HAZARD_ENABLE, m_hazard_enable);
	DDX_Check(pDX, IDC_CHECK_HAZARD_PAUSE, m_hazard_pause);
	DDX_Text(pDX, IDC_EDIT_BEARING_1, m_bearing_1);
	DDX_Text(pDX, IDC_EDIT_BEARING_2, m_bearing_2);
	DDX_Text(pDX, IDC_EDIT_DISTANCE_1, m_distance_1);
	DDX_Text(pDX, IDC_EDIT_DISTANCE_2, m_distance_2);
	DDX_Text(pDX, IDC_EDIT_RELATIVE_ALTITUDE_1, m_relative_altitude_1);
	DDX_Text(pDX, IDC_EDIT_RELATIVE_ALTITUDE_2, m_relative_altitude_2);
	DDX_Text(pDX, IDC_EDIT_SPEED_1, m_speed_1);
	DDX_Text(pDX, IDC_EDIT_SPEED_2, m_speed_2);
	DDX_Text(pDX, IDC_EDIT_TIME_1, m_time_1);
	DDX_Text(pDX, IDC_EDIT_TIME_2, m_time_2);
	DDX_Text(pDX, IDC_EDIT_VERTICAL_CLOSURE_RATE_1, m_vertical_closure_rate_1);
	DDX_Text(pDX, IDC_EDIT_VERTICAL_CLOSURE_RATE_2, m_vertical_closure_rate_2);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CThreatControlPage, CPropertyPage)
	//{{AFX_MSG_MAP(CThreatControlPage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CThreatControlPage message handlers

BOOL CThreatControlPage::OnInitDialog() 
{
   CPropertyPage::OnInitDialog();

#ifdef   HAF
   CWnd  *pWnd =  GetDlgItem(IDC_CHECK_DISPLAY_ON_NACWS_1);
   pWnd->ShowWindow(SW_HIDE);
   pWnd =  GetDlgItem(IDC_CHECK_DISPLAY_ON_NACWS_2);
   pWnd->ShowWindow(SW_HIDE);
#endif

   // Populate the Start Position ComboBoxes.
   CThreatStartPositionRecordSet *pThreatStartPositionRecordSet   =  new   CThreatStartPositionRecordSet(NULL);
   pThreatStartPositionRecordSet->Open();
   m_ctrl_start_position_1.ResetContent();
   m_ctrl_start_position_2.ResetContent();
   while (! pThreatStartPositionRecordSet->IsEOF())
   {
      m_ctrl_start_position_1.AddString(pThreatStartPositionRecordSet->m_Text);
      m_ctrl_start_position_2.AddString(pThreatStartPositionRecordSet->m_Text);
      pThreatStartPositionRecordSet->MoveNext();
   }
   pThreatStartPositionRecordSet->Close();
   delete   pThreatStartPositionRecordSet;


   // Populate the Threat Type ComboBoxes.
   CThreatTypeRecordSet *pThreatTypeRecordSet   =  new   CThreatTypeRecordSet(NULL);
   pThreatTypeRecordSet->Open();
   m_ctrl_type_1.ResetContent();
   m_ctrl_type_2.ResetContent();
   while (! pThreatTypeRecordSet->IsEOF())
   {
      m_ctrl_type_1.AddString(pThreatTypeRecordSet->m_Text);
      m_ctrl_type_2.AddString(pThreatTypeRecordSet->m_Text);
      pThreatTypeRecordSet->MoveNext();
   }
   pThreatTypeRecordSet->Close();
   delete   pThreatTypeRecordSet;


   // Populate the Hazard Path ComboBox.
   m_ctrl_hazard_path.ResetContent();
   PInfo        m_pathInfo;
   CList <PInfo,PInfo>  m_pathList;
   int nIndex = 0;
   
    CString  fullProfilePath("hazardpaths.ini");
    HKEY  hKey;
    RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\Radio Database\\"), 0, KEY_READ, &hKey);
    if (hKey != NULL)
    {
       CString  strValue;
       DWORD    dwType,  dwCount;

       LONG  lResult  =  RegQueryValueEx(hKey, _T("HazardPathsCustomDataFile"), NULL, &dwType, NULL, &dwCount);
       if (lResult == ERROR_SUCCESS)
       {
          ASSERT(dwType  == REG_SZ);
          lResult  =  RegQueryValueEx(hKey, _T("HazardPathsCustomDataFile"), NULL, &dwType, (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)), &dwCount);
          strValue.ReleaseBuffer();
       }
       fullProfilePath   =  strValue;

       RegCloseKey(hKey);
    }

   long     number_of_paths   =  0;
   int      count =  0;
   char     buffer[2048];
   int      ii, zz;
   char     delimeters[]   =  "=,";
   char     *token;

   count =  GetPrivateProfileSection("HEADER",  buffer,  sizeof(buffer), fullProfilePath);

   for (zz = 0; zz < count; zz++)
   {
      if (buffer[zz] == 0)
         buffer[zz]  =  ',';
   }

   token =  strtok(buffer, delimeters);                                 // Get the first string.
   while (token)
   {
      if (stricmp(token,      "Number of Paths")   == 0)
      {
         token =  strtok(NULL, delimeters);                             // Get the next string.
         number_of_paths   =  atoi(token);
      }
      token =  strtok(NULL, delimeters);                                // Get the next string.
   }

   if (number_of_paths  >  0)
   {
      CString  CStr_paths;

      for (ii = 0; ii < number_of_paths; ii++)
      {
         CStr_paths.Format("Path %d", ii + 1);
         count =  GetPrivateProfileSection(CStr_paths,  buffer,  sizeof(buffer),   fullProfilePath);
         for (int zz = 0; zz < count; zz++)
         {
            if (buffer[zz] == 0)
               buffer[zz]  =  ',';
         }

         bool  got_value = false, got_airport = false, got_name = false;

         token =  strtok(buffer, delimeters);                                 // Get the first string.
         while (token)
         {
            if (stricmp(token, "Value") == 0)
            {
               token =  strtok(NULL, delimeters);                             // Get the next string.
               m_pathInfo.value =  atoi(token);
               got_value                               =  true;
            }
            else if (stricmp(token, "Airport")       == 0)
            {
               token =  strtok(NULL, delimeters);                             // Get the next string.
               m_pathInfo.airport.Format("%s", token);
               got_airport                           =  true;
            }
            else if (stricmp(token, "Name")      == 0)
            {
               token =  strtok(NULL, delimeters);                             // Get the next string.
               m_pathInfo.name.Format("%s", token);
               got_name                          =  true;
            }

            if (got_value && got_airport && got_name)
            {
				m_pathList.AddTail(m_pathInfo);
            }
            token =  strtok(NULL, delimeters);                                // Get the next string.
         }
      }
   }

  // Copy paths to an array, sort, and copy back to path list
   CArray<pInfo,pInfo> tempArray;
   for (int i=0; i < m_pathList.GetCount(); i++)
      tempArray.Add(m_pathList.GetAt(m_pathList.FindIndex(i)));
   std::sort(tempArray.GetData(), tempArray.GetData() + tempArray.GetSize());
   m_pathList.RemoveAll();
   for (int j=0; j < tempArray.GetSize(); j++)
		m_pathList.AddTail(tempArray.GetAt(j));
   tempArray.RemoveAll();
   // Copy sorted path list to ComboBox
   pInfo path;
   for (int k=0; k < m_pathList.GetCount(); k++)
   {
      path = m_pathList.GetAt(m_pathList.FindIndex(k));
      m_ctrl_hazard_path.AddString(path.name);
      m_ctrl_hazard_path.SetItemData(k, path.value);
   }
   m_pathList.RemoveAll();

   //CString str;
   //str.Format("Paths: %d",m_ctrl_hazard_path.GetCount());
   //AfxMessageBox(str);


   // Populate the Ground Hazard Type ComboBox.
   CGroundHazardTypeRecordSet *pGroundHazardTypeRecordSet   =  new   CGroundHazardTypeRecordSet(NULL);
   pGroundHazardTypeRecordSet->Open();
   m_ctrl_ground_hazard_type.ResetContent();
   while (! pGroundHazardTypeRecordSet->IsEOF())
   {
      m_ctrl_ground_hazard_type.AddString(pGroundHazardTypeRecordSet->m_Text);
      pGroundHazardTypeRecordSet->MoveNext();
   }
   pGroundHazardTypeRecordSet->Close();
   delete   pGroundHazardTypeRecordSet;



   if (! m_pThreatsRecordSet->IsOpen())
   {
      try
      {
         m_pThreatsRecordSet->Open();
      }
      catch(CDaoException  *e)
      {
         AfxMessageBox(e->m_pErrorInfo->m_strDescription);
         e->Delete();
         return   TRUE;
      }
   }

   BOOL  found =  m_pThreatsRecordSet->Find(AFX_DAO_FIRST, m_condition_for_find);
   if (found)
   {
	

      int nPathSel = 0;

      for (int nIndex = 0; nIndex < m_ctrl_hazard_path.GetCount(); nIndex++)
      {
         if (m_ctrl_hazard_path.GetItemData(nIndex) == (unsigned long)atol(m_pThreatsRecordSet->m_Ground_Hazard_Path))
         {
            nPathSel = nIndex;
            break;
         }
      }


	   m_ctrl_hazard_path         .SetCurSel(nPathSel);
      m_ctrl_ground_hazard_type  .SetCurSel(atoi(m_pThreatsRecordSet->m_Ground_Hazard_Vehicle_Type));
	   m_ctrl_start_position_1    .SetCurSel(atoi(m_pThreatsRecordSet->m_Threat_1_Vertical_Start_Position));
	   m_ctrl_start_position_2    .SetCurSel(atoi(m_pThreatsRecordSet->m_Threat_2_Vertical_Start_Position));
	   m_ctrl_type_1              .SetCurSel(atoi(m_pThreatsRecordSet->m_Threat_1_Aircraft_Type));
	   m_ctrl_type_2              .SetCurSel(atoi(m_pThreatsRecordSet->m_Threat_2_Aircraft_Type));

	   m_display_on_nacws_1       =  (m_pThreatsRecordSet->m_Threat_1_Display_on_NACWS  == "1");
	   m_display_on_nacws_2       =  (m_pThreatsRecordSet->m_Threat_2_Display_on_NACWS  == "1");
	   m_enable_1                 =  (m_pThreatsRecordSet->m_Threat_1_Enable            == "1");
	   m_enable_2                 =  (m_pThreatsRecordSet->m_Threat_2_Enable            == "1");
	   m_hazard_enable            =  (m_pThreatsRecordSet->m_Ground_Hazard_Enable       == "1");
	   m_hazard_pause             =  (m_pThreatsRecordSet->m_Ground_Hazard_Pause        == "1");
	   
      m_bearing_1                =  m_pThreatsRecordSet->m_Threat_1_Bearing;
	   m_bearing_2                =  m_pThreatsRecordSet->m_Threat_2_Bearing;
	   m_distance_1               =  m_pThreatsRecordSet->m_Threat_1_Distance;
	   m_distance_2               =  m_pThreatsRecordSet->m_Threat_2_Distance;
	   m_relative_altitude_1      =  m_pThreatsRecordSet->m_Threat_1_Relative_Altitude;
	   m_relative_altitude_2      =  m_pThreatsRecordSet->m_Threat_2_Relative_Altitude;
	   m_speed_1                  =  m_pThreatsRecordSet->m_Threat_1_Speed;
	   m_speed_2                  =  m_pThreatsRecordSet->m_Threat_2_Speed;
	   m_time_1                   =  m_pThreatsRecordSet->m_Threat_1_Time;
	   m_time_2                   =  m_pThreatsRecordSet->m_Threat_2_Time;
	   m_vertical_closure_rate_1  =  m_pThreatsRecordSet->m_Threat_1_Vertical_Closure_Rate;
	   m_vertical_closure_rate_2  =  m_pThreatsRecordSet->m_Threat_2_Vertical_Closure_Rate;
   }

   UpdateData(FALSE);


   return   TRUE; // return TRUE unless you set the focus to a control
	               // EXCEPTION: OCX Property Pages should return FALSE
}

void CThreatControlPage::OnOK() 
{
   m_pThreatsRecordSet->Edit();
	m_pThreatsRecordSet->m_Ground_Hazard_Vehicle_Type        .Format("%d", m_ctrl_ground_hazard_type.GetCurSel());
	m_pThreatsRecordSet->m_Ground_Hazard_Path                .Format("%lu",(unsigned long)(m_ctrl_hazard_path.GetItemData(m_ctrl_hazard_path.GetCurSel())));
	m_pThreatsRecordSet->m_Threat_1_Vertical_Start_Position  .Format("%d", m_ctrl_start_position_1.GetCurSel());
	m_pThreatsRecordSet->m_Threat_2_Vertical_Start_Position  .Format("%d", m_ctrl_start_position_2.GetCurSel());
	m_pThreatsRecordSet->m_Threat_1_Aircraft_Type            .Format("%d", m_ctrl_type_1.GetCurSel());
	m_pThreatsRecordSet->m_Threat_2_Aircraft_Type            .Format("%d", m_ctrl_type_2.GetCurSel());

	m_pThreatsRecordSet->m_Threat_1_Display_on_NACWS         .Format("%d", m_display_on_nacws_1);
	m_pThreatsRecordSet->m_Threat_2_Display_on_NACWS         .Format("%d", m_display_on_nacws_2);
	m_pThreatsRecordSet->m_Threat_1_Enable                   .Format("%d", m_enable_1          );
	m_pThreatsRecordSet->m_Threat_2_Enable                   .Format("%d", m_enable_2          );
	m_pThreatsRecordSet->m_Ground_Hazard_Enable              .Format("%d", m_hazard_enable     );
	m_pThreatsRecordSet->m_Ground_Hazard_Pause               .Format("%d", m_hazard_pause      );
	   
   m_pThreatsRecordSet->m_Threat_1_Bearing                  =  m_bearing_1;
	m_pThreatsRecordSet->m_Threat_2_Bearing                  =  m_bearing_2;
	m_pThreatsRecordSet->m_Threat_1_Distance                 =  m_distance_1;
	m_pThreatsRecordSet->m_Threat_2_Distance                 =  m_distance_2;
	m_pThreatsRecordSet->m_Threat_1_Relative_Altitude        =  m_relative_altitude_1;
	m_pThreatsRecordSet->m_Threat_2_Relative_Altitude        =  m_relative_altitude_2;
	m_pThreatsRecordSet->m_Threat_1_Speed                    =  m_speed_1;
	m_pThreatsRecordSet->m_Threat_2_Speed                    =  m_speed_2;
	m_pThreatsRecordSet->m_Threat_1_Time                     =  m_time_1;
	m_pThreatsRecordSet->m_Threat_2_Time                     =  m_time_2;
	m_pThreatsRecordSet->m_Threat_1_Vertical_Closure_Rate    =  m_vertical_closure_rate_1;
	m_pThreatsRecordSet->m_Threat_2_Vertical_Closure_Rate    =  m_vertical_closure_rate_2;


   try
   {
      m_pThreatsRecordSet->Update();
   }
   catch (CDaoException *e)
   {
      AfxMessageBox(e->m_pErrorInfo->m_strDescription);
      e->Delete();
      return;
   }

   CPropertyPage::OnOK();
}
