// SymbolDisplayPage.cpp : implementation file
//

#include "stdafx.h"
#include "sortieedit.h"
#include "SymbolDisplayPage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSymbolDisplayPage property page

IMPLEMENT_DYNCREATE(CSymbolDisplayPage, CPropertyPage)

CSymbolDisplayPage::CSymbolDisplayPage() : CPropertyPage(CSymbolDisplayPage::IDD)
{
	//{{AFX_DATA_INIT(CSymbolDisplayPage)
	m_airport = FALSE;
	m_airport_ident = FALSE;
	m_ils = FALSE;
	m_ils_ident_freq = FALSE;
	m_jet_routes = FALSE;
	m_lat_lon_grid = FALSE;
	m_lead_ac_track = FALSE;
	m_markers = FALSE;
	m_mouse_lat_lon = FALSE;
	m_ndb = FALSE;
	m_ndb_ident_freq = FALSE;
	m_victor_routes = FALSE;
	m_vor = FALSE;
	m_vor_ident_freq = FALSE;
	m_waypoints = FALSE;
	m_weather_areas = FALSE;
	m_wing_ac_track = FALSE;
	m_decimal_degrees = FALSE;
	m_line = FALSE;
	m_line_text = FALSE;
	m_obstacle = FALSE;
	m_obstacle_text = FALSE;
	m_practice_area = FALSE;
	m_practice_area_text = FALSE;
	//}}AFX_DATA_INIT

   m_pSymbolDisplayRecordSet  =  new   CSymbolDisplayRecordSet(NULL);
}


CSymbolDisplayPage::~CSymbolDisplayPage()
{
   if (m_pSymbolDisplayRecordSet->IsOpen())
      m_pSymbolDisplayRecordSet->Close();
   delete   m_pSymbolDisplayRecordSet;
}

void CSymbolDisplayPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSymbolDisplayPage)
	DDX_Check(pDX, IDC_CHECK_AIRPORT, m_airport);
	DDX_Check(pDX, IDC_CHECK_AIRPORT_IDENT, m_airport_ident);
	DDX_Check(pDX, IDC_CHECK_ILS, m_ils);
	DDX_Check(pDX, IDC_CHECK_ILS_IDENT_FREQ, m_ils_ident_freq);
	DDX_Check(pDX, IDC_CHECK_JET_ROUTES, m_jet_routes);
	DDX_Check(pDX, IDC_CHECK_LAT_LON_GRID, m_lat_lon_grid);
	DDX_Check(pDX, IDC_CHECK_LEAD_AC_TRACK, m_lead_ac_track);
	DDX_Check(pDX, IDC_CHECK_MARKERS, m_markers);
	DDX_Check(pDX, IDC_CHECK_MOUSE_LAT_LON, m_mouse_lat_lon);
	DDX_Check(pDX, IDC_CHECK_NDB, m_ndb);
	DDX_Check(pDX, IDC_CHECK_NDB_IDENT_FREQ, m_ndb_ident_freq);
	DDX_Check(pDX, IDC_CHECK_VICTOR_ROUTES, m_victor_routes);
	DDX_Check(pDX, IDC_CHECK_VOR, m_vor);
	DDX_Check(pDX, IDC_CHECK_VOR_IDENT_FREQ, m_vor_ident_freq);
	DDX_Check(pDX, IDC_CHECK_WAYPOINTS, m_waypoints);
	DDX_Check(pDX, IDC_CHECK_WEATHER_AREAS, m_weather_areas);
	DDX_Check(pDX, IDC_CHECK_WING_AC_TRACK, m_wing_ac_track);
	DDX_Check(pDX, IDC_CHECK_DECIMAL_DEGREES, m_decimal_degrees);
	DDX_Check(pDX, IDC_CHECK_LINE, m_line);
	DDX_Check(pDX, IDC_CHECK_LINE_TEXT, m_line_text);
	DDX_Check(pDX, IDC_CHECK_OBSTACLE, m_obstacle);
	DDX_Check(pDX, IDC_CHECK_OBSTACLE_TEXT, m_obstacle_text);
	DDX_Check(pDX, IDC_CHECK_PRACTICE_AREA, m_practice_area);
	DDX_Check(pDX, IDC_CHECK_PRACTICE_AREA_TEXT, m_practice_area_text);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSymbolDisplayPage, CPropertyPage)
	//{{AFX_MSG_MAP(CSymbolDisplayPage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSymbolDisplayPage message handlers

BOOL CSymbolDisplayPage::OnInitDialog() 
{
   if (! m_pSymbolDisplayRecordSet->IsOpen())
   {
      try
      {
         m_pSymbolDisplayRecordSet->Open();
      }
      catch(CDaoException  *e)
      {
         AfxMessageBox(e->m_pErrorInfo->m_strDescription);
         e->Delete();
         return   TRUE;
      }
   }

   BOOL  found =  m_pSymbolDisplayRecordSet->Find(AFX_DAO_FIRST, m_condition_for_find);
   if (found)
   {
      m_airport            =  (m_pSymbolDisplayRecordSet->m_Symbol_Display_Airports          == "1");
	   m_airport_ident      =  (m_pSymbolDisplayRecordSet->m_Symbol_Display_Airport_Text      == "1");
	   m_ils                =  (m_pSymbolDisplayRecordSet->m_Symbol_Display_ILS               == "1");
	   m_ils_ident_freq     =  (m_pSymbolDisplayRecordSet->m_Symbol_Display_ILS_Text          == "1");
	   m_jet_routes         =  (m_pSymbolDisplayRecordSet->m_Symbol_Display_Jet_Routes        == "1");
	   m_lat_lon_grid       =  (m_pSymbolDisplayRecordSet->m_Symbol_Display_LatLon_Grid       == "1");
	   m_lead_ac_track      =  (m_pSymbolDisplayRecordSet->m_Symbol_Display_Lead_Aircraft     == "1");
	   m_markers            =  (m_pSymbolDisplayRecordSet->m_Symbol_Display_Markers           == "1");
	   m_mouse_lat_lon      =  (m_pSymbolDisplayRecordSet->m_Symbol_Display_Mouse_LatLon      == "1");
	   m_ndb                =  (m_pSymbolDisplayRecordSet->m_Symbol_Display_NDB               == "1");
	   m_ndb_ident_freq     =  (m_pSymbolDisplayRecordSet->m_Symbol_Display_NDB_Text          == "1");
	   m_victor_routes      =  (m_pSymbolDisplayRecordSet->m_Symbol_Display_Victor_Routes     == "1");
	   m_vor                =  (m_pSymbolDisplayRecordSet->m_Symbol_Display_VOR               == "1");
	   m_vor_ident_freq     =  (m_pSymbolDisplayRecordSet->m_Symbol_Display_VOR_Text          == "1");
	   m_waypoints          =  (m_pSymbolDisplayRecordSet->m_Symbol_Display_Waypoints         == "1");
	   m_weather_areas      =  (m_pSymbolDisplayRecordSet->m_Symbol_Display_Weather_Areas     == "1");
	   m_wing_ac_track      =  (m_pSymbolDisplayRecordSet->m_Symbol_Display_Wing_Aircraft     == "1");
      m_decimal_degrees    =  (m_pSymbolDisplayRecordSet->m_Symbol_Display_Decimal_Degrees   == "1");
      m_line               =  (m_pSymbolDisplayRecordSet->m_Symbol_Display_Lines             == "1");
      m_line_text          =  (m_pSymbolDisplayRecordSet->m_Symbol_Display_Lines_Text        == "1");
      m_obstacle           =  (m_pSymbolDisplayRecordSet->m_Symbol_Display_Obstacles         == "1");
      m_obstacle_text      =  (m_pSymbolDisplayRecordSet->m_Symbol_Display_Obstacles_Text    == "1");
      m_practice_area      =  (m_pSymbolDisplayRecordSet->m_Symbol_Display_Practice_Areas    == "1");
      m_practice_area_text =  (m_pSymbolDisplayRecordSet->m_Symbol_Display_Practice_Areas_T  == "1");
   }

   CPropertyPage::OnInitDialog();
	
   return TRUE;   // return TRUE unless you set the focus to a control
	               // EXCEPTION: OCX Property Pages should return FALSE
}

void CSymbolDisplayPage::OnOK() 
{
   m_pSymbolDisplayRecordSet->Edit();

   m_pSymbolDisplayRecordSet->m_Symbol_Display_Airports        .Format("%d", m_airport       );
	m_pSymbolDisplayRecordSet->m_Symbol_Display_Airport_Text    .Format("%d", m_airport_ident );
	m_pSymbolDisplayRecordSet->m_Symbol_Display_ILS             .Format("%d", m_ils           );
	m_pSymbolDisplayRecordSet->m_Symbol_Display_ILS_Text        .Format("%d", m_ils_ident_freq);
	m_pSymbolDisplayRecordSet->m_Symbol_Display_Jet_Routes      .Format("%d", m_jet_routes    );
	m_pSymbolDisplayRecordSet->m_Symbol_Display_LatLon_Grid     .Format("%d", m_lat_lon_grid  );
	m_pSymbolDisplayRecordSet->m_Symbol_Display_Lead_Aircraft   .Format("%d", m_lead_ac_track );
	m_pSymbolDisplayRecordSet->m_Symbol_Display_Markers         .Format("%d", m_markers       );
	m_pSymbolDisplayRecordSet->m_Symbol_Display_Mouse_LatLon    .Format("%d", m_mouse_lat_lon );
	m_pSymbolDisplayRecordSet->m_Symbol_Display_NDB             .Format("%d", m_ndb           );
	m_pSymbolDisplayRecordSet->m_Symbol_Display_NDB_Text        .Format("%d", m_ndb_ident_freq);
	m_pSymbolDisplayRecordSet->m_Symbol_Display_Victor_Routes   .Format("%d", m_victor_routes );
	m_pSymbolDisplayRecordSet->m_Symbol_Display_VOR             .Format("%d", m_vor           );
	m_pSymbolDisplayRecordSet->m_Symbol_Display_VOR_Text        .Format("%d", m_vor_ident_freq);
	m_pSymbolDisplayRecordSet->m_Symbol_Display_Waypoints       .Format("%d", m_waypoints     );
	m_pSymbolDisplayRecordSet->m_Symbol_Display_Weather_Areas   .Format("%d", m_weather_areas );
	m_pSymbolDisplayRecordSet->m_Symbol_Display_Wing_Aircraft   .Format("%d", m_wing_ac_track );
   m_pSymbolDisplayRecordSet->m_Symbol_Display_Decimal_Degrees .Format("%d",  m_decimal_degrees);
   m_pSymbolDisplayRecordSet->m_Symbol_Display_Lines           .Format("%d",  m_line); 
   m_pSymbolDisplayRecordSet->m_Symbol_Display_Lines_Text      .Format("%d",  m_line_text);
   m_pSymbolDisplayRecordSet->m_Symbol_Display_Obstacles       .Format("%d",  m_obstacle);       
   m_pSymbolDisplayRecordSet->m_Symbol_Display_Obstacles_Text  .Format("%d",  m_obstacle_text);
   m_pSymbolDisplayRecordSet->m_Symbol_Display_Practice_Areas  .Format("%d",  m_practice_area);   
   m_pSymbolDisplayRecordSet->m_Symbol_Display_Practice_Areas_T.Format("%d",  m_practice_area_text);

   try
   {
      m_pSymbolDisplayRecordSet->Update();
   }
   catch (CDaoException *e)
   {
      AfxMessageBox(e->m_pErrorInfo->m_strDescription);
      e->Delete();
      return;
   }

   CPropertyPage::OnOK();
}
