// SortieEditView.h : interface of the CSortieEditView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_SORTIEEDITVIEW_H__9966AE35_672E_11D4_AE2F_006008B0E0C3__INCLUDED_)
#define AFX_SORTIEEDITVIEW_H__9966AE35_672E_11D4_AE2F_006008B0E0C3__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "..\sortiefiles\SortieRecordSet.h"

class CBasesRecordSet;

class CSortieEditView : public CDaoRecordView
{
protected: // create from serialization only
	CSortieEditView();
	DECLARE_DYNCREATE(CSortieEditView)

public:
	//{{AFX_DATA(CSortieEditView)
	enum { IDD = IDD_SORTIEEDIT_FORM };
	CComboBox	m_ctrl_lesson;
	CComboBox	m_ctrl_base;
	CBasesRecordSet* m_pSet;
	CString	m_base_description;
	CString	m_lesson_description;
	//}}AFX_DATA

// Attributes
public:
	CSortieEditDoc* GetDocument();

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSortieEditView)
	public:
	virtual CDaoRecordset* OnGetRecordset();
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual void OnInitialUpdate(); // called first time after construct
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CSortieEditView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
   CString  m_condition_for_find;
   CString  m_base;
   CString  m_lesson;
   CSortieRecordSet  *m_pSortieSet;

   void     AddBase(void);
   void     AddLesson(void);
   void     UpdateLessonCombo(void);

   bool     m_auto_exit_mode;

// Generated message map functions
protected:
	//{{AFX_MSG(CSortieEditView)
	afx_msg void OnDefaultButton();
	afx_msg void OnButtonAddEdit();
	afx_msg void OnSelchangeBasesCombo();
	afx_msg void OnDblclkBasesCombo();
	afx_msg void OnButtonDeleteBase();
	afx_msg void OnButtonDeleteLesson();
	afx_msg void OnSelchangeComboLesson();
	afx_msg void OnDblclkComboLesson();
	afx_msg void OnFileOpen();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in SortieEditView.cpp
inline CSortieEditDoc* CSortieEditView::GetDocument()
   { return (CSortieEditDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SORTIEEDITVIEW_H__9966AE35_672E_11D4_AE2F_006008B0E0C3__INCLUDED_)
