// SortieEditView.cpp : implementation of the CSortieEditView class
//

#include "stdafx.h"
#include "SortieEdit.h"
#include "mainfrm.h"

#include "..\sortiefiles\BasesRecordSet.h"
#include "..\sortiefiles\SortieDbName.h"
#include "SortieEditDoc.h"
#include "SortieEditView.h"

#include "ConfigurationPage.h"
#include "GlobalWeatherPage.h"
#include "MapSettingsPage.h"
#include "RepositionPage.h"
#include "SymbolDisplayPage.h"
#include "ThreatControlPage.h"
#include "WeatherArea1Page.h"
#include "WeatherArea2Page.h"
#include "WeatherArea3Page.h"
#include "WeatherArea4Page.h"
#include "MalfunctionsPage.h"
#include "RecordedFilesPage.h"

#include "AddBase.h"
#include "AddLesson.h"
#include "EditableRecordSets.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSortieEditView

IMPLEMENT_DYNCREATE(CSortieEditView, CDaoRecordView)

BEGIN_MESSAGE_MAP(CSortieEditView, CDaoRecordView)
	//{{AFX_MSG_MAP(CSortieEditView)
	ON_BN_CLICKED(IDC_DEFAULT_BUTTON, OnDefaultButton)
	ON_BN_CLICKED(IDC_BUTTON_ADD_EDIT, OnButtonAddEdit)
	ON_CBN_SELCHANGE(IDC_BASES_COMBO, OnSelchangeBasesCombo)
	ON_CBN_DBLCLK(IDC_BASES_COMBO, OnDblclkBasesCombo)
	ON_BN_CLICKED(IDC_BUTTON_DELETE_BASE, OnButtonDeleteBase)
	ON_BN_CLICKED(IDC_BUTTON_DELETE_LESSON, OnButtonDeleteLesson)
	ON_CBN_SELCHANGE(IDC_COMBO_LESSON, OnSelchangeComboLesson)
	ON_CBN_DBLCLK(IDC_COMBO_LESSON, OnDblclkComboLesson)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSortieEditView construction/destruction

CSortieEditView::CSortieEditView()
	: CDaoRecordView(CSortieEditView::IDD)
{
	//{{AFX_DATA_INIT(CSortieEditView)
   m_pSet = NULL;
	m_base_description = _T("");
	m_lesson_description = _T("");
	//}}AFX_DATA_INIT
	// TODO: add construction code here

   m_pSortieSet   =  new   CSortieRecordSet(NULL);

   if (! m_pSortieSet->IsOpen())
   {
      try
      {
         m_pSortieSet->Open();
      }
      catch(CDaoException  *e)
      {
         AfxMessageBox(e->m_pErrorInfo->m_strDescription);
         e->Delete();
         return;
      }
   }
   m_auto_exit_mode  =  false;
}

CSortieEditView::~CSortieEditView()
{
   if (m_pSortieSet->IsOpen())
      m_pSortieSet->Close();
   delete   m_pSortieSet;
}

void CSortieEditView::DoDataExchange(CDataExchange* pDX)
{
	CDaoRecordView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSortieEditView)
	DDX_Control(pDX, IDC_COMBO_LESSON, m_ctrl_lesson);
	DDX_Control(pDX, IDC_BASES_COMBO, m_ctrl_base);
	DDX_Text(pDX, IDC_STATIC_BASE_DESCRIPTION, m_base_description);
	DDX_Text(pDX, IDC_STATIC_LESSON_DESCRIPTION, m_lesson_description);
	//}}AFX_DATA_MAP
}

BOOL CSortieEditView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CDaoRecordView::PreCreateWindow(cs);
}

void CSortieEditView::OnInitialUpdate()
{
   m_pSet   =  &GetDocument()->m_basesRecordSet;

   CDaoRecordView::OnInitialUpdate();

   m_ctrl_lesson.ResetContent();
   m_ctrl_lesson.AddString("Add New");
   m_ctrl_base.ResetContent();
   m_ctrl_base.AddString("Add New");

   while (! m_pSet->IsEOF())
   {
      m_ctrl_base.AddString(m_pSet->m_Base_ID);
      m_pSet->MoveNext();
   }

   GetParentFrame()->RecalcLayout();
   ResizeParentToFit();

   CSortieEditApp *pApp =  (CSortieEditApp *)AfxGetApp();
   if (pApp)
   {
      CString  base(pApp->GetBase());
      CString  lesson(pApp->GetLesson());

      if (!base.IsEmpty()  && !lesson.IsEmpty())
         m_auto_exit_mode  =  true;

      m_ctrl_base.SelectString(-1, base);       // Select the requested base...
      OnSelchangeBasesCombo();                  // update the list of lessons at the selected base
      m_ctrl_lesson.SelectString(-1, lesson);   // select the requested lesson
      OnSelchangeComboLesson();                 // update the desciption
      OnButtonAddEdit();                        // Edit it.
   }

   m_ctrl_base.SetFocus();
}

/////////////////////////////////////////////////////////////////////////////
// CSortieEditView diagnostics

#ifdef _DEBUG
void CSortieEditView::AssertValid() const
{
	CDaoRecordView::AssertValid();
}

void CSortieEditView::Dump(CDumpContext& dc) const
{
	CDaoRecordView::Dump(dc);
}

CSortieEditDoc* CSortieEditView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CSortieEditDoc)));
	return (CSortieEditDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSortieEditView database support
CDaoRecordset* CSortieEditView::OnGetRecordset()
{
   return   m_pSet;
}


/////////////////////////////////////////////////////////////////////////////
// CSortieEditView message handlers

void CSortieEditView::OnDefaultButton() 
{
   // Determine base name from text of current selection.
   int   index =  m_ctrl_base.GetCurSel();
   if (index   == CB_ERR)     // Nothing selected so go to next field.
   {
      CWnd  *pwndCtrlNext  =  GetNextDlgTabItem(GetFocus());
      pwndCtrlNext->SetFocus();
      return;
   }
   m_ctrl_base.GetLBText(index, m_base);
	if (m_base  == "Add New")
   {
      AddBase();
      return;
   }


   // Determine lesson name from text of current selection.
   index       =  m_ctrl_lesson.GetCurSel();
   if (index   == CB_ERR)     // Nothing selected so go to next field.
   {
      CWnd  *pwndCtrlNext  =  GetNextDlgTabItem(GetFocus());
      pwndCtrlNext->SetFocus();
      return;
   }
   m_ctrl_lesson.GetLBText(index, m_lesson);


	if (m_lesson == "Add New")
   {
      AddLesson();
      return;
   }

   CWnd  *pwndCtrlNext  =  GetNextDlgTabItem(GetFocus());
   pwndCtrlNext->SetFocus();
}


void CSortieEditView::OnButtonAddEdit() 
{
   // Determine base name from text of current selection.
   int   index =  m_ctrl_base.GetCurSel();
   if (index   == CB_ERR)
      return;
   m_ctrl_base.GetLBText(index, m_base);

	if (m_base  == "Add New")
   {
      AddBase();
   }

   // Determine lesson name from text of current selection.
   index       =  m_ctrl_lesson.GetCurSel();
   if (index   == CB_ERR)
      return;
   m_ctrl_lesson.GetLBText(index, m_lesson);

	if (m_lesson == "Add New")
   {
      AddLesson();
   }

   if (m_base.IsEmpty() || m_lesson.IsEmpty())
   {
      AfxMessageBox("Either a Base or Lesson was not selected");
      return;
   }

   // Place currently selected base and lesson into an INI file so that FTD Planning app knows what sortie was edited.
   CString  strFullProfilePath("C:\\winnt\\temp\\sortiedata.ini");
   WritePrivateProfileString("SortieData", "Base",    m_base,     strFullProfilePath);
   WritePrivateProfileString("SortieData", "Lesson",  m_lesson,   strFullProfilePath);


   m_condition_for_find.Format("[Base ID] = '%s' AND [Lesson ID] = '%s'", m_base, m_lesson);

   CPropertySheet    propertySheet;
   CString           title;
   title.Format("Lesson: %s at %s", m_lesson, m_base);
   propertySheet.SetTitle(title, 0);
   propertySheet.EnableStackedTabs(FALSE);

   CConfigurationPage   configurationPage;
   configurationPage.m_condition_for_find =  m_condition_for_find;
   propertySheet.AddPage(&configurationPage);

   CGlobalWeatherPage   globalWeatherPage;
   globalWeatherPage.m_condition_for_find =  m_condition_for_find;
   propertySheet.AddPage(&globalWeatherPage);

   CMapSettingsPage  mapSettingsPage;
   mapSettingsPage.m_condition_for_find   =  m_condition_for_find;
   propertySheet.AddPage(&mapSettingsPage);

   CRepositionPage   repositionPage;
   repositionPage.m_condition_for_find    =  m_condition_for_find;
   propertySheet.AddPage(&repositionPage);

   CSymbolDisplayPage   symbolDisplayPage;
   symbolDisplayPage.m_condition_for_find =  m_condition_for_find;
   propertySheet.AddPage(&symbolDisplayPage);

   CThreatControlPage   threatControlPage;
   threatControlPage.m_condition_for_find =  m_condition_for_find;
   propertySheet.AddPage(&threatControlPage);

   CWeatherArea1Page weatherArea1Page;
   weatherArea1Page.m_condition_for_find  =  m_condition_for_find;
   propertySheet.AddPage(&weatherArea1Page);

   CWeatherArea2Page weatherArea2Page;
   weatherArea2Page.m_condition_for_find  =  m_condition_for_find;
   propertySheet.AddPage(&weatherArea2Page);

   CWeatherArea3Page weatherArea3Page;
   weatherArea3Page.m_condition_for_find  =  m_condition_for_find;
   propertySheet.AddPage(&weatherArea3Page);

   CWeatherArea4Page weatherArea4Page;
   weatherArea4Page.m_condition_for_find  =  m_condition_for_find;
   propertySheet.AddPage(&weatherArea4Page);

   CRecordedFilesPage recordedFilesPage;
   recordedFilesPage.m_condition_for_find  =  m_condition_for_find;
   propertySheet.AddPage(&recordedFilesPage);

   CMalfunctionsPage malfunctionsPage;
   malfunctionsPage.m_condition_for_find  =  m_condition_for_find;
   propertySheet.AddPage(&malfunctionsPage);

   if (propertySheet.DoModal()   == IDOK)
   {
   }

   if (m_auto_exit_mode)
   {
      PostQuitMessage(0);
   }
}


void CSortieEditView::OnSelchangeBasesCombo() 
{
   // Determine base name from text of current selection.
   int   index =  m_ctrl_base.GetCurSel();
   if (index   == CB_ERR)
      return;
   m_ctrl_base.GetLBText(index, m_base);

	if (m_base  == "Add New")
   {
      m_base_description   =  m_base;
      UpdateData(FALSE);
   }
   else  // base exists so look-up lesson
   {
      // Update the description of the Base and blank out the decription of the Lesson.
      CString  condition;
      condition.Format("[Base ID] = '%s'", m_base);
      BOOL  found =  m_pSet->Find(AFX_DAO_FIRST, condition);
      m_base_description   =  m_pSet->m_Base_Name;
      m_lesson_description =  "";
      UpdateData(FALSE);

      UpdateLessonCombo();
   }
}


void CSortieEditView::OnSelchangeComboLesson() 
{
   // Determine lesson name from text of current selection.
   int   index =  m_ctrl_lesson.GetCurSel();
   if (index   == CB_ERR)
      return;
   m_ctrl_lesson.GetLBText(index, m_lesson);

   if (m_lesson   == "Add New")
   {
      m_lesson_description =  m_lesson;
      UpdateData(FALSE);
   }
   else
   {
      CString  condition;
      condition.Format("[Base ID] = '%s' AND [Lesson ID] = '%s'", m_base, m_lesson);
      BOOL  found =  m_pSortieSet->Find(AFX_DAO_FIRST, condition);
      if (found)
      {
         m_lesson_description =  m_pSortieSet->m_Sortie_Description;
         UpdateData(FALSE);
      }
   }
}


void CSortieEditView::OnDblclkBasesCombo() 
{
   // Determine base name from text of current selection.
   int   index =  m_ctrl_base.GetCurSel();
   if (index   == CB_ERR)
      return;
   m_ctrl_base.GetLBText(index, m_base);

	if (m_base  == "Add New")
   {
      AddBase();
   }
}


void CSortieEditView::OnDblclkComboLesson() 
{
   // Determine lesson name from text of current selection.
   int   index =  m_ctrl_lesson.GetCurSel();
   if (index   == CB_ERR)
      return;
   m_ctrl_lesson.GetLBText(index, m_lesson);

	if (m_lesson == "Add New")
   {
      AddLesson();
   }
   else
   {  
      // Enable double-clicking the lesson to begin editing
      OnButtonAddEdit();
   }
}


void CSortieEditView::OnButtonDeleteBase() 
{
   // Determine base name from text of current selection.
   int   index =  m_ctrl_base.GetCurSel();
   if (index   == CB_ERR)
      return;
   m_ctrl_base.GetLBText(index, m_base);

   CString  message;
   message.Format("%s is about to be deleted.\nDo you wish to proceed?", m_base);
   if (AfxMessageBox(message, MB_YESNO)   == IDNO)
      return;

   CString  condition;
   condition.Format("[Base ID] = '%s'", m_base);
   BOOL  found =  m_pSet->Find(AFX_DAO_FIRST, condition);
 
   if (found)
   {
      try
      {
         m_pSet->Delete();
      }
      catch (CDaoException *e)
      {
         AfxMessageBox(e->m_pErrorInfo->m_strDescription);
         e->Delete();
      }

      m_pSet->Requery();
      m_ctrl_base.ResetContent();
      m_ctrl_base.AddString("Add New");
      while (! m_pSet->IsEOF())
      {
         m_ctrl_base.AddString(m_pSet->m_Base_ID);
         m_pSet->MoveNext();
      }

      m_base_description   =  "";
      m_ctrl_lesson.ResetContent();
      m_ctrl_lesson.AddString("Add New");
      m_lesson_description =  "";
      UpdateData(FALSE);
   }
}


void CSortieEditView::OnButtonDeleteLesson() 
{
   CString  message;
   message.Format("%s at %s is about to be deleted.\nDo you wish to proceed?", m_lesson, m_base);
   if (AfxMessageBox(message, MB_YESNO)   == IDNO)
      return;

   CEditableRecordSets  editableRecordSets;
   editableRecordSets.m_base                 =  m_base;
   editableRecordSets.m_lesson_title         =  m_lesson;
   editableRecordSets.m_lesson_description   =  m_lesson_description;
   editableRecordSets.Delete();

   m_pSortieSet->Requery();

   UpdateLessonCombo();
}


void  CSortieEditView::AddBase(void)
{
   CAddBase addBase;
   addBase.m_pBasesRecordSet  =  m_pSet;

   if (addBase.DoModal()   == IDOK)
   {
   }

   m_pSet->Requery();
   m_ctrl_base.ResetContent();
   m_ctrl_base.AddString("Add New");
   while (! m_pSet->IsEOF())
   {
      m_ctrl_base.AddString(m_pSet->m_Base_ID);
      m_pSet->MoveNext();
   }
   m_ctrl_base.SelectString(-1, addBase.m_base_ident);
   m_base               =  addBase.m_base_ident;
   m_base_description   =  addBase.m_base_description;
   UpdateData(FALSE);
}


void  CSortieEditView::AddLesson(void)
{
   CAddLesson addLesson;
   addLesson.m_pSortieSet  =  m_pSortieSet;
   addLesson.m_base        =  m_base;

   if (addLesson.DoModal()   == IDOK)
   {
   }

   UpdateLessonCombo();
   m_ctrl_lesson.SelectString(-1, addLesson.m_lesson_title);
   m_lesson             =  addLesson.m_lesson_title;
   m_lesson_description =  addLesson.m_lesson_description;
   UpdateData(FALSE);
}


void  CSortieEditView::UpdateLessonCombo(void)
{
   BOOL     found;
   CString  condition;

   m_ctrl_lesson.ResetContent();
   m_ctrl_lesson.AddString("Add New");

   condition.Format("[Base ID] = '%s'", m_base);
   try
   {
      found =  m_pSortieSet->Find(AFX_DAO_FIRST, condition);
   }
   catch(CDaoException  *e)
   {
      AfxMessageBox(e->m_pErrorInfo->m_strDescription);
      e->Delete();
      return;
   }

   while (! m_pSortieSet->IsEOF()   && found)
   {
      m_ctrl_lesson.AddString(m_pSortieSet->m_Lesson_ID);
      try
      {
         found =  m_pSortieSet->FindNext(condition);
      }
      catch(CDaoException  *e)
      {
         AfxMessageBox(e->m_pErrorInfo->m_strDescription);
         e->Delete();
         return;
      }
   }
}


void CSortieEditView::OnFileOpen() 
{
   CFileDialog cfd(TRUE, NULL, NULL, OFN_SHAREAWARE | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY, "All Files (*.*)|*.*||", this);

   long  int   lRetVal     =  cfd.DoModal();

   if (lRetVal == IDOK)
   {
      CSortieDbName::SetDefaultDBName(cfd.GetPathName());

      GetParentFrame()->SetTitle(CSortieDbName::GetDefaultDBName());

      OnInitialUpdate();
   }
	
}
