// FSISuiteCommmandLineInfo.cpp: implementation of the CFSISuiteCommmandLineInfo class.
//
//////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include <afxdao.h>			// MFC DAO database classes
#include "SortieEditCommandLineInfo.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
CSortieEditCommandLineInfo::CSortieEditCommandLineInfo() :
   m_base_found(false),
   m_lesson_found(false),
   m_CStr_base(""),
   m_CStr_lesson(""),
   m_version_found(false),
   m_CStr_version("")
{
   m_pDatabaseVersionRecordSet   =  new   CDatabaseVersionRecordSet(NULL);

   if (! m_pDatabaseVersionRecordSet->IsOpen())
   {
      try
      {
         m_pDatabaseVersionRecordSet->Open();
      }
      catch(CDaoException  *e)
      {
         AfxMessageBox(e->m_pErrorInfo->m_strDescription);
         e->Delete();
         return;
      }
   }
}

CSortieEditCommandLineInfo::~CSortieEditCommandLineInfo()
{
   if (m_pDatabaseVersionRecordSet->IsOpen())
      m_pDatabaseVersionRecordSet->Close();
   delete   m_pDatabaseVersionRecordSet;
}


void CSortieEditCommandLineInfo::ParseParam(LPCTSTR pszParam, BOOL bFlag, BOOL bLast)
{   
   if (bFlag   && stricmp(pszParam, "Base")  == 0)
   {
      m_base_found         =  true;
   }
   else if (m_base_found   && !bFlag)
   {
      m_CStr_base          =  CString(pszParam);
      m_base_found         =  false;
   }
   else if (bFlag && stricmp(pszParam, "Lesson")   == 0)
   {
      m_lesson_found       =  true;
   }
   else if (m_lesson_found && !bFlag)
   {
      m_CStr_lesson        =  CString(pszParam);
      m_lesson_found       =  false;
   }
   else if (bFlag && stricmp(pszParam, "Version")   == 0)
   {
      m_version_found      =  true;
   }
   else if (m_version_found   && !bFlag)
   {
      m_CStr_version       =  CString(pszParam);
      m_version_found      =  false;

      m_pDatabaseVersionRecordSet->MoveFirst();
      m_pDatabaseVersionRecordSet->Edit();
	   m_pDatabaseVersionRecordSet->m_Version =  m_CStr_version;

      try
      {
         m_pDatabaseVersionRecordSet->Update();
      }
      catch (CDaoException *e)
      {
         AfxMessageBox(e->m_pErrorInfo->m_strDescription);
         e->Delete();
         return;
      }
   }
   else
   {
      CCommandLineInfo::ParseParam (pszParam, bFlag, bLast);
   }
}

CString CSortieEditCommandLineInfo::GetBase()
{
   return   m_CStr_base;
}

CString CSortieEditCommandLineInfo::GetLesson()
{
   return   m_CStr_lesson;
}

CString CSortieEditCommandLineInfo::GetDatabaseVersion()
{
	m_CStr_version =  m_pDatabaseVersionRecordSet->m_Version;

   return   m_CStr_version;
}
