// SortieEdit.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "SortieEdit.h"

#include "MainFrm.h"
#include "SortieEditDoc.h"
#include "SortieEditView.h"
#include "SortieEditCommandLineInfo.h"
#include "..\fsisuite\product_version.h"

static   LPCTSTR  lpszWindowName    =  _T("Sortie Editor");

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSortieEditApp

BEGIN_MESSAGE_MAP(CSortieEditApp, CWinApp)
	//{{AFX_MSG_MAP(CSortieEditApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSortieEditApp construction

CSortieEditApp::CSortieEditApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CSortieEditApp object

CSortieEditApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CSortieEditApp initialization

BOOL CSortieEditApp::InitInstance()
{
   // Exit if already running.
   // NOTE:  This is kind of flaky, in that it will only work if the
   //        lpszWindowName has been properly set up above to match
   //        the dialog window name
   if (!FirstInstance())
      return FALSE;

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// Change the registry key under which our settings are stored.
	// TODO: You should modify this string to be something appropriate
	// such as the name of your company or organization.
	SetRegistryKey(_T("Local AppWizard-Generated Applications"));

	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	CSingleDocTemplate* pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CSortieEditDoc),
		RUNTIME_CLASS(CMainFrame),       // main SDI frame window
		RUNTIME_CLASS(CSortieEditView));
	AddDocTemplate(pDocTemplate);

	// Parse command line for standard shell commands, DDE, file open
	CSortieEditCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

   m_CStr_base             =  cmdInfo.GetBase();
   m_CStr_lesson           =  cmdInfo.GetLesson();
   m_CStr_database_version =  cmdInfo.GetDatabaseVersion();

	// Dispatch commands specified on the command line
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	// The one and only window has been initialized, so show and update it.
	m_pMainWnd->ShowWindow(SW_SHOW);
	m_pMainWnd->UpdateWindow();

	return TRUE;
}


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CString	m_CStr_version;
	CString	m_CStr_DatabaseVersion;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	m_CStr_version = _T("");
	m_CStr_DatabaseVersion = _T("");
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Text(pDX, IDC_VERSION, m_CStr_version);
	DDX_Text(pDX, IDC_DATABASE_VERSION, m_CStr_DatabaseVersion);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CSortieEditApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
   aboutDlg.m_CStr_DatabaseVersion.Format("Database Version:  %s", m_CStr_database_version);
	aboutDlg.DoModal();
}

BOOL CAboutDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
   m_CStr_version.Format("%s - %s", lpszWindowName, BUILD_NUMBER);

   UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

/////////////////////////////////////////////////////////////////////////////
// CSortieEditApp message handlers

CString CSortieEditApp::GetBase()
{
   return   m_CStr_base;
}

CString CSortieEditApp::GetLesson()
{
   return   m_CStr_lesson;
}

bool  CSortieEditApp::FirstInstance()
{
   CWnd  *pWndPrev,  *pWndChild;
 
   pWndPrev    =  CWnd::FindWindow(NULL,  NULL);
   bool  found =  false;

   while (pWndPrev   && !found)
   {
      CString  title;
      pWndPrev->GetWindowText(title);

      if (!title.IsEmpty())
      {
         if (title.Find(lpszWindowName) != -1)
         {
            found =  true;
            break;
         }
      }
      pWndPrev =  pWndPrev->GetNextWindow(GW_HWNDNEXT);
   }

   if (found)
   {
      // if so, does it have any popups?
      pWndChild   =  pWndPrev->GetLastActivePopup();
 
      // If iconic, restore the main window
      if (pWndPrev->IsIconic())
         pWndPrev->ShowWindow(SW_RESTORE);
 
      // Bring the main window or its popup to the foreground
      pWndChild->SetForegroundWindow();
 
      // and we are done activating the previous one.
      return   false;
   }
   else   // First instance. Proceed as normal.
      return   true;
}

