// RepositionPage.cpp : implementation file
//

#include "stdafx.h"
#include "sortieedit.h"
#include "RepositionPage.h"
#include "RepositionSelectRecordSet.h"
#include "FormationSelectRecordSet.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRepositionPage property page

IMPLEMENT_DYNCREATE(CRepositionPage, CPropertyPage)

CRepositionPage::CRepositionPage() : CPropertyPage(CRepositionPage::IDD)
{
	//{{AFX_DATA_INIT(CRepositionPage)
	m_airspeed = _T("");
	m_altitude = _T("");
	m_heading = _T("");
	m_latitude = _T("");
	m_longitude = _T("");
	m_navaid_distance = _T("");
	m_navaid_id = _T("");
	m_navaid_radial = _T("");
	m_active_airport = _T("");
	m_active_runway = _T("");
	//}}AFX_DATA_INIT

   m_pRepositionRecordSet  =  new   CRepositionRecordSet(NULL);
}

CRepositionPage::~CRepositionPage()
{
   if (m_pRepositionRecordSet->IsOpen())
      m_pRepositionRecordSet->Close();
   delete   m_pRepositionRecordSet;
}

void CRepositionPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRepositionPage)
	DDX_Control(pDX, IDC_COMBO_FORMATION, m_ctrl_formation);
	DDX_Control(pDX, IDC_COMBO_REPOSITIONS, m_ctrl_reposition);
	DDX_Text(pDX, IDC_EDIT_AIRSPEED, m_airspeed);
	DDX_Text(pDX, IDC_EDIT_ALTITUDE, m_altitude);
	DDX_Text(pDX, IDC_EDIT_HEADING, m_heading);
	DDX_Text(pDX, IDC_EDIT_LATITUDE, m_latitude);
	DDX_Text(pDX, IDC_EDIT_LONGITUDE, m_longitude);
	DDX_Text(pDX, IDC_EDIT_NAVAID_DISTANCE, m_navaid_distance);
	DDX_Text(pDX, IDC_EDIT_NAVAID_ID, m_navaid_id);
	DDX_Text(pDX, IDC_EDIT_NAVAID_RADIAL, m_navaid_radial);
	DDX_Text(pDX, IDC_EDIT_ACTIVE_AIRPORT, m_active_airport);
	DDX_Text(pDX, IDC_EDIT_ACTIVE_RUNWAY, m_active_runway);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CRepositionPage, CPropertyPage)
	//{{AFX_MSG_MAP(CRepositionPage)
	ON_CBN_SELCHANGE(IDC_COMBO_REPOSITIONS, OnSelchangeComboRepositions)
	ON_EN_MAXTEXT(IDC_EDIT_LATITUDE, OnMaxtextEditLatitude)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRepositionPage message handlers

BOOL CRepositionPage::OnInitDialog() 
{
   CPropertyPage::OnInitDialog();

   // Populate the Reposition Type ComboBox.
   CRepositionSelectRecordSet *pRepositionSelectRecordSet   =  new   CRepositionSelectRecordSet(NULL);
   pRepositionSelectRecordSet->Open();
   m_ctrl_reposition.ResetContent();
   while (! pRepositionSelectRecordSet->IsEOF())
   {
      m_ctrl_reposition.AddString(pRepositionSelectRecordSet->m_Text);
      pRepositionSelectRecordSet->MoveNext();
   }
   pRepositionSelectRecordSet->Close();
   delete   pRepositionSelectRecordSet;


   // Populate the Formation Type ComboBox
   CFormationSelectRecordSet  *pFormationSelectRecordSet =  new   CFormationSelectRecordSet(NULL);
   pFormationSelectRecordSet->Open();
   m_ctrl_formation.ResetContent();
   while (! pFormationSelectRecordSet->IsEOF())
   {
      m_ctrl_formation.AddString(pFormationSelectRecordSet->m_Text);
      pFormationSelectRecordSet->MoveNext();
   }
   pFormationSelectRecordSet->Close();
   delete   pFormationSelectRecordSet;



   if (! m_pRepositionRecordSet->IsOpen())
   {
      try
      {
         m_pRepositionRecordSet->Open();
      }
      catch(CDaoException  *e)
      {
         AfxMessageBox(e->m_pErrorInfo->m_strDescription);
         e->Delete();
         return   TRUE;
      }
   }

   int   reposition_type   =  0;
   int   formation_type    =  0;
   BOOL  found =  m_pRepositionRecordSet->Find(AFX_DAO_FIRST, m_condition_for_find);
   if (found)
   {
	   m_airspeed        =  m_pRepositionRecordSet->m_Reposition_Airspeed;
	   m_altitude        =  m_pRepositionRecordSet->m_Reposition_Altitude_MSL;
	   m_heading         =  m_pRepositionRecordSet->m_Reposition_Heading;
	   m_latitude        =  m_pRepositionRecordSet->m_Reposition_Latitude;
	   m_longitude       =  m_pRepositionRecordSet->m_Reposition_Longitude;
	   m_navaid_distance =  m_pRepositionRecordSet->m_Reposition_Navaid_Distance;
	   m_navaid_id       =  m_pRepositionRecordSet->m_Reposition_Navaid_ID;
	   m_navaid_radial   =  m_pRepositionRecordSet->m_Reposition_Navaid_Radial;

      reposition_type   =  atoi(m_pRepositionRecordSet->m_Reposition_Command);
      m_ctrl_reposition.SetCurSel(reposition_type);

      formation_type    =  atoi(m_pRepositionRecordSet->m_Formation_Command);
      m_ctrl_formation.SetCurSel(formation_type);

	   m_active_airport  =  m_pRepositionRecordSet->m_Active_Airport;
	   m_active_runway   =  m_pRepositionRecordSet->m_Active_Runway;
   }

   EnableFields(reposition_type);

   UpdateData(FALSE);


   return   TRUE; // return TRUE unless you set the focus to a control
	               // EXCEPTION: OCX Property Pages should return FALSE
}

void CRepositionPage::OnOK() 
{
   m_pRepositionRecordSet->Edit();

	m_pRepositionRecordSet->m_Reposition_Airspeed            =  m_airspeed;
	m_pRepositionRecordSet->m_Reposition_Altitude_MSL        =  m_altitude;
	m_pRepositionRecordSet->m_Reposition_Heading             =  m_heading;
	m_pRepositionRecordSet->m_Reposition_Latitude            =  m_latitude;
	m_pRepositionRecordSet->m_Reposition_Longitude           =  m_longitude;
	m_pRepositionRecordSet->m_Reposition_Navaid_Distance     =  m_navaid_distance;
	m_pRepositionRecordSet->m_Reposition_Navaid_ID           =  m_navaid_id;
	m_pRepositionRecordSet->m_Reposition_Navaid_Radial       =  m_navaid_radial;
   m_pRepositionRecordSet->m_Reposition_Command.Format("%d",   m_ctrl_reposition.GetCurSel());
   m_pRepositionRecordSet->m_Formation_Command.Format("%d",    m_ctrl_formation.GetCurSel());
	m_pRepositionRecordSet->m_Active_Airport                 =  m_active_airport;
	m_pRepositionRecordSet->m_Active_Runway                  =  m_active_runway;


   try
   {
      m_pRepositionRecordSet->Update();
   }
   catch (CDaoException *e)
   {
      AfxMessageBox(e->m_pErrorInfo->m_strDescription);
      e->Delete();
      return;
   }

	CPropertyPage::OnOK();
}


void  CRepositionPage::EnableFields(long type)
{
   switch (type)
   {
      case  0:    // NONE
         GetDlgItem(IDC_EDIT_AIRSPEED        )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_ALTITUDE        )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_HEADING         )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_LATITUDE        )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_LONGITUDE       )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_NAVAID_ID       )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_NAVAID_DISTANCE )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_NAVAID_RADIAL   )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_ACTIVE_AIRPORT  )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_ACTIVE_RUNWAY   )->EnableWindow(FALSE);
         GetDlgItem(IDC_COMBO_FORMATION      )->EnableWindow(FALSE);
         break;

      case  20:   // Latitude / Longitude
         GetDlgItem(IDC_EDIT_AIRSPEED        )->EnableWindow(TRUE);
         GetDlgItem(IDC_EDIT_ALTITUDE        )->EnableWindow(TRUE);
         GetDlgItem(IDC_EDIT_HEADING         )->EnableWindow(TRUE);
         GetDlgItem(IDC_EDIT_LATITUDE        )->EnableWindow(TRUE);
         GetDlgItem(IDC_EDIT_LONGITUDE       )->EnableWindow(TRUE);
         GetDlgItem(IDC_EDIT_NAVAID_ID       )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_NAVAID_DISTANCE )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_NAVAID_RADIAL   )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_ACTIVE_AIRPORT  )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_ACTIVE_RUNWAY   )->EnableWindow(FALSE);
         GetDlgItem(IDC_COMBO_FORMATION      )->EnableWindow(FALSE);
         break;

      case  21:   // NAVAID / Distance / Radial
         GetDlgItem(IDC_EDIT_AIRSPEED        )->EnableWindow(TRUE);
         GetDlgItem(IDC_EDIT_ALTITUDE        )->EnableWindow(TRUE);
         GetDlgItem(IDC_EDIT_HEADING         )->EnableWindow(TRUE);
         GetDlgItem(IDC_EDIT_LATITUDE        )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_LONGITUDE       )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_NAVAID_ID       )->EnableWindow(TRUE);
         GetDlgItem(IDC_EDIT_NAVAID_DISTANCE )->EnableWindow(TRUE);
         GetDlgItem(IDC_EDIT_NAVAID_RADIAL   )->EnableWindow(TRUE);
         GetDlgItem(IDC_EDIT_ACTIVE_AIRPORT  )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_ACTIVE_RUNWAY   )->EnableWindow(FALSE);
         GetDlgItem(IDC_COMBO_FORMATION      )->EnableWindow(FALSE);
         break;

      case  22:   // Formation
         GetDlgItem(IDC_EDIT_AIRSPEED        )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_ALTITUDE        )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_HEADING         )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_LATITUDE        )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_LONGITUDE       )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_NAVAID_ID       )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_NAVAID_DISTANCE )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_NAVAID_RADIAL   )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_ACTIVE_AIRPORT  )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_ACTIVE_RUNWAY   )->EnableWindow(FALSE);
         GetDlgItem(IDC_COMBO_FORMATION      )->EnableWindow(TRUE);
         break;

      default:    // Relative to Active Airport and Active Runway
         GetDlgItem(IDC_EDIT_AIRSPEED        )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_ALTITUDE        )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_HEADING         )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_LATITUDE        )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_LONGITUDE       )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_NAVAID_ID       )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_NAVAID_DISTANCE )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_NAVAID_RADIAL   )->EnableWindow(FALSE);
         GetDlgItem(IDC_EDIT_ACTIVE_AIRPORT  )->EnableWindow(TRUE);
         GetDlgItem(IDC_EDIT_ACTIVE_RUNWAY   )->EnableWindow(TRUE);
         GetDlgItem(IDC_COMBO_FORMATION      )->EnableWindow(FALSE);
         break;
   }
}

void CRepositionPage::OnSelchangeComboRepositions() 
{
   int   type  =  m_ctrl_reposition.GetCurSel();
   if (type == CB_ERR)
      return;

   EnableFields(type);
}

void CRepositionPage::OnMaxtextEditLatitude() 
{
	// TODO: Add your control notification handler code here
	
}
