// MapSettingsPage.cpp : implementation file
//

#include "stdafx.h"
#include "SortieEdit.h"
#include "MapSettingsPage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMapSettingsPage property page

IMPLEMENT_DYNCREATE(CMapSettingsPage, CPropertyPage)

CMapSettingsPage::CMapSettingsPage() : CPropertyPage(CMapSettingsPage::IDD)
{
	//{{AFX_DATA_INIT(CMapSettingsPage)
	m_approach_plot_scale = _T("");
	m_area_map_scale = _T("");
	m_center_airport_id = _T("");
	m_center_spider_web_airport_id = _T("");
	m_auto_scale = FALSE;
	m_map_center_option = -1;
	m_center_spider_web_navaid_id = _T("");
	m_spider_web_center_option = -1;
	m_geochart_init_data = _T("");
	//}}AFX_DATA_INIT

   m_pAreaMapRecordSet  =  new   CAreaMapRecordSet(NULL);
}

CMapSettingsPage::~CMapSettingsPage()
{
   if (m_pAreaMapRecordSet->IsOpen())
      m_pAreaMapRecordSet->Close();
   delete   m_pAreaMapRecordSet;
}

void CMapSettingsPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMapSettingsPage)
	DDX_Text(pDX, IDC_EDIT_APPROACH_PLOT_SCALE, m_approach_plot_scale);
	DDX_Radio(pDX, IDC_RADIO_MAP_CENTER_AUTO, m_map_center_option);
	DDX_Check(pDX, IDC_CHECK_AUTO_SCALE, m_auto_scale);
	DDX_Text(pDX, IDC_EDIT_CENTER_AIRPORT_ID, m_center_airport_id);
	DDX_Text(pDX, IDC_EDIT_AREA_MAP_SCALE, m_area_map_scale);
	DDX_Text(pDX, IDC_EDIT_CENTER_SPIDER_WEB_AIRPORT_ID, m_center_spider_web_airport_id);
	DDV_MaxChars(pDX, m_center_spider_web_airport_id, 4);
	DDX_Text(pDX, IDC_EDIT_CENTER_SPIDER_WEB_NAVAID_ID, m_center_spider_web_navaid_id);
	DDV_MaxChars(pDX, m_center_spider_web_navaid_id, 3);
	DDX_Radio(pDX, IDC_RADIO_SPIDER_WEB_OFF, m_spider_web_center_option);
	DDX_Text(pDX, IDC_EDIT_GEOCHART_INIT_DATA, m_geochart_init_data);
	DDV_MaxChars(pDX, m_geochart_init_data, 255);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMapSettingsPage, CPropertyPage)
	//{{AFX_MSG_MAP(CMapSettingsPage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMapSettingsPage message handlers

BOOL CMapSettingsPage::OnInitDialog() 
{
   if (! m_pAreaMapRecordSet->IsOpen())
   {
      try
      {
         m_pAreaMapRecordSet->Open();
      }
      catch(CDaoException  *e)
      {
         AfxMessageBox(e->m_pErrorInfo->m_strDescription);
         e->Delete();
         return   TRUE;
      }
   }

   BOOL  found =  m_pAreaMapRecordSet->Find(AFX_DAO_FIRST, m_condition_for_find);
   if (found)
   {
      m_approach_plot_scale                                       =  m_pAreaMapRecordSet->m_Approach_Plot_Scale;
      m_area_map_scale                                            =  m_pAreaMapRecordSet->m_Area_Map_Scale;
      
      if (m_pAreaMapRecordSet->m_Area_Map_Auto_Scale              == "1")
         m_auto_scale                                             =  TRUE;
      else
         m_auto_scale                                             =  FALSE;

      if (m_pAreaMapRecordSet->m_Area_Map_Center_Airport_ID       == "    ")
         m_center_airport_id                                      =  m_pAreaMapRecordSet->m_Base_ID;
      else
         m_center_airport_id                                      =  m_pAreaMapRecordSet->m_Area_Map_Center_Airport_ID;

      if (m_pAreaMapRecordSet->m_Area_Map_Spider_Web_Airport_ID   == "    ")
         m_center_spider_web_airport_id                           =  m_center_airport_id;
      else
         m_center_spider_web_airport_id                           =  m_pAreaMapRecordSet->m_Area_Map_Spider_Web_Airport_ID;

      m_center_spider_web_navaid_id                               =  m_pAreaMapRecordSet->m_Area_Map_Spider_Web_Navaid_ID;

      if (m_pAreaMapRecordSet->m_Area_Map_Auto_Center             == "1")
         m_map_center_option                                      =  0;
      else if (m_pAreaMapRecordSet->m_Area_Map_Center_On_Aircraft == "1")
         m_map_center_option                                      =  1;
      else if (m_pAreaMapRecordSet->m_Area_Map_Center_On_Airport  == "1")
         m_map_center_option                                      =  2;

      if (m_pAreaMapRecordSet->m_Area_Map_Spider_Web_Type         == "0")
         m_spider_web_center_option                               =  0;
      else if (m_pAreaMapRecordSet->m_Area_Map_Spider_Web_Type    == "1")
         m_spider_web_center_option                               =  1;
      else if (m_pAreaMapRecordSet->m_Area_Map_Spider_Web_Type    == "3")
         m_spider_web_center_option                               =  2;
      else if (m_pAreaMapRecordSet->m_Area_Map_Spider_Web_Type    == "4")
         m_spider_web_center_option                               =  3;
      else if (m_pAreaMapRecordSet->m_Area_Map_Spider_Web_Type    == "5")
         m_spider_web_center_option                               =  4;
		 
	 m_geochart_init_data = m_pAreaMapRecordSet->m_GeoChart_Init_Data;
   }


	CPropertyPage::OnInitDialog();
   
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CMapSettingsPage::OnOK() 
{
   m_pAreaMapRecordSet->Edit();

   m_pAreaMapRecordSet->m_Approach_Plot_Scale                  =  m_approach_plot_scale;
   m_pAreaMapRecordSet->m_Area_Map_Scale                       =  m_area_map_scale;
   
   if (m_auto_scale                                            == TRUE)
      m_pAreaMapRecordSet->m_Area_Map_Auto_Scale               =  "1";
   else
      m_pAreaMapRecordSet->m_Area_Map_Auto_Scale               =  "0";

   m_pAreaMapRecordSet->m_Area_Map_Center_Airport_ID           =  m_center_airport_id;
   m_pAreaMapRecordSet->m_Area_Map_Spider_Web_Airport_ID       =  m_center_spider_web_airport_id;
   m_pAreaMapRecordSet->m_Area_Map_Spider_Web_Navaid_ID        =  m_center_spider_web_navaid_id;

   switch (m_map_center_option)
   {
      case  0:
         m_pAreaMapRecordSet->m_Area_Map_Auto_Center           =  "1";
         m_pAreaMapRecordSet->m_Area_Map_Center_On_Aircraft    =  "0";
         m_pAreaMapRecordSet->m_Area_Map_Center_On_Airport     =  "0";
         break;

      case  1:
         m_pAreaMapRecordSet->m_Area_Map_Auto_Center           =  "0";
         m_pAreaMapRecordSet->m_Area_Map_Center_On_Aircraft    =  "1";
         m_pAreaMapRecordSet->m_Area_Map_Center_On_Airport     =  "0";
         break;

      case  2:
         m_pAreaMapRecordSet->m_Area_Map_Auto_Center           =  "0";
         m_pAreaMapRecordSet->m_Area_Map_Center_On_Aircraft    =  "0";
         m_pAreaMapRecordSet->m_Area_Map_Center_On_Airport     =  "1";
         break;
   }

   switch   (m_spider_web_center_option)
   {
      case  0:
         m_pAreaMapRecordSet->m_Area_Map_Spider_Web_Type       =  "0";
         break;

      case  1:
         m_pAreaMapRecordSet->m_Area_Map_Spider_Web_Type       =  "1";
         break;

      case  2:
         m_pAreaMapRecordSet->m_Area_Map_Spider_Web_Type       =  "3";
         break;

      case  3:
         m_pAreaMapRecordSet->m_Area_Map_Spider_Web_Type       =  "4";
         break;

      case  4:
         m_pAreaMapRecordSet->m_Area_Map_Spider_Web_Type       =  "5";
         break;
   }

   m_pAreaMapRecordSet->m_GeoChart_Init_Data                   = m_geochart_init_data;

   try
   {
      m_pAreaMapRecordSet->Update();
   }
   catch (CDaoException *e)
   {
      AfxMessageBox(e->m_pErrorInfo->m_strDescription);
      e->Delete();
      return;
   }
   
	CPropertyPage::OnOK();
}
