// MalfunctionsPage.cpp : implementation file
//

#include "stdafx.h"
#include "sortieedit.h"
#include "MalfunctionsPage.h"
#include "MalfPreselectTypeRecordSet.h"
#include "MalfPreselectOperatorRecordSet.h"
#include "MalfPreselectBooleanRecordSet.h"
#include "MalfDocRecordSet.h"
#include "MalfListItem.h"
#include "MalfDescriptionDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMalfunctionsPage property page


IMPLEMENT_DYNCREATE(CMalfunctionsPage, CPropertyPage)

CMalfunctionsPage::CMalfunctionsPage() : CPropertyPage(CMalfunctionsPage::IDD)
 {
 	//{{AFX_DATA_INIT(CMalfunctionsPage)
 	m_malf_1_presel_1_value = _T("");
 	m_malf_1_presel_2_value = _T("");
 	m_malf_2_presel_1_value = _T("");
 	m_malf_2_presel_2_value = _T("");
 	m_malf_3_presel_1_value = _T("");
 	m_malf_3_presel_2_value = _T("");
 	m_malf_1_presel_status = -1;
 	m_malf_2_presel_status = -1;
 	m_malf_3_presel_status = -1;
	//}}AFX_DATA_INIT
 
    m_pMalfunctionsRecordSet = new CMalfunctionsRecordSet(NULL);
 }


CMalfunctionsPage::~CMalfunctionsPage()
{
   if (m_pMalfunctionsRecordSet->IsOpen())
      m_pMalfunctionsRecordSet->Close();
   delete   m_pMalfunctionsRecordSet;
}


void CMalfunctionsPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMalfunctionsPage)
	DDX_Control(pDX, IDC_MALF3_COMBO, m_malf_3_combo);
	DDX_Control(pDX, IDC_MALF2_COMBO, m_malf_2_combo);
	DDX_Control(pDX, IDC_MALF1_COMBO, m_malf_1_combo);
	DDX_Control(pDX, IDC_PRESELECT_COMBO_3_3, m_malf_3_presel_logical);
	DDX_Control(pDX, IDC_PRESELECT_COMBO_3_2, m_malf_3_presel_1_operator);
	DDX_Control(pDX, IDC_PRESELECT_COMBO_2_5, m_malf_2_presel_2_operator);
	DDX_Control(pDX, IDC_PRESELECT_COMBO_2_3, m_malf_2_presel_logical);
	DDX_Control(pDX, IDC_PRESELECT_COMBO_2_2, m_malf_2_presel_1_operator);
	DDX_Control(pDX, IDC_PRESELECT_COMBO_1_5, m_malf_1_presel_2_operator);
	DDX_Control(pDX, IDC_PRESELECT_COMBO_1_3, m_malf_1_presel_logical);
	DDX_Control(pDX, IDC_PRESELECT_COMBO_1_2, m_malf_1_presel_1_operator);
	DDX_Control(pDX, IDC_PRESELECT_COMBO_3_4, m_malf_3_presel_2_type);
	DDX_Control(pDX, IDC_PRESELECT_COMBO_3_5, m_malf_3_presel_2_operator);
	DDX_Control(pDX, IDC_PRESELECT_COMBO_3_1, m_malf_3_presel_1_type);
	DDX_Control(pDX, IDC_PRESELECT_COMBO_2_4, m_malf_2_presel_2_type);
	DDX_Control(pDX, IDC_PRESELECT_COMBO_2_1, m_malf_2_presel_1_type);
	DDX_Control(pDX, IDC_PRESELECT_COMBO_1_4, m_malf_1_presel_2_type);
	DDX_Control(pDX, IDC_PRESELECT_COMBO_1_1, m_malf_1_presel_1_type);
	DDX_Text(pDX, IDC_PRESELECT_EDIT_1_1, m_malf_1_presel_1_value);
	DDX_Text(pDX, IDC_PRESELECT_EDIT_1_2, m_malf_1_presel_2_value);
	DDX_Text(pDX, IDC_PRESELECT_EDIT_2_1, m_malf_2_presel_1_value);
	DDX_Text(pDX, IDC_PRESELECT_EDIT_2_2, m_malf_2_presel_2_value);
	DDX_Text(pDX, IDC_PRESELECT_EDIT_3_1, m_malf_3_presel_1_value);
	DDX_Text(pDX, IDC_PRESELECT_EDIT_3_2, m_malf_3_presel_2_value);
	DDX_Radio(pDX, IDC_MALF_RADIO_1_1, m_malf_1_presel_status);
	DDX_Radio(pDX, IDC_MALF_RADIO_2_1, m_malf_2_presel_status);
	DDX_Radio(pDX, IDC_MALF_RADIO_3_1, m_malf_3_presel_status);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMalfunctionsPage, CPropertyPage)
	//{{AFX_MSG_MAP(CMalfunctionsPage)
	ON_BN_CLICKED(IDC_MALF_RADIO_1_1, OnMalfRadio11)
	ON_BN_CLICKED(IDC_MALF_RADIO_1_2, OnMalfRadio11)
	ON_BN_CLICKED(IDC_MALF_RADIO_1_3, OnMalfRadio11)
	ON_BN_CLICKED(IDC_MALF_RADIO_2_1, OnMalfRadio21)
	ON_BN_CLICKED(IDC_MALF_RADIO_2_2, OnMalfRadio21)
	ON_BN_CLICKED(IDC_MALF_RADIO_2_3, OnMalfRadio21)
	ON_BN_CLICKED(IDC_MALF_RADIO_3_1, OnMalfRadio31)
	ON_BN_CLICKED(IDC_MALF_RADIO_3_2, OnMalfRadio31)
   ON_BN_CLICKED(IDC_MALF_RADIO_3_3, OnMalfRadio31)
	ON_CBN_SELCHANGE(IDC_PRESELECT_COMBO_1_3, OnMalfRadio11)
	ON_CBN_SELCHANGE(IDC_PRESELECT_COMBO_2_3, OnMalfRadio21)
	ON_CBN_SELCHANGE(IDC_PRESELECT_COMBO_3_3, OnMalfRadio31)
	ON_BN_CLICKED(IDC_DESCRIBE_BUTTON_1, OnDescribeButton1)
	ON_BN_CLICKED(IDC_DESCRIBE_BUTTON_2, OnDescribeButton2)
	ON_BN_CLICKED(IDC_DESCRIBE_BUTTON_3, OnDescribeButton3)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMalfunctionsPage message handlers

BOOL CMalfunctionsPage::OnInitDialog() 
{
   if (! m_pMalfunctionsRecordSet->IsOpen())
   {
      try
      {
         m_pMalfunctionsRecordSet->Open();
      }
      catch(CDaoException  *e)
      {
         AfxMessageBox(e->m_pErrorInfo->m_strDescription);
         e->Delete();
         return   TRUE;
      }
   }

   BOOL  found =  m_pMalfunctionsRecordSet->Find(AFX_DAO_FIRST, m_condition_for_find);

   if (found)
   {	
	CPropertyPage::OnInitDialog();

   m_malf_1_presel_status = atoi(m_pMalfunctionsRecordSet->m_Malfunction_1_Activation);
   m_malf_2_presel_status = atoi(m_pMalfunctionsRecordSet->m_Malfunction_2_Activation);
   m_malf_3_presel_status = atoi(m_pMalfunctionsRecordSet->m_Malfunction_3_Activation);

   m_MalfArray.RemoveAll();

   m_malf_1_combo.ResetContent();
   m_malf_1_presel_1_type.ResetContent();
   m_malf_1_presel_2_type.ResetContent();
   m_malf_1_presel_1_operator.ResetContent();
   m_malf_1_presel_2_operator.ResetContent();
   m_malf_1_presel_logical.ResetContent();

   m_malf_2_combo.ResetContent();
   m_malf_2_presel_1_type.ResetContent();
   m_malf_2_presel_2_type.ResetContent();
   m_malf_2_presel_1_operator.ResetContent();
   m_malf_2_presel_2_operator.ResetContent();
   m_malf_2_presel_logical.ResetContent();

   m_malf_3_combo.ResetContent();
   m_malf_3_presel_1_type.ResetContent();
   m_malf_3_presel_2_type.ResetContent();
   m_malf_3_presel_1_operator.ResetContent();
   m_malf_3_presel_2_operator.ResetContent();
   m_malf_3_presel_logical.ResetContent();


   CMalfPreselectTypeRecordSet  *pMalfPreselectTypeRecordSet =  new  CMalfPreselectTypeRecordSet(NULL);
   pMalfPreselectTypeRecordSet->Open();

   while (! pMalfPreselectTypeRecordSet->IsEOF())
   {
      m_malf_1_presel_1_type.AddString(pMalfPreselectTypeRecordSet->m_Preselect_Type);
      m_malf_1_presel_2_type.AddString(pMalfPreselectTypeRecordSet->m_Preselect_Type);
      m_malf_2_presel_1_type.AddString(pMalfPreselectTypeRecordSet->m_Preselect_Type);
      m_malf_2_presel_2_type.AddString(pMalfPreselectTypeRecordSet->m_Preselect_Type);
      m_malf_3_presel_1_type.AddString(pMalfPreselectTypeRecordSet->m_Preselect_Type);
      m_malf_3_presel_2_type.AddString(pMalfPreselectTypeRecordSet->m_Preselect_Type);

      pMalfPreselectTypeRecordSet->MoveNext();
   }
   pMalfPreselectTypeRecordSet->Close();
   delete   pMalfPreselectTypeRecordSet;



   CMalfPreselectOperatorRecordSet  *pMalfPreselectOperatorRecordSet =  new  CMalfPreselectOperatorRecordSet(NULL);
   pMalfPreselectOperatorRecordSet->Open();

   while (! pMalfPreselectOperatorRecordSet->IsEOF())
   {
      m_malf_1_presel_1_operator.AddString(pMalfPreselectOperatorRecordSet->m_Preselect_Operator);
      m_malf_1_presel_2_operator.AddString(pMalfPreselectOperatorRecordSet->m_Preselect_Operator);
      m_malf_2_presel_1_operator.AddString(pMalfPreselectOperatorRecordSet->m_Preselect_Operator);
      m_malf_2_presel_2_operator.AddString(pMalfPreselectOperatorRecordSet->m_Preselect_Operator);
      m_malf_3_presel_1_operator.AddString(pMalfPreselectOperatorRecordSet->m_Preselect_Operator);
      m_malf_3_presel_2_operator.AddString(pMalfPreselectOperatorRecordSet->m_Preselect_Operator);

      pMalfPreselectOperatorRecordSet->MoveNext();
   }
   pMalfPreselectOperatorRecordSet->Close();
   delete   pMalfPreselectOperatorRecordSet;


   CMalfPreselectBooleanRecordSet  *pMalfPreselectBooleanRecordSet =  new  CMalfPreselectBooleanRecordSet(NULL);
   pMalfPreselectBooleanRecordSet->Open();

   while (! pMalfPreselectBooleanRecordSet->IsEOF())
   {
      m_malf_1_presel_logical.AddString(pMalfPreselectBooleanRecordSet->m_Preselect_Boolean);
      m_malf_2_presel_logical.AddString(pMalfPreselectBooleanRecordSet->m_Preselect_Boolean);
      m_malf_3_presel_logical.AddString(pMalfPreselectBooleanRecordSet->m_Preselect_Boolean);

      pMalfPreselectBooleanRecordSet->MoveNext();
   }
   pMalfPreselectBooleanRecordSet->Close();
   delete   pMalfPreselectBooleanRecordSet;


   CMalfDocRecordSet  *pMalfDocRecordSet =  new  CMalfDocRecordSet(NULL);
   pMalfDocRecordSet->Open();

   static CMalfListItem item;

   while (! pMalfDocRecordSet->IsEOF())
   {
      m_malf_1_combo.AddString(pMalfDocRecordSet->m_mfTitle);
      m_malf_2_combo.AddString(pMalfDocRecordSet->m_mfTitle);
      m_malf_3_combo.AddString(pMalfDocRecordSet->m_mfTitle);

      item.m_mfTitle   = pMalfDocRecordSet->m_mfTitle;
      item.m_mfLabel   = pMalfDocRecordSet->m_mfLabel;
      item.m_mfCause   = pMalfDocRecordSet->m_mfCause;
      item.m_mfEffects = pMalfDocRecordSet->m_mfEffects;

      m_MalfArray.Add(item);

      pMalfDocRecordSet->MoveNext();
   }
   pMalfDocRecordSet->Close();
   delete   pMalfDocRecordSet;

   m_malf_1_combo.SetCurSel(0);
   m_malf_2_combo.SetCurSel(0);
   m_malf_3_combo.SetCurSel(0);

   // Initialize control settings from malfunction database

   bool found = false;
   for (int i=0; i<m_MalfArray.GetSize(); i++)
   {
      if (m_MalfArray[i].m_mfLabel == m_pMalfunctionsRecordSet->m_Malfunction_1_Label)
      {
         found = true;
         break;
      }
   }
   if (found)
      m_malf_1_combo.SetCurSel(i);

   m_malf_1_presel_1_operator.SetCurSel(atoi(m_pMalfunctionsRecordSet->m_Malfunction_1_Preselect_1_Operator));
   m_malf_1_presel_1_type.SetCurSel(atoi(m_pMalfunctionsRecordSet->m_Malfunction_1_Preselect_1_Type));
   m_malf_1_presel_1_value = m_pMalfunctionsRecordSet->m_Malfunction_1_Preselect_1_Value;
   m_malf_1_presel_logical.SetCurSel(atoi(m_pMalfunctionsRecordSet->m_Malfunction_1_Preselect_Logical));
   m_malf_1_presel_2_operator.SetCurSel(atoi(m_pMalfunctionsRecordSet->m_Malfunction_1_Preselect_2_Operator));
   m_malf_1_presel_2_type.SetCurSel(atoi(m_pMalfunctionsRecordSet->m_Malfunction_1_Preselect_2_Type));
   m_malf_1_presel_2_value = m_pMalfunctionsRecordSet->m_Malfunction_1_Preselect_2_Value;

   UpdateWindowEnables_1();


   found = false;
   for (i=0; i<m_MalfArray.GetSize(); i++)
   {
      if (m_MalfArray[i].m_mfLabel == m_pMalfunctionsRecordSet->m_Malfunction_2_Label)
      {
         found = true;
         break;
      }
   }
   if (found)
      m_malf_2_combo.SetCurSel(i);

   m_malf_2_presel_1_operator.SetCurSel(atoi(m_pMalfunctionsRecordSet->m_Malfunction_2_Preselect_1_Operator));
   m_malf_2_presel_1_type.SetCurSel(atoi(m_pMalfunctionsRecordSet->m_Malfunction_2_Preselect_1_Type));
   m_malf_2_presel_1_value = m_pMalfunctionsRecordSet->m_Malfunction_2_Preselect_1_Value;
   m_malf_2_presel_logical.SetCurSel(atoi(m_pMalfunctionsRecordSet->m_Malfunction_2_Preselect_Logical));
   m_malf_2_presel_2_operator.SetCurSel(atoi(m_pMalfunctionsRecordSet->m_Malfunction_2_Preselect_2_Operator));
   m_malf_2_presel_2_type.SetCurSel(atoi(m_pMalfunctionsRecordSet->m_Malfunction_2_Preselect_2_Type));
   m_malf_2_presel_2_value = m_pMalfunctionsRecordSet->m_Malfunction_2_Preselect_2_Value;

   UpdateWindowEnables_2();


   found = false;
   for (i=0; i<m_MalfArray.GetSize(); i++)
   {
      if (m_MalfArray[i].m_mfLabel == m_pMalfunctionsRecordSet->m_Malfunction_3_Label)
      {
         found = true;
         break;
      }
   }
   if (found)
      m_malf_3_combo.SetCurSel(i);

   m_malf_3_presel_1_operator.SetCurSel(atoi(m_pMalfunctionsRecordSet->m_Malfunction_3_Preselect_1_Operator));
   m_malf_3_presel_1_type.SetCurSel(atoi(m_pMalfunctionsRecordSet->m_Malfunction_3_Preselect_1_Type));
   m_malf_3_presel_1_value = m_pMalfunctionsRecordSet->m_Malfunction_3_Preselect_1_Value;
   m_malf_3_presel_logical.SetCurSel(atoi(m_pMalfunctionsRecordSet->m_Malfunction_3_Preselect_Logical));
   m_malf_3_presel_2_operator.SetCurSel(atoi(m_pMalfunctionsRecordSet->m_Malfunction_3_Preselect_2_Operator));
   m_malf_3_presel_2_type.SetCurSel(atoi(m_pMalfunctionsRecordSet->m_Malfunction_3_Preselect_2_Type));
   m_malf_3_presel_2_value = m_pMalfunctionsRecordSet->m_Malfunction_3_Preselect_2_Value;

   UpdateWindowEnables_3();

   }

   UpdateData(FALSE);

   return TRUE;
}


void CMalfunctionsPage::OnOK() 
{
	m_pMalfunctionsRecordSet->Edit();

   m_pMalfunctionsRecordSet->m_Malfunction_1_Activation.Format("%d", m_malf_1_presel_status);
   m_pMalfunctionsRecordSet->m_Malfunction_1_Preselect_1_Operator.Format("%d", m_malf_1_presel_1_operator.GetCurSel());
   m_pMalfunctionsRecordSet->m_Malfunction_1_Preselect_1_Type.Format("%d", m_malf_1_presel_1_type.GetCurSel());
   m_pMalfunctionsRecordSet->m_Malfunction_1_Preselect_1_Value  = m_malf_1_presel_1_value;
   m_pMalfunctionsRecordSet->m_Malfunction_1_Preselect_2_Operator.Format("%d", m_malf_1_presel_2_operator.GetCurSel());
   m_pMalfunctionsRecordSet->m_Malfunction_1_Preselect_2_Type.Format("%d", m_malf_1_presel_2_type.GetCurSel());
   m_pMalfunctionsRecordSet->m_Malfunction_1_Preselect_2_Value = m_malf_1_presel_2_value;
   m_pMalfunctionsRecordSet->m_Malfunction_1_Preselect_Logical.Format("%d", m_malf_1_presel_logical.GetCurSel());
   m_pMalfunctionsRecordSet->m_Malfunction_1_Description = m_MalfArray[m_malf_1_combo.GetCurSel()].m_mfTitle;
   m_pMalfunctionsRecordSet->m_Malfunction_1_Label       = m_MalfArray[m_malf_1_combo.GetCurSel()].m_mfLabel;

   m_pMalfunctionsRecordSet->m_Malfunction_2_Activation.Format("%d", m_malf_2_presel_status);
   m_pMalfunctionsRecordSet->m_Malfunction_2_Preselect_1_Operator.Format("%d", m_malf_2_presel_1_operator.GetCurSel());
   m_pMalfunctionsRecordSet->m_Malfunction_2_Preselect_1_Type.Format("%d", m_malf_2_presel_1_type.GetCurSel());
   m_pMalfunctionsRecordSet->m_Malfunction_2_Preselect_1_Value  = m_malf_2_presel_1_value;
   m_pMalfunctionsRecordSet->m_Malfunction_2_Preselect_2_Operator.Format("%d", m_malf_2_presel_2_operator.GetCurSel());
   m_pMalfunctionsRecordSet->m_Malfunction_2_Preselect_2_Type.Format("%d", m_malf_2_presel_2_type.GetCurSel());
   m_pMalfunctionsRecordSet->m_Malfunction_2_Preselect_2_Value = m_malf_2_presel_2_value;
   m_pMalfunctionsRecordSet->m_Malfunction_2_Preselect_Logical.Format("%d", m_malf_2_presel_logical.GetCurSel());
   m_pMalfunctionsRecordSet->m_Malfunction_2_Description = m_MalfArray[m_malf_2_combo.GetCurSel()].m_mfTitle;
   m_pMalfunctionsRecordSet->m_Malfunction_2_Label       = m_MalfArray[m_malf_2_combo.GetCurSel()].m_mfLabel;

   m_pMalfunctionsRecordSet->m_Malfunction_3_Activation.Format("%d", m_malf_3_presel_status);
   m_pMalfunctionsRecordSet->m_Malfunction_3_Preselect_1_Operator.Format("%d", m_malf_3_presel_1_operator.GetCurSel());
   m_pMalfunctionsRecordSet->m_Malfunction_3_Preselect_1_Type.Format("%d", m_malf_3_presel_1_type.GetCurSel());
   m_pMalfunctionsRecordSet->m_Malfunction_3_Preselect_1_Value  = m_malf_3_presel_1_value;
   m_pMalfunctionsRecordSet->m_Malfunction_3_Preselect_2_Operator.Format("%d", m_malf_3_presel_2_operator.GetCurSel());
   m_pMalfunctionsRecordSet->m_Malfunction_3_Preselect_2_Type.Format("%d", m_malf_3_presel_2_type.GetCurSel());
   m_pMalfunctionsRecordSet->m_Malfunction_3_Preselect_2_Value = m_malf_3_presel_2_value;
   m_pMalfunctionsRecordSet->m_Malfunction_3_Preselect_Logical.Format("%d", m_malf_3_presel_logical.GetCurSel());
   m_pMalfunctionsRecordSet->m_Malfunction_3_Description = m_MalfArray[m_malf_3_combo.GetCurSel()].m_mfTitle;
   m_pMalfunctionsRecordSet->m_Malfunction_3_Label       = m_MalfArray[m_malf_3_combo.GetCurSel()].m_mfLabel;

   try
   {
      m_pMalfunctionsRecordSet->Update();
   }
   catch (CDaoException *e)
   {
      AfxMessageBox(e->m_pErrorInfo->m_strDescription);
      e->Delete();
      return;
   }
	
	CPropertyPage::OnOK();
}

void CMalfunctionsPage::OnMalfRadio11() 
{
   UpdateData(TRUE);
   UpdateWindowEnables_1();
}

void CMalfunctionsPage::OnMalfRadio21() 
{
   UpdateData(TRUE);
   UpdateWindowEnables_2();
}

void CMalfunctionsPage::OnMalfRadio31() 
{
   UpdateData(TRUE);
   UpdateWindowEnables_3();
}


//DEL void CMalfunctionsPage::OnSelchangePreselectCombo13() 
//DEL {
//DEL 	OnMalfRadio11();
//DEL }

//DEL void CMalfunctionsPage::OnSelchangePreselectCombo23() 
//DEL {
//DEL 	OnMalfRadio21();
//DEL }

//DEL void CMalfunctionsPage::OnSelchangePreselectCombo33() 
//DEL {
//DEL 	OnMalfRadio31();
//DEL }

void CMalfunctionsPage::UpdateWindowEnables_1()
{
   CWnd *pWnd0, *pWnd1, *pWnd2, *pWnd3, *pWnd4, *pWnd5, *pWnd6, *pWnd7, *pWnd8;

   pWnd0 = GetDlgItem(IDC_MALF1_COMBO);
   pWnd1 = GetDlgItem(IDC_PRESELECT_COMBO_1_1);
   pWnd2 = GetDlgItem(IDC_PRESELECT_COMBO_1_2);
   pWnd3 = GetDlgItem(IDC_PRESELECT_COMBO_1_3);
   pWnd4 = GetDlgItem(IDC_PRESELECT_COMBO_1_4);
   pWnd5 = GetDlgItem(IDC_PRESELECT_COMBO_1_5);
   pWnd6 = GetDlgItem(IDC_PRESELECT_EDIT_1_1);
   pWnd7 = GetDlgItem(IDC_PRESELECT_EDIT_1_2);
   pWnd8 = GetDlgItem(IDC_DESCRIBE_BUTTON_1);

   if (pWnd0 && pWnd1 && pWnd2 && pWnd3 && pWnd4 && pWnd5 && pWnd6 && pWnd7 && pWnd8)
   {
      if (m_malf_1_presel_status <= 0)
      {
         pWnd0->EnableWindow(FALSE);
         pWnd8->EnableWindow(FALSE);
      }
      else
      {
         pWnd0->EnableWindow(TRUE);
         pWnd8->EnableWindow(TRUE);
      }

      if (m_malf_1_presel_status == 1)
      {
         pWnd1->EnableWindow(TRUE);
         pWnd2->EnableWindow(TRUE);
         pWnd3->EnableWindow(TRUE);
         pWnd6->EnableWindow(TRUE);

         // Disable second preselect condition if not needed
         if (((CComboBox*)pWnd3)->GetCurSel() > 0)
         {
            pWnd4->EnableWindow(TRUE);
            pWnd5->EnableWindow(TRUE);
            pWnd7->EnableWindow(TRUE);
         }
         else
         {
            pWnd4->EnableWindow(FALSE);
            pWnd5->EnableWindow(FALSE);
            pWnd7->EnableWindow(FALSE);
         }
      }
      else
      {
         pWnd1->EnableWindow(FALSE);
         pWnd2->EnableWindow(FALSE);
         pWnd3->EnableWindow(FALSE);
         pWnd4->EnableWindow(FALSE);
         pWnd5->EnableWindow(FALSE);
         pWnd6->EnableWindow(FALSE);
         pWnd7->EnableWindow(FALSE);
      }
   }
}

void CMalfunctionsPage::UpdateWindowEnables_2()
{
   CWnd *pWnd0, *pWnd1, *pWnd2, *pWnd3, *pWnd4, *pWnd5, *pWnd6, *pWnd7, *pWnd8;

   pWnd0 = GetDlgItem(IDC_MALF2_COMBO);
   pWnd1 = GetDlgItem(IDC_PRESELECT_COMBO_2_1);
   pWnd2 = GetDlgItem(IDC_PRESELECT_COMBO_2_2);
   pWnd3 = GetDlgItem(IDC_PRESELECT_COMBO_2_3);
   pWnd4 = GetDlgItem(IDC_PRESELECT_COMBO_2_4);
   pWnd5 = GetDlgItem(IDC_PRESELECT_COMBO_2_5);
   pWnd6 = GetDlgItem(IDC_PRESELECT_EDIT_2_1);
   pWnd7 = GetDlgItem(IDC_PRESELECT_EDIT_2_2);
   pWnd8 = GetDlgItem(IDC_DESCRIBE_BUTTON_2);

   if (pWnd0 && pWnd1 && pWnd2 && pWnd3 && pWnd4 && pWnd5 && pWnd6 && pWnd7 && pWnd8)
   {
      if (m_malf_2_presel_status <= 0)
      {
         pWnd0->EnableWindow(FALSE);
         pWnd8->EnableWindow(FALSE);
      }
      else
      {
         pWnd0->EnableWindow(TRUE);
         pWnd8->EnableWindow(TRUE);
      }

      if (m_malf_2_presel_status == 1)
      {
         pWnd1->EnableWindow(TRUE);
         pWnd2->EnableWindow(TRUE);
         pWnd3->EnableWindow(TRUE);
         pWnd6->EnableWindow(TRUE);

         // Disable second preselect condition if not needed
         if (((CComboBox*)pWnd3)->GetCurSel() > 0)
         {
            pWnd4->EnableWindow(TRUE);
            pWnd5->EnableWindow(TRUE);
            pWnd7->EnableWindow(TRUE);
         }
         else
         {
            pWnd4->EnableWindow(FALSE);
            pWnd5->EnableWindow(FALSE);
            pWnd7->EnableWindow(FALSE);
         }
      }
      else
      {
         pWnd1->EnableWindow(FALSE);
         pWnd2->EnableWindow(FALSE);
         pWnd3->EnableWindow(FALSE);
         pWnd4->EnableWindow(FALSE);
         pWnd5->EnableWindow(FALSE);
         pWnd6->EnableWindow(FALSE);
         pWnd7->EnableWindow(FALSE);
      }
   }
}

void CMalfunctionsPage::UpdateWindowEnables_3()
{
   CWnd *pWnd0, *pWnd1, *pWnd2, *pWnd3, *pWnd4, *pWnd5, *pWnd6, *pWnd7, *pWnd8;

   pWnd0 = GetDlgItem(IDC_MALF3_COMBO);
   pWnd1 = GetDlgItem(IDC_PRESELECT_COMBO_3_1);
   pWnd2 = GetDlgItem(IDC_PRESELECT_COMBO_3_2);
   pWnd3 = GetDlgItem(IDC_PRESELECT_COMBO_3_3);
   pWnd4 = GetDlgItem(IDC_PRESELECT_COMBO_3_4);
   pWnd5 = GetDlgItem(IDC_PRESELECT_COMBO_3_5);
   pWnd6 = GetDlgItem(IDC_PRESELECT_EDIT_3_1);
   pWnd7 = GetDlgItem(IDC_PRESELECT_EDIT_3_2);
   pWnd8 = GetDlgItem(IDC_DESCRIBE_BUTTON_3);

   if (pWnd0 && pWnd1 && pWnd2 && pWnd3 && pWnd4 && pWnd5 && pWnd6 && pWnd7 && pWnd8)
   {
      if (m_malf_3_presel_status <= 0)
      {
         pWnd0->EnableWindow(FALSE);
         pWnd8->EnableWindow(FALSE);
      }
      else
      {
         pWnd0->EnableWindow(TRUE);
         pWnd8->EnableWindow(TRUE);
      }

      if (m_malf_3_presel_status == 1)
      {
         pWnd1->EnableWindow(TRUE);
         pWnd2->EnableWindow(TRUE);
         pWnd3->EnableWindow(TRUE);
         pWnd6->EnableWindow(TRUE);

         // Disable second preselect condition if not needed
         if (((CComboBox*)pWnd3)->GetCurSel() > 0)
         {
            pWnd4->EnableWindow(TRUE);
            pWnd5->EnableWindow(TRUE);
            pWnd7->EnableWindow(TRUE);
         }
         else
         {
            pWnd4->EnableWindow(FALSE);
            pWnd5->EnableWindow(FALSE);
            pWnd7->EnableWindow(FALSE);
         }
      }
      else
      {
         pWnd1->EnableWindow(FALSE);
         pWnd2->EnableWindow(FALSE);
         pWnd3->EnableWindow(FALSE);
         pWnd4->EnableWindow(FALSE);
         pWnd5->EnableWindow(FALSE);
         pWnd6->EnableWindow(FALSE);
         pWnd7->EnableWindow(FALSE);
      }
   }
}

void CMalfunctionsPage::OnDescribeButton1() 
{
	CMalfDescriptionDialog dialog;

   CComboBox *pCombo = (CComboBox *)GetDlgItem(IDC_MALF1_COMBO);

   if (pCombo)
   {
      int curSel = pCombo->GetCurSel();

      dialog.m_strTitle   = m_MalfArray[curSel].m_mfTitle;
      dialog.m_strCause   = m_MalfArray[curSel].m_mfCause;
      dialog.m_strEffects = m_MalfArray[curSel].m_mfEffects;

      dialog.DoModal();
   }
}

void CMalfunctionsPage::OnDescribeButton2() 
{
	CMalfDescriptionDialog dialog;

   CComboBox *pCombo = (CComboBox *)GetDlgItem(IDC_MALF2_COMBO);

   if (pCombo)
   {
      int curSel = pCombo->GetCurSel();

      dialog.m_strTitle   = m_MalfArray[curSel].m_mfTitle;
      dialog.m_strCause   = m_MalfArray[curSel].m_mfCause;
      dialog.m_strEffects = m_MalfArray[curSel].m_mfEffects;

      dialog.DoModal();
   }	
}

void CMalfunctionsPage::OnDescribeButton3() 
{
	CMalfDescriptionDialog dialog;

   CComboBox *pCombo = (CComboBox *)GetDlgItem(IDC_MALF3_COMBO);

   if (pCombo)
   {
      int curSel = pCombo->GetCurSel();

      dialog.m_strTitle   = m_MalfArray[curSel].m_mfTitle;
      dialog.m_strCause   = m_MalfArray[curSel].m_mfCause;
      dialog.m_strEffects = m_MalfArray[curSel].m_mfEffects;

      dialog.DoModal();
   }	
}
