// GlobalWeatherPage.cpp : implementation file
//

#include "stdafx.h"
#include "sortieedit.h"
#include "GlobalWeatherPage.h"

#include "MicroburstModelRecordSet.h"
#include "MicroburstPositionRecordSet.h"
#include "MicroburstWindshearIntensityRecordSet.h"
#include "WindshearModelRecordSet.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGlobalWeatherPage property page

IMPLEMENT_DYNCREATE(CGlobalWeatherPage, CPropertyPage)

CGlobalWeatherPage::CGlobalWeatherPage() : CPropertyPage(CGlobalWeatherPage::IDD)
{
	//{{AFX_DATA_INIT(CGlobalWeatherPage)
	m_microburst_enable = FALSE;
	m_windshear_enable = FALSE;
	m_cruise_wind_altitude = _T("");
	m_cruise_wind_direction = _T("");
	m_cruise_wind_speed = _T("");
	m_weather_mode = -1;
	m_surface_wind_altitude = _T("");
	m_turbulence_enable = FALSE;
	m_moon_azimuth = _T("");
	m_moon_elevation = _T("");
	m_moon_phase = _T("");
	//}}AFX_DATA_INIT

   m_pWeatherGlobalsRecordSet =  new   CWeatherGlobalsRecordSet(NULL);
}

CGlobalWeatherPage::~CGlobalWeatherPage()
{
   if (m_pWeatherGlobalsRecordSet->IsOpen())
      m_pWeatherGlobalsRecordSet->Close();
   delete   m_pWeatherGlobalsRecordSet;
}

void CGlobalWeatherPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGlobalWeatherPage)
	DDX_Control(pDX, IDC_COMBO_TURBULENCE_INTENSITY, m_ctrl_turbulence_intensity);
	DDX_Control(pDX, IDC_COMBO_WINDSHEAR_MODEL, m_ctrl_windshear_model);
	DDX_Control(pDX, IDC_COMBO_WINDSHEAR_INTENSITY, m_ctrl_windshear_intensity);
	DDX_Control(pDX, IDC_COMBO_MICROBURST_POSITION, m_ctrl_microburst_position);
	DDX_Control(pDX, IDC_COMBO_MICROBURST_MODEL, m_ctrl_microburst_model);
	DDX_Control(pDX, IDC_COMBO_MICROBURST_INTENSITY, m_ctrl_microburst_intensity);
	DDX_Check(pDX, IDC_CHECK_MICROBURST_ENABLE, m_microburst_enable);
	DDX_Check(pDX, IDC_CHECK_WINDSHEAR_ENABLE, m_windshear_enable);
	DDX_Text(pDX, IDC_EDIT_CRUISE_WIND_ALTITUDE, m_cruise_wind_altitude);
	DDX_Text(pDX, IDC_EDIT_CRUISE_WIND_DIRECTION, m_cruise_wind_direction);
	DDX_Text(pDX, IDC_EDIT_CRUISE_WIND_SPEED, m_cruise_wind_speed);
	DDX_Radio(pDX, IDC_RADIO_WEATHER_MODE_AUTOMATIC, m_weather_mode);
	DDX_Text(pDX, IDC_EDIT_SURFACE_WIND_ALTITUDE, m_surface_wind_altitude);
	DDX_Check(pDX, IDC_CHECK_TURBULENCE_ENABLE, m_turbulence_enable);
	DDX_Text(pDX, IDC_EDIT_MOON_AZIMUTH, m_moon_azimuth);
	DDX_Text(pDX, IDC_EDIT_MOON_ELEVATION, m_moon_elevation);
	DDX_Text(pDX, IDC_EDIT_MOON_PHASE, m_moon_phase);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGlobalWeatherPage, CPropertyPage)
	//{{AFX_MSG_MAP(CGlobalWeatherPage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGlobalWeatherPage message handlers

BOOL CGlobalWeatherPage::OnInitDialog() 
{
   CPropertyPage::OnInitDialog();

   // Populate the Microburst Model ComboBox.
   CMicroburstModelRecordSet  *pMicroburstModelRecordSet =  new   CMicroburstModelRecordSet(NULL);
   pMicroburstModelRecordSet->Open();
   m_ctrl_microburst_model.ResetContent();
   while (! pMicroburstModelRecordSet->IsEOF())
   {
      m_ctrl_microburst_model.AddString(pMicroburstModelRecordSet->m_Text);
      pMicroburstModelRecordSet->MoveNext();
   }
   pMicroburstModelRecordSet->Close();
   delete   pMicroburstModelRecordSet;


   // Populate the Microburst Position ComboBox.
   CMicroburstPositionRecordSet  *pMicroburstPositionRecordSet =  new   CMicroburstPositionRecordSet(NULL);
   pMicroburstPositionRecordSet->Open();
   m_ctrl_microburst_position.ResetContent();
   while (! pMicroburstPositionRecordSet->IsEOF())
   {
      m_ctrl_microburst_position.AddString(pMicroburstPositionRecordSet->m_Text);
      pMicroburstPositionRecordSet->MoveNext();
   }
   pMicroburstPositionRecordSet->Close();
   delete   pMicroburstPositionRecordSet;


   // Populate the Intensity ComboBoxes.
   CMicroburstWindshearIntensityRecordSet *pMicroburstWindshearIntensityRecordSet   =  new   CMicroburstWindshearIntensityRecordSet(NULL);
   pMicroburstWindshearIntensityRecordSet->Open();
   m_ctrl_microburst_intensity.ResetContent();
   m_ctrl_windshear_intensity.ResetContent();
   m_ctrl_turbulence_intensity.ResetContent();
   while (! pMicroburstWindshearIntensityRecordSet->IsEOF())
   {
      m_ctrl_microburst_intensity.AddString(pMicroburstWindshearIntensityRecordSet->m_Text);
      m_ctrl_windshear_intensity.AddString(pMicroburstWindshearIntensityRecordSet->m_Text);
      m_ctrl_turbulence_intensity.AddString(pMicroburstWindshearIntensityRecordSet->m_Text);
      pMicroburstWindshearIntensityRecordSet->MoveNext();
   }
   pMicroburstWindshearIntensityRecordSet->Close();
   delete   pMicroburstWindshearIntensityRecordSet;


   // Populate the Microburst Position ComboBox.
   CWindshearModelRecordSet  *pWindshearModelRecordSet   =  new   CWindshearModelRecordSet(NULL);
   pWindshearModelRecordSet->Open();
   m_ctrl_windshear_model.ResetContent();
   while (! pWindshearModelRecordSet->IsEOF())
   {
      m_ctrl_windshear_model.AddString(pWindshearModelRecordSet->m_Text);
      pWindshearModelRecordSet->MoveNext();
   }
   pWindshearModelRecordSet->Close();
   delete   pWindshearModelRecordSet;

  
   if (! m_pWeatherGlobalsRecordSet->IsOpen())
   {
      try
      {
         m_pWeatherGlobalsRecordSet->Open();
      }
      catch(CDaoException  *e)
      {
         AfxMessageBox(e->m_pErrorInfo->m_strDescription);
         e->Delete();
         return   TRUE;
      }
   }

   BOOL  found =  m_pWeatherGlobalsRecordSet->Find(AFX_DAO_FIRST, m_condition_for_find);
   if (found)
   {
	   m_ctrl_windshear_model     .SetCurSel(atoi(m_pWeatherGlobalsRecordSet->m_Windshear_Model));
	   m_ctrl_windshear_intensity .SetCurSel(atoi(m_pWeatherGlobalsRecordSet->m_Windshear_Intensity));
	   m_ctrl_microburst_position .SetCurSel(atoi(m_pWeatherGlobalsRecordSet->m_Microburst_Position));
	   m_ctrl_microburst_model    .SetCurSel(atoi(m_pWeatherGlobalsRecordSet->m_Microburst_Model));
	   m_ctrl_microburst_intensity.SetCurSel(atoi(m_pWeatherGlobalsRecordSet->m_Microburst_Intensity));
      m_ctrl_turbulence_intensity.SetCurSel(atoi(m_pWeatherGlobalsRecordSet->m_Turbulence_Intensity));

	   m_microburst_enable        =  (m_pWeatherGlobalsRecordSet->m_Microburst_Enable   == "1");
	   m_windshear_enable         =  (m_pWeatherGlobalsRecordSet->m_Windshear_Enable    == "1");
      m_turbulence_enable        =  (m_pWeatherGlobalsRecordSet->m_Turbulence_Enable   == "1");

      m_cruise_wind_altitude     =  m_pWeatherGlobalsRecordSet->m_Cruise_Wind_Altitude_MSL;
	   m_cruise_wind_direction    =  m_pWeatherGlobalsRecordSet->m_Cruise_Wind_Direction;
	   m_cruise_wind_speed        =  m_pWeatherGlobalsRecordSet->m_Cruise_Wind_Speed___knots;

	   m_moon_azimuth     =  m_pWeatherGlobalsRecordSet->m_Moon_Azimuth;
	   m_moon_elevation    =  m_pWeatherGlobalsRecordSet->m_Moon_Elevation;
	   m_moon_phase        =  m_pWeatherGlobalsRecordSet->m_Moon_Phase;

      m_surface_wind_altitude    =  m_pWeatherGlobalsRecordSet->m_Surface_Wind_Altitude_AGL;

      m_weather_mode             =  atoi(m_pWeatherGlobalsRecordSet->m_Weather_Mode);
   }


   UpdateData(FALSE);

   return   TRUE; // return TRUE unless you set the focus to a control
	               // EXCEPTION: OCX Property Pages should return FALSE
}

void CGlobalWeatherPage::OnOK() 
{
   m_pWeatherGlobalsRecordSet->Edit();

	m_pWeatherGlobalsRecordSet->m_Windshear_Model            .Format("%d", m_ctrl_windshear_model.GetCurSel());
	m_pWeatherGlobalsRecordSet->m_Windshear_Intensity        .Format("%d", m_ctrl_windshear_intensity.GetCurSel());
	m_pWeatherGlobalsRecordSet->m_Microburst_Position        .Format("%d", m_ctrl_microburst_position.GetCurSel());
	m_pWeatherGlobalsRecordSet->m_Microburst_Model           .Format("%d", m_ctrl_microburst_model.GetCurSel());
	m_pWeatherGlobalsRecordSet->m_Microburst_Intensity       .Format("%d", m_ctrl_microburst_intensity.GetCurSel());
   m_pWeatherGlobalsRecordSet->m_Turbulence_Intensity       .Format("%d", m_ctrl_turbulence_intensity.GetCurSel());

	m_pWeatherGlobalsRecordSet->m_Microburst_Enable          .Format("%d", m_microburst_enable);
	m_pWeatherGlobalsRecordSet->m_Windshear_Enable           .Format("%d", m_windshear_enable);
	m_pWeatherGlobalsRecordSet->m_Weather_Mode               .Format("%d", m_weather_mode);
   m_pWeatherGlobalsRecordSet->m_Turbulence_Enable          .Format("%d", m_turbulence_enable);

   m_pWeatherGlobalsRecordSet->m_Cruise_Wind_Altitude_MSL   =  m_cruise_wind_altitude;
	m_pWeatherGlobalsRecordSet->m_Cruise_Wind_Direction      =  m_cruise_wind_direction;
	m_pWeatherGlobalsRecordSet->m_Cruise_Wind_Speed___knots  =  m_cruise_wind_speed;

	 m_pWeatherGlobalsRecordSet->m_Moon_Azimuth   =  m_moon_azimuth;
	m_pWeatherGlobalsRecordSet->m_Moon_Elevation      =  m_moon_elevation;
	m_pWeatherGlobalsRecordSet->m_Moon_Phase  =  m_moon_phase;

   m_pWeatherGlobalsRecordSet->m_Surface_Wind_Altitude_AGL  =  m_surface_wind_altitude;

   try
   {
      m_pWeatherGlobalsRecordSet->Update();
   }
   catch (CDaoException *e)
   {
      AfxMessageBox(e->m_pErrorInfo->m_strDescription);
      e->Delete();
      return;
   }

   CPropertyPage::OnOK();
}
