// EditablelRecordSets.cpp: implementation of the CEditableRecordSets class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "sortieedit.h"
#include "EditableRecordSets.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CEditableRecordSets::CEditableRecordSets()
{
   m_pSortieSet               =  new   CSortieRecordSet(NULL);
   m_pSortieSet->Open();

   m_pAircraftConfigRecordSet =  new   CAircraftConfigRecordSet(NULL);
   m_pAircraftConfigRecordSet->Open();

   m_pWeatherGlobalsRecordSet =  new   CWeatherGlobalsRecordSet(NULL);
   m_pWeatherGlobalsRecordSet->Open();

   m_pAreaMapRecordSet        =  new   CAreaMapRecordSet(NULL);
   m_pAreaMapRecordSet->Open();

   m_pRepositionRecordSet     =  new   CRepositionRecordSet(NULL);
   m_pRepositionRecordSet->Open();

   m_pSymbolDisplayRecordSet  =  new   CSymbolDisplayRecordSet(NULL);
   m_pSymbolDisplayRecordSet->Open();

   m_pThreatsRecordSet        =  new   CThreatsRecordSet(NULL);
   m_pThreatsRecordSet->Open();

   m_pWeatherArea1RecordSet   =  new   CWeatherArea1RecordSet(NULL);
   m_pWeatherArea1RecordSet->Open();

   m_pWeatherArea2RecordSet   =  new   CWeatherArea2RecordSet(NULL);
   m_pWeatherArea2RecordSet->Open();

   m_pWeatherArea3RecordSet   =  new   CWeatherArea3RecordSet(NULL);
   m_pWeatherArea3RecordSet->Open();

   m_pWeatherArea4RecordSet   =  new   CWeatherArea4RecordSet(NULL);
   m_pWeatherArea4RecordSet->Open();

   m_pRecordingsRecordSet     =  new   CRecordingsRecordSet(NULL);
   m_pRecordingsRecordSet->Open();

   m_pMalfunctionsRecordSet   =  new   CMalfunctionsRecordSet(NULL);
   m_pMalfunctionsRecordSet->Open();
}


CEditableRecordSets::~CEditableRecordSets()
{
   m_pSortieSet->Close();
   delete   m_pSortieSet;

   m_pAircraftConfigRecordSet->Close();
   delete   m_pAircraftConfigRecordSet;

   m_pWeatherGlobalsRecordSet->Close();
   delete   m_pWeatherGlobalsRecordSet;

   m_pAreaMapRecordSet->Close();
   delete   m_pAreaMapRecordSet;

   m_pRepositionRecordSet->Close();
   delete   m_pRepositionRecordSet;

   m_pSymbolDisplayRecordSet->Close();
   delete   m_pSymbolDisplayRecordSet;

   m_pThreatsRecordSet->Close();
   delete   m_pThreatsRecordSet;

   m_pWeatherArea1RecordSet->Close();
   delete   m_pWeatherArea1RecordSet;

   m_pWeatherArea2RecordSet->Close();
   delete   m_pWeatherArea2RecordSet;

   m_pWeatherArea3RecordSet->Close();
   delete   m_pWeatherArea3RecordSet;

   m_pWeatherArea4RecordSet->Close();
   delete   m_pWeatherArea4RecordSet;

   m_pRecordingsRecordSet->Close();
   delete   m_pRecordingsRecordSet;

   m_pMalfunctionsRecordSet->Close();
   delete   m_pMalfunctionsRecordSet;
}


void  CEditableRecordSets::Add(void)
{
   m_pSortieSet->AddNew();
   m_pSortieSet->SetFieldNull(&(m_pSortieSet->m_Base_ID), FALSE);
   m_pSortieSet->m_Base_ID             =  m_base;
   m_pSortieSet->SetFieldNull(&(m_pSortieSet->m_Lesson_ID), FALSE);
   m_pSortieSet->m_Lesson_ID           =  m_lesson_title;
   m_pSortieSet->m_Sortie_Description  =  m_lesson_description;
   try
   {
      m_pSortieSet->Update();
   }
   catch (CDaoException *e)
   {
      AfxMessageBox(e->m_pErrorInfo->m_strDescription);
      e->Delete();
      return;
   }


   m_pAircraftConfigRecordSet->AddNew();
   m_pAircraftConfigRecordSet->SetFieldNull(&(m_pAircraftConfigRecordSet->m_Base_ID), FALSE);
   m_pAircraftConfigRecordSet->m_Base_ID    =  m_base;
   m_pAircraftConfigRecordSet->SetFieldNull(&(m_pAircraftConfigRecordSet->m_Lesson_ID), FALSE);
   m_pAircraftConfigRecordSet->m_Lesson_ID  =  m_lesson_title;
   try
   {
      m_pAircraftConfigRecordSet->Update();
   }
   catch (CDaoException *e)
   {
      AfxMessageBox(e->m_pErrorInfo->m_strDescription);
      e->Delete();
      return;
   }


   m_pWeatherGlobalsRecordSet->AddNew();
   m_pWeatherGlobalsRecordSet->SetFieldNull(&(m_pWeatherGlobalsRecordSet->m_Base_ID), FALSE);
   m_pWeatherGlobalsRecordSet->m_Base_ID    =  m_base;
   m_pWeatherGlobalsRecordSet->SetFieldNull(&(m_pWeatherGlobalsRecordSet->m_Lesson_ID), FALSE);
   m_pWeatherGlobalsRecordSet->m_Lesson_ID  =  m_lesson_title;
   try
   {
      m_pWeatherGlobalsRecordSet->Update();
   }
   catch (CDaoException *e)
   {
      AfxMessageBox(e->m_pErrorInfo->m_strDescription);
      e->Delete();
      return;
   }


   m_pAreaMapRecordSet->AddNew();
   m_pAreaMapRecordSet->SetFieldNull(&(m_pAreaMapRecordSet->m_Base_ID), FALSE);
   m_pAreaMapRecordSet->m_Base_ID    =  m_base;
   m_pAreaMapRecordSet->SetFieldNull(&(m_pAreaMapRecordSet->m_Lesson_ID), FALSE);
   m_pAreaMapRecordSet->m_Lesson_ID  =  m_lesson_title;
   try
   {
      m_pAreaMapRecordSet->Update();
   }
   catch (CDaoException *e)
   {
      AfxMessageBox(e->m_pErrorInfo->m_strDescription);
      e->Delete();
      return;
   }


   m_pRepositionRecordSet->AddNew();
   m_pRepositionRecordSet->SetFieldNull(&(m_pRepositionRecordSet->m_Base_ID), FALSE);
   m_pRepositionRecordSet->m_Base_ID    =  m_base;
   m_pRepositionRecordSet->SetFieldNull(&(m_pRepositionRecordSet->m_Lesson_ID), FALSE);
   m_pRepositionRecordSet->m_Lesson_ID  =  m_lesson_title;
   try
   {
      m_pRepositionRecordSet->Update();
   }
   catch (CDaoException *e)
   {
      AfxMessageBox(e->m_pErrorInfo->m_strDescription);
      e->Delete();
      return;
   }


   m_pSymbolDisplayRecordSet->AddNew();
   m_pSymbolDisplayRecordSet->SetFieldNull(&(m_pSymbolDisplayRecordSet->m_Base_ID), FALSE);
   m_pSymbolDisplayRecordSet->m_Base_ID    =  m_base;
   m_pSymbolDisplayRecordSet->SetFieldNull(&(m_pSymbolDisplayRecordSet->m_Lesson_ID), FALSE);
   m_pSymbolDisplayRecordSet->m_Lesson_ID  =  m_lesson_title;
   try
   {
      m_pSymbolDisplayRecordSet->Update();
   }
   catch (CDaoException *e)
   {
      AfxMessageBox(e->m_pErrorInfo->m_strDescription);
      e->Delete();
      return;
   }


   m_pThreatsRecordSet->AddNew();
   m_pThreatsRecordSet->SetFieldNull(&(m_pThreatsRecordSet->m_Base_ID), FALSE);
   m_pThreatsRecordSet->m_Base_ID    =  m_base;
   m_pThreatsRecordSet->SetFieldNull(&(m_pThreatsRecordSet->m_Lesson_ID), FALSE);
   m_pThreatsRecordSet->m_Lesson_ID  =  m_lesson_title;
   try
   {
      m_pThreatsRecordSet->Update();
   }
   catch (CDaoException *e)
   {
      AfxMessageBox(e->m_pErrorInfo->m_strDescription);
      e->Delete();
      return;
   }


   m_pWeatherArea1RecordSet->AddNew();
   m_pWeatherArea1RecordSet->SetFieldNull(&(m_pWeatherArea1RecordSet->m_Base_ID), FALSE);
   m_pWeatherArea1RecordSet->m_Base_ID    =  m_base;
   m_pWeatherArea1RecordSet->SetFieldNull(&(m_pWeatherArea1RecordSet->m_Lesson_ID), FALSE);
   m_pWeatherArea1RecordSet->m_Lesson_ID  =  m_lesson_title;
   try
   {
      m_pWeatherArea1RecordSet->Update();
   }
   catch (CDaoException *e)
   {
      AfxMessageBox(e->m_pErrorInfo->m_strDescription);
      e->Delete();
      return;
   }


   m_pWeatherArea2RecordSet->AddNew();
   m_pWeatherArea2RecordSet->SetFieldNull(&(m_pWeatherArea2RecordSet->m_Base_ID), FALSE);
   m_pWeatherArea2RecordSet->m_Base_ID    =  m_base;
   m_pWeatherArea2RecordSet->SetFieldNull(&(m_pWeatherArea2RecordSet->m_Lesson_ID), FALSE);
   m_pWeatherArea2RecordSet->m_Lesson_ID  =  m_lesson_title;
   try
   {
      m_pWeatherArea2RecordSet->Update();
   }
   catch (CDaoException *e)
   {
      AfxMessageBox(e->m_pErrorInfo->m_strDescription);
      e->Delete();
      return;
   }


   m_pWeatherArea3RecordSet->AddNew();
   m_pWeatherArea3RecordSet->SetFieldNull(&(m_pWeatherArea3RecordSet->m_Base_ID), FALSE);
   m_pWeatherArea3RecordSet->m_Base_ID    =  m_base;
   m_pWeatherArea3RecordSet->SetFieldNull(&(m_pWeatherArea3RecordSet->m_Lesson_ID), FALSE);
   m_pWeatherArea3RecordSet->m_Lesson_ID  =  m_lesson_title;
   try
   {
      m_pWeatherArea3RecordSet->Update();
   }
   catch (CDaoException *e)
   {
      AfxMessageBox(e->m_pErrorInfo->m_strDescription);
      e->Delete();
      return;
   }


   m_pWeatherArea4RecordSet->AddNew();
   m_pWeatherArea4RecordSet->SetFieldNull(&(m_pWeatherArea4RecordSet->m_Base_ID), FALSE);
   m_pWeatherArea4RecordSet->m_Base_ID    =  m_base;
   m_pWeatherArea4RecordSet->SetFieldNull(&(m_pWeatherArea4RecordSet->m_Lesson_ID), FALSE);
   m_pWeatherArea4RecordSet->m_Lesson_ID  =  m_lesson_title;
   try
   {
      m_pWeatherArea4RecordSet->Update();
   }
   catch (CDaoException *e)
   {
      AfxMessageBox(e->m_pErrorInfo->m_strDescription);
      e->Delete();
      return;
   }


   m_pRecordingsRecordSet->AddNew();
   m_pRecordingsRecordSet->SetFieldNull(&(m_pRecordingsRecordSet->m_Base_ID), FALSE);
   m_pRecordingsRecordSet->m_Base_ID   =  m_base;
   m_pRecordingsRecordSet->SetFieldNull(&(m_pRecordingsRecordSet->m_Lesson_ID), FALSE);
   m_pRecordingsRecordSet->m_Lesson_ID =  m_lesson_title;
   try
   {
      m_pRecordingsRecordSet->Update();
   }
   catch (CDaoException *e)
   {
      AfxMessageBox(e->m_pErrorInfo->m_strDescription);
      e->Delete();
      return;
   }


   m_pMalfunctionsRecordSet->AddNew();
   m_pMalfunctionsRecordSet->SetFieldNull(&(m_pMalfunctionsRecordSet->m_Base_ID), FALSE);
   m_pMalfunctionsRecordSet->m_Base_ID   =  m_base;
   m_pMalfunctionsRecordSet->SetFieldNull(&(m_pMalfunctionsRecordSet->m_Lesson_ID), FALSE);
   m_pMalfunctionsRecordSet->m_Lesson_ID =  m_lesson_title;
   try
   {
      m_pMalfunctionsRecordSet->Update();
   }
   catch (CDaoException *e)
   {
      AfxMessageBox(e->m_pErrorInfo->m_strDescription);
      e->Delete();
      return;
   }
}


void  CEditableRecordSets::Delete(void)
{
   BOOL     found =  false;
   CString  condition;
   condition.Format("[Base ID] = '%s' AND [Lesson ID] = '%s'", m_base, m_lesson_title);

   if (m_pSortieSet->Find(AFX_DAO_FIRST, condition))
   {
      try
      {
         m_pSortieSet->Delete();
      }
      catch (CDaoException *e)
      {
         AfxMessageBox(e->m_pErrorInfo->m_strDescription);
         e->Delete();
         return;
      }
   }


   if (m_pAircraftConfigRecordSet->Find(AFX_DAO_FIRST, condition))
   {
      try
      {
         m_pAircraftConfigRecordSet->Delete();
      }
      catch (CDaoException *e)
      {
         AfxMessageBox(e->m_pErrorInfo->m_strDescription);
         e->Delete();
         return;
      }
   }


   if (m_pWeatherGlobalsRecordSet->Find(AFX_DAO_FIRST, condition))
   {
      try
      {
         m_pWeatherGlobalsRecordSet->Delete();
      }
      catch (CDaoException *e)
      {
         AfxMessageBox(e->m_pErrorInfo->m_strDescription);
         e->Delete();
         return;
      }
   }


   if (m_pAreaMapRecordSet->Find(AFX_DAO_FIRST, condition))
   {
      try
      {
         m_pAreaMapRecordSet->Delete();
      }
      catch (CDaoException *e)
      {
         AfxMessageBox(e->m_pErrorInfo->m_strDescription);
         e->Delete();
         return;
      }
   }


   if (m_pRepositionRecordSet->Find(AFX_DAO_FIRST, condition))
   {
      try
      {
         m_pRepositionRecordSet->Delete();
      }
      catch (CDaoException *e)
      {
         AfxMessageBox(e->m_pErrorInfo->m_strDescription);
         e->Delete();
         return;
      }
   }


   if (m_pSymbolDisplayRecordSet->Find(AFX_DAO_FIRST, condition))
   {
      try
      {
         m_pSymbolDisplayRecordSet->Delete();
      }
      catch (CDaoException *e)
      {
         AfxMessageBox(e->m_pErrorInfo->m_strDescription);
         e->Delete();
         return;
      }
   }


   if (m_pThreatsRecordSet->Find(AFX_DAO_FIRST, condition))
   {
      try
      {
         m_pThreatsRecordSet->Delete();
      }
      catch (CDaoException *e)
      {
         AfxMessageBox(e->m_pErrorInfo->m_strDescription);
         e->Delete();
         return;
      }
   }


   if (m_pWeatherArea1RecordSet->Find(AFX_DAO_FIRST, condition))
   {
      try
      {
         m_pWeatherArea1RecordSet->Delete();
      }
      catch (CDaoException *e)
      {
         AfxMessageBox(e->m_pErrorInfo->m_strDescription);
         e->Delete();
         return;
      }
   }


   if (m_pWeatherArea2RecordSet->Find(AFX_DAO_FIRST, condition))
   {
      try
      {
         m_pWeatherArea2RecordSet->Delete();
      }
      catch (CDaoException *e)
      {
         AfxMessageBox(e->m_pErrorInfo->m_strDescription);
         e->Delete();
         return;
      }
   }


   if (m_pWeatherArea3RecordSet->Find(AFX_DAO_FIRST, condition))
   {
      try
      {
         m_pWeatherArea3RecordSet->Delete();
      }
      catch (CDaoException *e)
      {
         AfxMessageBox(e->m_pErrorInfo->m_strDescription);
         e->Delete();
         return;
      }
   }


   if (m_pWeatherArea4RecordSet->Find(AFX_DAO_FIRST, condition))
   {
      try
      {
         m_pWeatherArea4RecordSet->Delete();
      }
      catch (CDaoException *e)
      {
         AfxMessageBox(e->m_pErrorInfo->m_strDescription);
         e->Delete();
         return;
      }
   }

   if (m_pRecordingsRecordSet->Find(AFX_DAO_FIRST, condition))
   {
      try
      {
         m_pRecordingsRecordSet->Delete();
      }
      catch (CDaoException *e)
      {
         AfxMessageBox(e->m_pErrorInfo->m_strDescription);
         e->Delete();
         return;
      }
   }


   if (m_pMalfunctionsRecordSet->Find(AFX_DAO_FIRST, condition))
   {
      try
      {
         m_pMalfunctionsRecordSet->Delete();
      }
      catch (CDaoException *e)
      {
         AfxMessageBox(e->m_pErrorInfo->m_strDescription);
         e->Delete();
         return;
      }
   }
}