// ConfigurationPage.cpp : implementation file
//

#include "stdafx.h"
#include "sortieedit.h"
#include "ConfigurationPage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CConfigurationPage property page

IMPLEMENT_DYNCREATE(CConfigurationPage, CPropertyPage)

CConfigurationPage::CConfigurationPage() : CPropertyPage(CConfigurationPage::IDD)
{
	//{{AFX_DATA_INIT(CConfigurationPage)
	m_external_power = FALSE;
	m_gear_warn_mute = FALSE;
	m_master_light_level_activate = FALSE;
	m_overspeed_mute = FALSE;
	m_quick_start = FALSE;
	m_wheel_chocks = FALSE;
	m_left_fuel = _T("");
	m_master_light_level = _T("");
	m_right_fuel = _T("");
	m_number_of_pilots = -1;
	m_chatter_status = -1;
        m_display_propeller = FALSE;
        m_rear_seat_view = FALSE;
	//}}AFX_DATA_INIT

   m_pAircraftConfigRecordSet =  new   CAircraftConfigRecordSet(NULL);
}

CConfigurationPage::~CConfigurationPage()
{
   if (m_pAircraftConfigRecordSet->IsOpen())
      m_pAircraftConfigRecordSet->Close();
   delete   m_pAircraftConfigRecordSet;
}

void CConfigurationPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CConfigurationPage)
	DDX_Check(pDX, IDC_CHECK_EXTERNAL_POWER, m_external_power);
	DDX_Check(pDX, IDC_CHECK_GEAR_WARN_MUTE, m_gear_warn_mute);
	DDX_Check(pDX, IDC_CHECK_MASTER_LIGHT_LEVEL_ACTIVATE, m_master_light_level_activate);
	DDX_Check(pDX, IDC_CHECK_OVERSPEED_MUTE, m_overspeed_mute);
	DDX_Check(pDX, IDC_CHECK_QUICKSTART, m_quick_start);
	DDX_Check(pDX, IDC_CHECK_WHEEL_CHOCKS, m_wheel_chocks);
	DDX_Text(pDX, IDC_EDIT_LEFT_FUEL, m_left_fuel);
	DDX_Text(pDX, IDC_EDIT_MASTER_LIGHT_LEVEL, m_master_light_level);
	DDX_Text(pDX, IDC_EDIT_RIGHT_FUEL, m_right_fuel);
	DDX_Radio(pDX, IDC_RADIO_1_PILOT, m_number_of_pilots);
	DDX_Radio(pDX, IDC_RADIO_CHATTER_OFF, m_chatter_status);
	DDX_Check(pDX, IDC_CHECK_DISPLAY_PROPELLER, m_display_propeller);
	DDX_Check(pDX, IDC_CHECK_REAR_SEAT_VIEW, m_rear_seat_view);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CConfigurationPage, CPropertyPage)
	//{{AFX_MSG_MAP(CConfigurationPage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConfigurationPage message handlers

BOOL CConfigurationPage::OnInitDialog() 
{
   if (! m_pAircraftConfigRecordSet->IsOpen())
   {
      try
      {
         m_pAircraftConfigRecordSet->Open();
      }
      catch(CDaoException  *e)
      {
         AfxMessageBox(e->m_pErrorInfo->m_strDescription);
         e->Delete();
         return   TRUE;
      }
   }

   BOOL  found =  m_pAircraftConfigRecordSet->Find(AFX_DAO_FIRST, m_condition_for_find);
   if (found)
   {
	   m_external_power              =  (m_pAircraftConfigRecordSet->m_External_Power               == "1");
	   m_gear_warn_mute              =  (m_pAircraftConfigRecordSet->m_Gear_Warning_Mute            == "1");
	   m_master_light_level_activate =  (m_pAircraftConfigRecordSet->m_Master_Light_Level_Activate  == "1");
	   m_overspeed_mute              =  (m_pAircraftConfigRecordSet->m_Overspeed_Mute               == "1");
	   m_quick_start                 =  (m_pAircraftConfigRecordSet->m_Quickstart                   == "1");
	   m_wheel_chocks                =  (m_pAircraftConfigRecordSet->m_Wheel_Chocks                 == "1");
	   m_left_fuel                   =  m_pAircraftConfigRecordSet->m_Left_Fuel_Quantity;
	   m_master_light_level          =  m_pAircraftConfigRecordSet->m_Master_Light_Level;
	   m_right_fuel                  =  m_pAircraftConfigRecordSet->m_Right_Fuel_Quantity;
	   m_number_of_pilots            =  atoi(m_pAircraftConfigRecordSet->m_Number_of_Pilots)  -  1; // Control is zero based.
	   m_chatter_status              =  atoi(m_pAircraftConfigRecordSet->m_Chatter_Rate);
	   m_display_propeller           =  (m_pAircraftConfigRecordSet->m_Display_Propeller            == "1");
	   m_rear_seat_view              =  (m_pAircraftConfigRecordSet->m_Rear_Seat_View               == "1");
   }


   CPropertyPage::OnInitDialog();
	
   return   TRUE; // return TRUE unless you set the focus to a control
	               // EXCEPTION: OCX Property Pages should return FALSE
}

void CConfigurationPage::OnOK() 
{
   m_pAircraftConfigRecordSet->Edit();

	m_pAircraftConfigRecordSet->m_External_Power             .Format("%d", m_external_power               );
	m_pAircraftConfigRecordSet->m_Gear_Warning_Mute          .Format("%d", m_gear_warn_mute               );
	m_pAircraftConfigRecordSet->m_Master_Light_Level_Activate.Format("%d", m_master_light_level_activate  );
	m_pAircraftConfigRecordSet->m_Overspeed_Mute             .Format("%d", m_overspeed_mute               );
	m_pAircraftConfigRecordSet->m_Quickstart                 .Format("%d", m_quick_start                  );
	m_pAircraftConfigRecordSet->m_Wheel_Chocks               .Format("%d", m_wheel_chocks                 );
	m_pAircraftConfigRecordSet->m_Left_Fuel_Quantity         =  m_left_fuel;
	m_pAircraftConfigRecordSet->m_Master_Light_Level         =  m_master_light_level;
	m_pAircraftConfigRecordSet->m_Right_Fuel_Quantity        =  m_right_fuel;
	m_pAircraftConfigRecordSet->m_Number_of_Pilots           .Format("%d", m_number_of_pilots +  1        );
	m_pAircraftConfigRecordSet->m_Chatter_Rate               .Format("%d", m_chatter_status               );
	m_pAircraftConfigRecordSet->m_Display_Propeller          .Format("%d", m_display_propeller            );
	m_pAircraftConfigRecordSet->m_Rear_Seat_View             .Format("%d", m_rear_seat_view               );

   try
   {
      m_pAircraftConfigRecordSet->Update();
   }
   catch (CDaoException *e)
   {
      AfxMessageBox(e->m_pErrorInfo->m_strDescription);
      e->Delete();
      return;
   }

   CPropertyPage::OnOK();
}
