// AddLesson.cpp : implementation file
//

#include "stdafx.h"
#include "sortieedit.h"
#include "AddLesson.h"
#include "EditableRecordSets.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAddLesson dialog


CAddLesson::CAddLesson(CWnd* pParent /*=NULL*/)
	: CDialog(CAddLesson::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAddLesson)
	m_lesson_description = _T("");
	m_lesson_title = _T("");
	//}}AFX_DATA_INIT
}


void CAddLesson::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAddLesson)
	DDX_Text(pDX, IDC_EDIT_LESSON_DESCRIPTION, m_lesson_description);
	DDX_Text(pDX, IDC_EDIT_LESSON_TITLE, m_lesson_title);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAddLesson, CDialog)
	//{{AFX_MSG_MAP(CAddLesson)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAddLesson message handlers

void CAddLesson::OnOK() 
{
   UpdateData(TRUE);

   if (m_lesson_title.IsEmpty())
   {
      AfxMessageBox("You must enter a lesson title.");
      GotoDlgCtrl(GetDlgItem(IDC_EDIT_LESSON_TITLE));
      return;
   }

   if (m_lesson_description.IsEmpty())
   {
      AfxMessageBox("You must enter a lesson description.");
      GotoDlgCtrl(GetDlgItem(IDC_EDIT_LESSON_DESCRIPTION));
      return;
   }

   CString  condition;
   condition.Format("[Base ID] = '%s' AND [Lesson ID] = '%s'", m_base, m_lesson_title);
   BOOL  found =  m_pSortieSet->Find(AFX_DAO_FIRST, condition);
   if (found)
   {
      CString  error;
      error.Format("Lesson %s already exists for Base %s\nPlease choose a different lesson title.", m_lesson_title, m_base);
      AfxMessageBox(error);
      GotoDlgCtrl(GetDlgItem(IDC_EDIT_LESSON_TITLE));
      return;
   }


   CEditableRecordSets  editableRecordSets;
   editableRecordSets.m_base                 =  m_base;
   editableRecordSets.m_lesson_title         =  m_lesson_title;
   editableRecordSets.m_lesson_description   =  m_lesson_description;
   editableRecordSets.Add();

   m_pSortieSet->Requery();

   CDialog::OnOK();
}

BOOL CAddLesson::OnInitDialog() 
{
   CString  title;
   GetWindowText(title);
   SetWindowText(title  +  " @ "  +  m_base);

   CDialog::OnInitDialog();

   return   TRUE; // return TRUE unless you set the focus to a control
	               // EXCEPTION: OCX Property Pages should return FALSE
}
